/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions;

import com.google.gson.JsonObject;
import com.google.refine.expr.HasFields;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class HasField
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object v = args[0];
            Object f = args[1];
            if (v != null && f instanceof String) {
                String name = (String)f;
                if (v instanceof HasFields) {
                    return ((HasFields)v).getField(name, bindings) != null;
                }
                if (v instanceof JSONObject) {
                    try {
                        return ((JSONObject)v).get(name) != null;
                    }
                    catch (JSONException jSONException) {
                    }
                } else if (v instanceof JsonObject) {
                    return ((JsonObject)v).get(name) != null;
                }
            }
        }
        return false;
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.HasField.DOCUMENTATION", "Returns whether <code>o</code> has field <code>name</code>.").withParams("o, string name").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.OBJECT", "Object functions").withExample(Example.with("parseJson('{\"\"name\"\": \"\"joe\"\", \"\"age\"\": 42 }')", "\"age\"").returns("true"));
    }
}

