(function() {
'use strict';

var app = angular.module('dataiku.controllers');

 // TODO : move those controllers !!


 app.controller('ConfirmDialogController', function($scope) {
    // Focus should already have been stolen in the
    // template, but sometimes it does not work ...
    window.setTimeout(function(){
        $(":focus").blur()
    }, 0);
    $scope.confirm = function() {
       if($scope.acceptDeferred) {
           $scope.acceptDeferred.resolve("Accepted");
       }
       $scope.acceptDeferred = null;
       $scope.dismiss();
   };
   $scope.cancel = function() {
       if($scope.acceptDeferred) {
           $scope.acceptDeferred.reject("Cancelled");
       }
       $scope.acceptDeferred = null;
       $scope.dismiss();
   };
});


app.controller('PromptDialogController', function($scope) {
    $scope.confirm = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve($scope.value);
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
});


app.controller('SelectDialogController', function($scope) {
    $scope.confirm = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve($scope.selectedItem);
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
    $scope.selectItem = function(item) {
        if (item.selectable != false) {
            $scope.selectedItem = item;
        }
    };

});

app.controller('ConflictDialogController', function($scope) {
    $scope.erase = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve("erase");
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };

    $scope.cancel = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.reject();
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };

    $scope.forget = function() {
        if($scope.acceptDeferred) {
            $scope.acceptDeferred.resolve("ignore");
        }
        $scope.acceptDeferred = null;
        $scope.dismiss();
    };
});

app.controller('PasteModalController', function($scope, DetectUtils, WT1) {
    $scope.os = DetectUtils.getOS();

    $scope.uiState = {
        editMode: true,
        hasError: false,
        items: [],
        type: ''
    };

    $scope.validateData = $scope.validateData || (() => true);

    $scope.onPasteText = function(event) {
        let data = {};

        try {
            data = JSON.parse(event.originalEvent.clipboardData.getData('text/plain'));
        } catch (e) { /* Nothing for now */ }
        if (typeof $scope.applyGenericFormat === 'function') {
            data = $scope.applyGenericFormat(data);
        }
        if (data[$scope.itemKey] 
            && data[$scope.itemKey].length 
            && $scope.copyType === data.type
            && $scope.validateData(data[$scope.itemKey])) {
            let items = data[$scope.itemKey];

            if (typeof $scope.formatData === 'function') {
                items = $scope.formatData(data[$scope.itemKey]);
            }

            $scope.uiState.editMode = false;
            $scope.uiState.hasError = false;
            $scope.uiState.items = items;
            $scope.uiState.type = data.type;
        } else {
            $scope.uiState.hasError = true;
        }

        event.preventDefault();
    };

    $scope.confirm = function(data) {
        $scope.pasteItems($scope.uiState.items, data);
        WT1.event('paste-modal-submit', { dataType: $scope.uiState.type });
        $scope.dismiss();
    };
});

app.controller('ShareInWorkspaceDialogController', function($scope, DataikuAPI, $state, WorkspaceDisplayService, WT1) {
    const shareInWorkspaceDialogCtrl = this;

    // Exposed objects
    shareInWorkspaceDialogCtrl.modalTitle = undefined;
    shareInWorkspaceDialogCtrl.selectedObjects = undefined;
    shareInWorkspaceDialogCtrl.share = share;
    shareInWorkspaceDialogCtrl.workspaceKey = undefined;
    shareInWorkspaceDialogCtrl.workspacesList = [];
    shareInWorkspaceDialogCtrl.isObjectAuthorized = undefined;

    //////////////////

    let succeeded = false;

    $scope.init = (selectedObjects) => {
        shareInWorkspaceDialogCtrl.selectedObjects = selectedObjects;
        shareInWorkspaceDialogCtrl.modalTitle = getModalTitle(shareInWorkspaceDialogCtrl.selectedObjects);
        shareInWorkspaceDialogCtrl.numObjectsToShare = 0;
        WT1.event('workspaces-add-object-open', { from: 'share' });

        if (!selectedObjects.every(object => (object.reference && object.reference.type === 'DASHBOARD') || object.appId)) {
            const projectKey = selectedObjects[0].reference.projectKey;
            DataikuAPI.projects.getDashboardAuthorizations(projectKey, false).noSpinner().success(data => {
                if (!data.allAuthorized) {
                    shareInWorkspaceDialogCtrl.numObjectsToShare = selectedObjects.reduce((result, object) => {
                        if (object.reference.type === 'DASHBOARD' ||
                            data.authorizations.find(({ objectRef, modes }) => 
                                objectRef.objectId === object.reference.id &&
                                objectRef.objectType === object.reference.type &&
                                modes.includes('READ')
                            )
                        ) {
                            return result;
                        }
                        return result + 1;
                    }, 0);
                }
            }).error(setErrorInScope.bind($scope));
        }
    };

    $scope.$on('$destroy', () => {
        if (!succeeded) {
            WT1.event('workspaces-add-object-cancel', { from: 'share' });
        }
    });

    function getModalTitle(selectedObjects) {
        let modalTitle;

        switch (selectedObjects.length) {
            case 1:
                if (selectedObjects[0].reference) {
                    modalTitle = `Publish ${selectedObjects[0].reference.type.toLowerCase()} in workspace`;
                } else if (selectedObjects[0].appId) {
                    modalTitle = "Publish application in workspace";
                } else {
                    modalTitle = "Publish object on a workspace";
                }
            break;
            default:
                modalTitle = `Share ${ selectedObjects.length } objects in workspace`;
            break;
        }
        return modalTitle;
    }

    DataikuAPI.workspaces.list("WRITE").success(workspacesList => {
        shareInWorkspaceDialogCtrl.workspacesList = workspacesList;
    }).error((data, status, headers, config, statusText) => {
        setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
    });

    function share() {
        const objectsToShare = shareInWorkspaceDialogCtrl.selectedObjects.map(so => {
            if (so.reference) {
                return { ...so, reference: { ...so.reference, workspaceKey: shareInWorkspaceDialogCtrl.workspaceKey }};
            }
            return so;
        });
        DataikuAPI.workspaces.addObjects(shareInWorkspaceDialogCtrl.workspaceKey, objectsToShare).success(() => {
            succeeded = true;
            const multi = objectsToShare.length > 1;
            objectsToShare.forEach(object =>
                WT1.event('workspaces-add-object-success', { from: 'share', objectType: WorkspaceDisplayService.getObjectType(object), multi })
            );
            $state.transitionTo('workspaces.workspace', { workspaceKey: shareInWorkspaceDialogCtrl.workspaceKey });
        }).error((data, status, headers, config, statusText) => {
            setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
        });
    }
});

app.controller('AddToDataCollectionDialogController', function($scope, $rootScope, DataikuAPI, ActivityIndicator, StateUtils, WT1, $q, $state, CreateModalFromTemplate, ActiveProjectKey) {
    // This modal is used from many places (in the object's source project, in a project they are shared to, in the data catalog...). Be careful to not add code that relies on any assumption about which page is currently opened.

    const $ctrl = this;

    // Exposed objects
    $ctrl.canWriteProject = $rootScope.topNav.isProjectAnalystRW;
    $ctrl.addObjects = addObjects;
    $ctrl.addIsDisabled = addIsDisabled;
    $ctrl.completenessIssuesMessage = completenessIssuesMessage
    $ctrl.dataCollectionItem = undefined;
    $ctrl.completenessChecksMessageLevelColumns = undefined;
    $ctrl.completenessChecksMessageLevelDesc = undefined;
    $ctrl.excludedObjects = undefined;
    $ctrl.objectWithColumnsIssue = [];
    $ctrl.objectWithDescriptionIssue = [];
    $ctrl.ICONS_METADATA = [ "dku-icon-checkmark-16 text-success", "dku-icon-info-circle-outline-16 text-info", "dku-icon-warning-outline-16 text-warning", "dku-icon-dismiss-16 text-error" ];
    $ctrl.dataCollectionsList = [];
    $ctrl.authPopoverMessageMulti = `Datasets with no object authorization will not be visible in the data-collection for users who don't have read access to the project.  \n<a target="_blank" href="${$rootScope.versionDocRoot}data-catalog/data-collections/permissions-and-dataset-visibility.html">More details in the documentation</a>`;

    let succeeded = false;

    function getDatasetCompletenessInfo(object) {
        let tooltip = "";
        let iconLevel = 0; // Represents severity: 0 (OK), 1 (Info), 2 (Warning), 3 (Error)

        const completenessChecks = $ctrl.dataCollectionItem?.metadataCompletenessChecks;
        const dataCollectionQualityIsDefault = completenessChecks?.longDescriptionCheck === "DISABLED" && completenessChecks?.columnsDescriptionCheck === "DISABLED";

        const showDefaultMessageForInfoStatus = dataCollectionQualityIsDefault || !$ctrl.dataCollectionItem;

        const processSingleCheck = (status, config) => {
            let msg = "";
            let icon = 0; // Default icon level (0 for OK)

            switch (status) {
                case "ERROR":
                    msg = config.error.msg;
                    icon = config.error.icon;
                    break;
                case "WARNING":
                    msg = config.warning.msg;
                    icon = config.warning.icon;
                    break;
                default: 
                    if (showDefaultMessageForInfoStatus) {
                        msg = config.default.msg;
                        icon = config.default.icon;
                    }
            }
            return { msg, icon };
        };

        // Dataset Description Check
        if (object && !object.hasLongDescription) {
            const datasetDescConfig = {
                error:   { msg: "You must set a long description", icon: 3 },
                warning: { msg: "You should set a long description", icon: 2 },
                default: { msg: "Missing dataset long description", icon: 1 } 
            };
            const result = processSingleCheck(completenessChecks?.longDescriptionCheck, datasetDescConfig);
            tooltip = result.msg;
            iconLevel = result.icon;
        }

        // Columns Description Check
        if (object && object.numberOfEmptyColumns !== 0) {
            const columnsDescConfig = {
                error:   { msg: `You must fill in ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 3 },
                warning: { msg: `You should fill in ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 2 },
                default: { msg: `Missing ${object.numberOfEmptyColumns}/${object.totalNumberOfColumns} columns description`, icon: 1 } 
            };
            const result = processSingleCheck(completenessChecks?.columnsDescriptionCheck, columnsDescConfig);
            if (tooltip.length > 0) {
                tooltip += " <br/>";
            }
            tooltip += result.msg;
            iconLevel = Math.max(iconLevel, result.icon);
        }
        return {
            message: tooltip,
            icon: $ctrl.ICONS_METADATA[iconLevel]
        };
    };

    $ctrl.getDatasetCompletenessMessage = function(object) {
        return getDatasetCompletenessInfo(object).message;
    }

    $ctrl.getDatasetCompletenessIcon = function(object) {
        return getDatasetCompletenessInfo(object).icon;
    }

    $ctrl.generateDatasetDescription = function(obj) {
        if ($ctrl.canWriteProject === undefined) {
            //from the data catalog page, we have no project, so no $rootScope.topNav.isProjectAnalystRW;
            DataikuAPI.projects.getSummary(obj.projectKey).success(data => {
                        $ctrl.canWriteProject = data.object.canWriteProjectContent;
            });
        }
        // we can use object.projectKey as contextProjectKey because if we get to here it means we have the publish to collection auth, which implies read on the source project. So a call 'from the source project' will succeed, regardless of where we actually are.
        DataikuAPI.datasets.get(obj.projectKey, obj.id, obj.projectKey).noSpinner()
            .success(function(data) {
                $scope.object = data;
                $scope.canWriteProject = () => $ctrl.canWriteProject;
                CreateModalFromTemplate(
                    "/static/dataiku/ai-dataset-descriptions/generate-documentation-modal/generate-documentation-modal.html",
                    $scope,
                    "AIDatasetDescriptionsModalController"
                ).then(() => {
                    // refresh the dataset status
                    DataikuAPI.datasets.getFullInfo(obj.projectKey, obj.projectKey, obj.id)
                    .then(({data}) => $ctrl.updateObjectInfo(data, obj));
                });
            }).error(setErrorInScope.bind($scope));
        };

    $ctrl.getDatasetEditSchemaHref = function(obj) {
        return obj.subType === 'Inline'
            ? $state.href('projects.project.datasets.dataset.edit', {projectKey: obj.projectKey, datasetName: obj.id})
            : $state.href('projects.project.datasets.dataset.settings', {projectKey: obj.projectKey, datasetName: obj.id, '#': 'schema'});
    };

    function addIsDisabled(addToDataCollectionForm) {
        if( !$ctrl.filteredSelectedObjects || !addToDataCollectionForm || $ctrl.filteredSelectedObjects.length === 0) {
            return true;
        }
        if (addToDataCollectionForm && addToDataCollectionForm.$invalid) {
            return true;
        }
        return $ctrl.filteredSelectedObjects.some(obj => {
            if (obj.numberOfEmptyColumns !== 0 && $ctrl.dataCollectionItem?.metadataCompletenessChecks?.columnsDescriptionCheck == "ERROR" ) {
                return true;
            }
            if (!obj.hasLongDescription && $ctrl.dataCollectionItem?.metadataCompletenessChecks?.longDescriptionCheck == "ERROR" ) {
                return true;
            }
            return false;
        });
    }

    $ctrl.updateObjectInfo = function(data, object) {
        object.hasLongDescription = data.dataset.description !== undefined && data.dataset.description.trim().length > 0;

        let numberOfEmptyColumns = 0;
        let totalNumberOfColumns = 0;
        const columns = data.dataset.schema?.columns;

        if (Array.isArray(columns)) {
            totalNumberOfColumns = columns.length;
            numberOfEmptyColumns = columns.filter(column =>
                !column.comment || column.comment.trim() === ''
            ).length;
        }

        object.numberOfEmptyColumns = numberOfEmptyColumns;
        object.totalNumberOfColumns = totalNumberOfColumns;
        const allColumnDescriptionsFilled = numberOfEmptyColumns === 0;

        const colIndex = $ctrl.objectWithColumnsIssue.indexOf(object.displayName);
        if (!allColumnDescriptionsFilled && colIndex === -1) {
            $ctrl.objectWithColumnsIssue.push(object.displayName);
        }else if (colIndex > -1) {
            $ctrl.objectWithColumnsIssue.splice(colIndex, 1);
        }
        const descIndex = $ctrl.objectWithDescriptionIssue.indexOf(object.displayName);
        if (!object.hasLongDescription && descIndex === -1) {
            $ctrl.objectWithDescriptionIssue.push(object.displayName);
        }else if (descIndex > -1) {
            $ctrl.objectWithDescriptionIssue.splice(descIndex, 1);
        }
        return object.id;
    };

    $scope.init = (selectedObjects, wt1Context = {}) => {
        $ctrl.wt1Context = wt1Context;
        $ctrl.modalTitle = getModalTitle();
        $ctrl.nbFilteredObjects = 0;

        DataikuAPI.dataCollections.getObjectsAuthorizations(selectedObjects.map(refFromSelectedObject)).success(function (objectsAuthorizations){
            $ctrl.filteredSelectedObjects = selectedObjects
                .map((object) => ([
                    object,
                    objectsAuthorizations.find(( {ref} ) => ref.id === object.id && ref.type === object.type && ref.projectKey === object.projectKey)
                ]))
                .filter(([, authorizationsForThisItem]) => authorizationsForThisItem)
                .map(([object, authorizationsForThisItem]) => {
                    const dashboardAuthorizationsForThisItem = authorizationsForThisItem.authorizations
    
                    let allowNone, allowDiscover;
                    if (authorizationsForThisItem.allAuthorized
                        || dashboardAuthorizationsForThisItem.includes('READ')
                        || dashboardAuthorizationsForThisItem.includes('WRITE')) {
                        allowNone = false;
                        allowDiscover = false;
                    } else if (dashboardAuthorizationsForThisItem.includes('DISCOVER')) {
                        // we remove NONE from the options
                        allowNone = false;
                        allowDiscover = true;
                    } else {
                        allowNone = true;
                        allowDiscover = true;
                    }

                    return {
                        ...object,
                        allowDiscover,
                        allowNone,
                        objectAuthorization: 'READ', // always set it to read by default
                        canEnableQuickSharing: authorizationsForThisItem.canManageExposedElements,
                        isQuicklyShareable: authorizationsForThisItem.isQuicklyShareable,
                        suggestQuickSharing: authorizationsForThisItem.canManageExposedElements && !authorizationsForThisItem.isQuicklyShareable,
                        enableQuickSharing: authorizationsForThisItem.canManageExposedElements ? true : authorizationsForThisItem.isQuicklyShareable,
                    }
                });
            $ctrl.nbFilteredObjects = selectedObjects.length - $ctrl.filteredSelectedObjects.length;

            let promises = $ctrl.filteredSelectedObjects.map((object) => {
                // we can use object.projectKey as contextProjectKey because if we get to here it means we have the publish to collection auth, which implies read on the source project. So a call 'from the source project' will succeed, regardless of where we actually are.
                return DataikuAPI.datasets.getFullInfo(object.projectKey, object.projectKey, object.id)
                    .then(({data}) => $ctrl.updateObjectInfo(data, object))
                    .catch(function() {
                        // On failure, return a marker like undefined
                        return undefined;
                    });
            });
            $q.all(promises).then(results => {
                const objectsOK = [];
                const objectsFailed = [];
                // Iterate the original list and separate objects
                for (const object of $ctrl.filteredSelectedObjects) {
                    if (results.includes(object.id)) {
                        objectsOK.push(object);
                    } else {
                        objectsFailed.push(object);
                    }
                }
                $ctrl.filteredSelectedObjects = objectsOK;
                $ctrl.excludedObjects = objectsFailed;
            }).catch(error => {
                setErrorInScope.bind($scope)
            });
        }).error(setErrorInScope.bind($scope));

        WT1.tryEvent('data-collection-add-object-open', () => ({ from: 'publish', ...$ctrl.wt1Context }));
    };

    $scope.$on('$destroy', () => {
        if (!succeeded) {
            WT1.tryEvent('data-collection-add-object-cancel', () => ({ from: 'publish', ...$ctrl.wt1Context }));
        }
    });


    DataikuAPI.dataCollections.list("WRITE").success(dataCollectionsList => {
        $ctrl.dataCollectionsList = dataCollectionsList;
    }).error(setErrorInScope.bind($scope.errorScope || $scope.$parent));
    
    $scope.getDataCollectionName = (item) => {
        return item.metadata.displayName;
    };

    function getModalTitle() {
        return `Add datasets to Data Collection`;
    }

    function addObjectFromSelectedObject(selectedObject) {
        const requestedReaderAuthorizationsMapping = {
            'NONE': [],
            'DISCOVER': ['DISCOVER'],
            'READ': ['DISCOVER', 'READ'],
        };

        return {
            ref: refFromSelectedObject(selectedObject),
            requestQuickSharing: selectedObject.suggestQuickSharing && selectedObject.enableQuickSharing,
            requestedReaderAuthorizations: requestedReaderAuthorizationsMapping[selectedObject.objectAuthorization]
        };
    }

    function refFromSelectedObject(selectedObject) {
        return {
            projectKey: selectedObject.projectKey,
            id: selectedObject.id,
            type: selectedObject.type
        };
    }

    function completenessIssuesMessage(addToDataCollectionForm, isAddButton) {
        if(addToDataCollectionForm) {
            if (addToDataCollectionForm.$invalid) {
                return "Please choose a Data collection";
            } else if (!$ctrl.addIsDisabled(addToDataCollectionForm) && isAddButton){
                //sc-244257, if button is enabled, we don't show any message
                if ($ctrl.filteredSelectedObjects !== undefined) {
                    return "Publish "+$ctrl.filteredSelectedObjects.length+" datasets";
                } else {
                    return "";
                }
            }
        }

        const completenessChecks = $ctrl.dataCollectionItem?.metadataCompletenessChecks;
        const missingForColumns = $ctrl.objectWithColumnsIssue?.length > 0 && (completenessChecks?.columnsDescriptionCheck === "ERROR" || !isAddButton);
        const missingForDesc = $ctrl.objectWithDescriptionIssue?.length > 0 && (completenessChecks?.longDescriptionCheck === "ERROR" || !isAddButton);

        if (missingForColumns && missingForDesc) {
            return "Some datasets are missing a long description and column descriptions";
        } else if (missingForColumns) {
            return "Some datasets are missing column descriptions";
        } else if (missingForDesc) {
            return "Some datasets are missing a long description";
        } else if ($ctrl.filteredSelectedObjects !== undefined) {
            return "Publish "+$ctrl.filteredSelectedObjects.length+" datasets";
        } else {
            return "";
        }
    }

    function addObjects() {
        DataikuAPI.dataCollections.addObjects($ctrl.dataCollectionItem.id, $ctrl.filteredSelectedObjects.map(addObjectFromSelectedObject)).success((response) => {
            const collectionName = $ctrl.dataCollectionsList.find(dataCollection => dataCollection.id === $ctrl.dataCollectionItem.id).metadata.displayName;
            succeeded = true;
            const multi = $ctrl.filteredSelectedObjects?.length > 0;
            $ctrl.filteredSelectedObjects.forEach(object =>
                WT1.tryEvent('data-collection-object-added', () => ({
                    from: 'publish',
                    objectType: object.type,
                    dataCollectionh: md5($ctrl.dataCollectionItem.id),
                    originProjecth: md5(object.projectKey),
                    multi,
                    ...$ctrl.wt1Context
                }))
            );

            function buildLinkToDataCollection(dataCollectionId) {
                const href = StateUtils.href.dataCollection(dataCollectionId);
                const linkMessage = `View in ${sanitize(collectionName)}`;
                return `<a href='${href}'>${linkMessage}</a>.`;
            }

            const link = "<div>" +
            buildLinkToDataCollection($ctrl.dataCollectionItem.id)
            + "</div>";

            const dataStewardWarning = response.allDataStewardsDefined ? "" : "<div>No Data Steward set in dataset details.</div>";

            if (response.modified) {
                let message = $ctrl.filteredSelectedObjects.length + " Datasets added to collection!";
                
                if (dataStewardWarning) {
                    ActivityIndicator.warning(message + dataStewardWarning + link, 5000);
                } else {
                    ActivityIndicator.success(message + link, 5000);
                }
            } else {
                const message = "Datasets already in collection";
                if (dataStewardWarning) {
                    ActivityIndicator.warning(message + dataStewardWarning + link, 5000);
                } else {
                    ActivityIndicator.info(message + link, 5000);
                }
            }

            // returns a TaggableObjectsService.TaggableObjectRefWithName
            $scope.resolveModal({projectKey: '', type: 'DATA_COLLECTION', id: $ctrl.dataCollectionItem.id, displayName: collectionName});
            
        }).error((data, status, headers, config, statusText) => {
            setErrorInScope.bind($scope.errorScope || $scope.$parent)(data, status, headers, config, statusText);
        });
    }
});

app.component('addToDataCollectionAuthorizationSelect', {
    template: `<select dku-bs-select
                    class="input-custom-width"
                    ng-model="$ctrl.object.objectAuthorization"
                    options-descriptions="$ctrl.objectAuthorizationDescriptions"
                    layout="list">
                    <option ng-value="'NONE'" ng-disabled="!$ctrl.object.allowNone">None</option>
                    <option ng-value="'DISCOVER'" ng-disabled="!$ctrl.object.allowDiscover">Allow discover</option>
                    <option ng-value="'READ'">Allow read</option>
               </select>`,
    bindings: { object: '<' },
    controller: function() {
        this.objectAuthorizationDescriptions= [ '&quot;None&quot; will prevent users from seeing the dataset in the Data Collection at all',
                                                                     '&quot;Allow Discover&quot; will allow users to see the dataset metadata',
                                                                     '&quot;Allow Read&quot; will allow users to additionally preview the dataset from the collection' ];}
    });

app.component('addToDataCollectionQuickSharingCheckbox', {
    template: `<div class="control-checkbox">
                    <input type="checkbox" 
                        ng-model="$ctrl.object.enableQuickSharing"
                        ng-disabled="!$ctrl.object.suggestQuickSharing"
                        data-toggle="tooltip"
                        data-original-title="{{$ctrl.tooltipText()}}" />
                </div>`,
    bindings: { object: '<' },
    controller: function() {
        this.tooltipText = () => !this.object.isQuicklyShareable ? this.object.canEnableQuickSharing ? '' : 'You don\'t have the permission to change this option.' : 'Quick sharing is already enabled on this dataset';
    }
});


}());


(function() {
'use strict';

var app = angular.module('dataiku.services');

app.factory("Dialogs", ["CreateModalFromTemplate", "$q", "$state", "$timeout","DKUConstants", "translate", function(CreateModalFromTemplate, $q, $state, $timeout,DKUConstants, translate) {
    return {
        ack : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/ack-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        ackMarkdown : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/ack-dialog-markdown.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        error : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/error-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirm : function($scope, title, text, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false || options ? options.positive : false;
                newScope.title = title;
                newScope.text = text;
                newScope.options = options;
                newScope.translate = translate;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            }, null, options && options.confirmOnExit ? 'confirm' : null);
            return deferred.promise;
        },
        confirmUnsafeHTML : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-unsafe-html.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmPositive : function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = true;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmSimple : function($scope, text, positive = false) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-simple.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = positive;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },
        confirmImportant: function($scope, title, text) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            },
            false,
            'static');
            return deferred.promise;
        },
        confirmDisclaimer : function($scope, title, text, disclaimer) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-disclaimer.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.disclaimer = disclaimer;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        confirmAlert : function($scope, title, text, alertText, severity) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-alert.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.alertText = alertText;
                newScope.severity = severity;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        confirmInfoMessages : function($scope, title, data, text, skipIfNoMessages) {
            if (skipIfNoMessages && (data == null || data.messages.length == 0)) return $q.when(null);
            var deferred = $q.defer();

            CreateModalFromTemplate("/templates/dialogs/confirm-dialog-info-messages.html", $scope, "ConfirmDialogController", function(newScope) {
                newScope.modalTitle = title;
                newScope.data = data;
                newScope.acceptDeferred = deferred;
                newScope.positive = false;
                newScope.title = title;
                newScope.text = text;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        infoMessagesDisplayOnly : function($scope, title, data, log, hideAlertHeader, backdrop, keyboard) {
            if (data.messages.length == 0) return $q.when(null);
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/info-messages-dialog.html", $scope, null, function(newScope) {
                newScope.DKUConstants = DKUConstants;
                newScope.modalTitle = title;
                newScope.data = data;
                newScope.log = log;
                newScope.hideAlertHeader = hideAlertHeader;
                newScope.$on("$destroy",function() {
                    deferred.resolve();
                });
            }, backdrop, keyboard);
            return deferred.promise;
        },

        prompt : function($scope, title, text, defaultValue, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/prompt-dialog.html", $scope, "PromptDialogController", function(newScope, newDOMElt) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.value = defaultValue;
                newScope.options = options;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
                newDOMElt.on('keydown', 'input', function(e) {
                    if (e.which === 13 && newScope.renameForm.$valid === false) {
                        e.stopPropagation();
                    }
                })

                if (options && options.type === 'textarea') {
                    newDOMElt.on('keydown', 'textarea', function(evt) {
                        if (evt.which === 13) {
                            // prevent ENTER key from validating the popup from inside the textarea
                            evt.stopPropagation();
                        }
                    })
                }
            });
            return deferred.promise;
        },

        select : function($scope, title, text, items, selectedItem, options) {
            var deferred = $q.defer();
            CreateModalFromTemplate("/templates/dialogs/select-dialog.html", $scope, "SelectDialogController", function(newScope) {
                newScope.acceptDeferred = deferred;
                newScope.title = title;
                newScope.text = text;
                newScope.items = items;
                newScope.selectedItem = selectedItem;
                newScope.options = options;
                newScope.$on("$destroy",function() {
                    if(newScope.acceptDeferred) {
                        newScope.acceptDeferred.reject();
                    }
                    newScope.acceptDeferred = null;
                });
            });
            return deferred.promise;
        },

        eeUnavailableFeature : function($scope, lockedMessage, learnMoreURL){
           CreateModalFromTemplate("/templates/dialogs/ee-unavailable-feature-modal.html", $scope, null, function(newScope) {
            newScope.lockedMessage = lockedMessage;
            newScope.learnMoreURL = learnMoreURL;
        });
       },

       displaySerializedError: function($scope, e) {
            CreateModalFromTemplate("/templates/dialogs/serialized-error-modal.html", $scope, null, function(newScope) {
                newScope.error = e;
                newScope.isCredentialError = e && e.code && (e.code==="ERR_CONNECTION_OAUTH2_REFRESH_TOKEN_FLOW_FAIL" || e.code==="ERR_CONNECTION_NO_CREDENTIALS");
            });
        },


       openEditInNotebookConflictDialog: function($scope) {
        var deferred = $q.defer();
        CreateModalFromTemplate("/templates/dialogs/edit-in-notebook-conflict-dialog.html", $scope, "ConflictDialogController", function(newScope) {
            newScope.acceptDeferred = deferred;
            newScope.$on("$destroy", function() {
                if (newScope.acceptDeferred) {
                    newScope.acceptDeferred.reject();
                }
                newScope.acceptDeferred = null;
            });
        });
        return deferred.promise;
       },

       openConflictDialog : function($scope,conflictResult) {

        var deferred = $q.defer();
        CreateModalFromTemplate("/templates/dialogs/save-conflict-dialog.html", $scope, "ConflictDialogController", function(newScope) {
            newScope.acceptDeferred = deferred;
            newScope.conflictResult = conflictResult;
            newScope.$on("$destroy",function() {
                if(newScope.acceptDeferred) {
                    newScope.acceptDeferred.reject();
                }
                newScope.acceptDeferred = null;
            });
        });
        return deferred.promise;
    },

    saveChangesBeforeLeaving: function(scope, dirty, save, revert, msg) {
        if (typeof dirty != 'function') {
            // eslint-disable-next-line no-console
            console.error("Dirtyness detection is not valid. typeof dirty = ", typeof dirty, dirty); /*@console*/ // NOSONAR: OK to use console.
        }
        if (typeof save != 'function') {
            // eslint-disable-next-line no-console
            console.error("Saving function is not valid. typeof save = ", typeof save, save); /*@console*/ // NOSONAR: OK to use console.
        }
        if (revert && typeof revert != 'function') {
            // eslint-disable-next-line no-console
            console.error("Revert function is not valid. typeof revert = ", typeof revert, revert); /*@console*/ // NOSONAR: OK to use console.
        }

        scope.$on('$stateChangeStart', function (event, toState, toParams, fromState, fromParams) {
            var isDirty = false;
                try { // Don't keep the reference to the scope in dssHasDirtyThings, so never fail this check!
                isDirty = dirty(toState, toParams, fromState, fromParams);
            } catch (e) {
                // eslint-disable-next-line no-console
                console.error("Failed to check dirtiness"); /*@console*/ // NOSONAR: OK to use console.
            }
            if (isDirty) {
                event.preventDefault();

                CreateModalFromTemplate("/templates/dialogs/unsaved-changes-warning.html", scope, null, function(modalScope) {
                    modalScope.msg = msg;

                    var goToState = function() {
                        $timeout(function() {
                            $state.go(toState, toParams);
                            modalScope.resolveModal();
                        });
                    };

                    modalScope.saveAndContinue = function() {
                        var saveResult = save();
                        if (saveResult && saveResult.success) {
                            saveResult.success(goToState);
                        } else {
                            goToState();
                        }

                        if (saveResult && saveResult.error) {
                            if (saveResult.errorIsAlreadyParsed) {
                                // When we use the service from Angular, the http service has already called getErrorDetails upstream
                                // so we can't feed it to the classic setErrorInScope. setErrorDetailsInScope does the same thing except it expects an already parsed errorDetails
                                saveResult.error(setErrorDetailsInScope.bind(modalScope));
                            } else {
                                saveResult.error(setErrorInScope.bind(modalScope));
                            }
                        }
                    };

                    modalScope.continueWithoutSaving = function() {
                        if (revert) {
                            revert();
                        }

                        goToState();
                    };
                });

                return false;
            }
        });
    },

    checkChangesBeforeLeaving: checkChangesBeforeLeaving
};

}]);


})();
