/* global module, inject, ChartTestUtils */

/**
 * ChartFeaturesTest helpers
 * Facilitate ChartFeatures service test on different types of charts
 */
const ChartFeaturesTestUtils = chartFeaturesTestUtils(); // eslint-disable-line no-unused-vars

function chartFeaturesTestUtils() {

    let scope;

    return {
        initEachTest,
        initChartType,
        setXYGenericFromNumericalColumns,
        setXYMeasureFromNumericalColumns,
        setXYDimensionFromNumericalColumns,
        setXDimensionFromNumericalColumn,
        setYDimensionFromNumericalColumn,
        setXYUaDimensionFromNumericalColumns,
        set2XDimensions2YDimensionFromNumericalColumn,
        set2YDimensionsFromNumericalColumn,
        set2XDimensionsFromNumericalColumn,
        setGenericMeasureFromNumericalColumns,
        setColorMeasureFromNumericalColumns,
        setGroupDimensionFromNumericalColumns,
        setYDimensionFromAlphanumericalColumns,
        getScope: ChartTestUtils.getScope,
        setGenericDimensionsFromNumericalColumns,
        setComputeModeTo,
        computeAlongDimensionSelectTests,
        renderTemplate,
        expectIdToBeVisible: ChartTestUtils.expectIdToBeVisible,
        expectIdToBeHidden: ChartTestUtils.expectIdToBeHidden,
        expectElementWithAttributeToBeVisible: ChartTestUtils.expectElementWithAttributeToBeVisible,
        expectElementWithAttributeToBeHidden: ChartTestUtils.expectElementWithAttributeToBeHidden,
        expectClassToBeVisible: ChartTestUtils.expectClassToBeVisible,
        getNumericalColumnSample,
        getAlphanumericalColumnSample,
        initDiscreteLegends,
        mockIsAlphanumLikeDimension,
        setAxisSpecs
    }

    //////////

    function initEachTest() {
        importModules();
        ChartTestUtils.silenceAppConsoleLogs();
        ChartTestUtils.initAngularJSTemplatingResource();
        scope = ChartTestUtils.getScope();
        initDefaultScope();
        $('body').empty(); // clean the DOM
    }

    function importModules() {
        module('templates');
        module('dataiku.services');
        module('dataiku.logger');
        module('dataiku.meanings');
        module('angular-blocks');
        module('dataiku.directives.simple_report');
        module('dataiku.charts', ($provide) => {
            $provide.value('AxisTicksConfigMode', {});
            $provide.value('RegressionTypes', {});
            $provide.value('ChartFilters', {});
            $provide.value('ValuesInChartOverlappingStrategy', {});
            $provide.value('ValuesInChartPlacementMode', {});
            $provide.value('PolygonSources', {});
            $provide.value('LineStyleTypes', {});
            $provide.value('LinkColorVariants', {});
			$provide.value('AxisTicksFormatting', {});
			$provide.value('AxisTitleFormatting', {});
            $provide.value('$state', {});
            $provide.value('ChartFormattingPaneSections', {});
        });
        module('dataiku.dashboards', ($provide) => {
            $provide.value('DashboardFilters', {});
        });
        module('dataiku.webapps', mockWebAppsService);
        module('dataiku.directives.scope');
        module('dataiku.common.func');
        module('dataiku.common.datastructures');
        module('dataiku.mock');
    }

    function mockWebAppsService($provide) {
        $provide.value('WebAppsService', {});
    }

    function initDefaultScope() {
        inject(function ($rootScope, ChartTypeChangeHandler, ChartFeatures, ChartDimension, ChartUADimension, ChartFormattingPane, ChartLegendsWrapper) {
            /* Initialize feature flag */
            $rootScope.featureFlagEnabled = () => {
                return false;
            };

            $rootScope.appConfig = {
            }

            scope.chart = {
                def: ChartTypeChangeHandler.defaultNewChart(),
            };
            scope.readOnly = false; // Enable chart edit

            /* Initialize required services */
            scope.ChartDimension = ChartDimension;
            scope.ChartFeatures = ChartFeatures;
            scope.ChartUADimension = ChartUADimension;
            scope.ChartFormattingPane = ChartFormattingPane;
            scope.ChartLegendsWrapper = ChartLegendsWrapper;

            /* Open all options submenu */
            scope.foldableOpen = true;
            scope.optionsFolds = {
                legend: true,
                chartMode: true,
                showTopBar: true,
                color: true
            };

            ChartFormattingPane.folds = {
                displayRegressionLine: true
            };
        });
    }

    function initDiscreteLegends() {
        scope.legendsWrapper = scope.ChartLegendsWrapper();
        scope.legendsWrapper.pushLegend({
            "type": "COLOR_DISCRETE"
        });
    }

    function initChartType(chartType, chartVariant) {
        scope.chart.def.type = chartType;
        scope.chart.def.variant = chartVariant;
    }

    function setXYGenericFromNumericalColumns() {
        scope.chart.def.genericDimension0 = [getNumericalColumnSample()];
        scope.chart.def.genericMeasures = [getNumericalColumnSample()];
    }

    function setXYMeasureFromNumericalColumns() {
        scope.chart.def.xMeasure = [getNumericalColumnSample()];
        scope.chart.def.yMeasure = [getNumericalColumnSample()];
    }

    function setXYUaDimensionFromNumericalColumns() {
        scope.chart.def.uaXDimension = [getNumericalColumnSample()];
        scope.chart.def.uaYDimension = [getNumericalColumnSample()];
    }

    function setColorMeasureFromNumericalColumns() {
        scope.chart.def.colorMeasure = [getNumericalColumnSample()];
    }

    function setGroupDimensionFromNumericalColumns() {
        scope.chart.def.groupDimension = [getNumericalColumnSample()];
    }

    function setXYDimensionFromNumericalColumns() {
        scope.chart.def.xDimension = [getNumericalColumnSample()];
        scope.chart.def.yDimension = [getNumericalColumnSample()];
    }

    function setXDimensionFromNumericalColumn() {
        scope.chart.def.xDimension = [getNumericalColumnSample()];
    }

    function setYDimensionFromNumericalColumn() {
        scope.chart.def.yDimension = [getNumericalColumnSample()];
    }

    function set2YDimensionsFromNumericalColumn() {
        scope.chart.def.yDimension = [getNumericalColumnSample(), getNumericalColumnSample()];
    }

    function set2XDimensionsFromNumericalColumn() {
        scope.chart.def.xDimension = [getNumericalColumnSample(), getNumericalColumnSample()];
    }

    function set2XDimensions2YDimensionFromNumericalColumn() {
        set2YDimensionsFromNumericalColumn();
        set2XDimensionsFromNumericalColumn();
    }

    function setYDimensionFromAlphanumericalColumns() {
        scope.chart.def.yDimension = [getAlphanumericalColumnSample()];
    }

    function setGenericMeasureFromNumericalColumns() {
        scope.chart.def.genericMeasures = [getNumericalColumnSample()];
    }

    function setGenericDimensionsFromNumericalColumns(){
        scope.chart.def.genericDimension0 = [getNumericalColumnSample()];
        scope.chart.def.genericDimension1 = [getNumericalColumnSample()];
    }

    function setComputeModeTo(computeMode) {
        scope.chart.def.genericMeasures[0].computeMode = computeMode;
    }

    function setAxisSpecs(chartType) {
        inject(function (CHART_TYPES) {
            switch(chartType) {
                case CHART_TYPES.GROUPED_COLUMNS:
                case CHART_TYPES.STACKED_COLUMNS:
                case CHART_TYPES.LINES:
                case CHART_TYPES.MULTI_COLUMNS_LINES:
                case CHART_TYPES.STACKED_AREAS:
                    scope.xAxisSpec = { dimension: getAlphanumericalColumnSample() };
                    scope.yAxisSpec = {};
                    break;
                case CHART_TYPES.STACKED_BARS:
                    scope.xAxisSpec = { measure: [{ ...getAlphanumericalColumnSample(), function: 'function' }] };
                    scope.yAxisSpec = { dimension: getNumericalColumnSample() };
                    break;
                case CHART_TYPES.SCATTER:
                case CHART_TYPES.BINNED_XY:
                    scope.xAxisSpec = { dimension: getNumericalColumnSample() };
                    scope.yAxisSpec = { dimension: getNumericalColumnSample() };
                    break;
                case CHART_TYPES.GROUPED_XY:
                    scope.xAxisSpec = { measure: [{ ...getNumericalColumnSample(), function: 'function' }] };
                    scope.yAxisSpec = { measure: [{ ...getNumericalColumnSample(), function: 'function' }] };
                    break;
                default:
                    break;
            }
        });
    }

    function computeAlongDimensionSelectTests(chartType, computeMode, shouldBeVisible = true) {
        const MEASURE_WRAPPER_CLASSNAME = '.measure-wrapper'
        let measureWrapperName;
        let measureWrapperIndex;
        switch(chartType) {
            case 'grouped_columns':
            case 'lines':
            case 'stacked_bars':
            case 'stacked_columns':
            case 'stacked_area':
                setGenericMeasureFromNumericalColumns();
                setGenericDimensionsFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 0;
                break;
            case 'binned_xy':
                setColorMeasureFromNumericalColumns();
                setXYDimensionFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 2;
                break;
            case 'grouped_xy':
                setGroupDimensionFromNumericalColumns();
                setXYMeasureFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 1;
                break;
            case 'kpi':
                setGenericMeasureFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 0;
                break;
            case 'multi_columns_lines':
                setXYGenericFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 0;
                break;
            case 'pivot_table':
                setGenericMeasureFromNumericalColumns();
                setXYDimensionFromNumericalColumns();
                measureWrapperName = `.qa_charts_measure-dropzone ${MEASURE_WRAPPER_CLASSNAME}`;
                measureWrapperIndex = 0;
                break;
            case 'scatter':
                setXYUaDimensionFromNumericalColumns();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 0;
                break;        
            case 'treemap':
                setGenericMeasureFromNumericalColumns();
                set2YDimensionsFromNumericalColumn();
                measureWrapperName = MEASURE_WRAPPER_CLASSNAME;
                measureWrapperIndex = 2;
                break;
        }

        if (computeMode !== 'NORMAL') {
            setComputeModeTo(computeMode);
        }
        renderTemplate(`/templates/simple_report/types/definition-${chartType}.html`);
        $(measureWrapperName)[measureWrapperIndex].click();
        (shouldBeVisible ? ChartTestUtils.expectIdToBeVisible : ChartTestUtils.expectIdToBeHidden)('qa_charts_along-dimension-select');
    }

    function renderTemplate(templatePath) {
        ChartTestUtils.renderTemplate(templatePath, scope);
    }

    function getNumericalColumnSample() {
        return {
            column: 'numericalColumn',
            type: 'NUMERICAL'
        }
    }

    function getAlphanumericalColumnSample() {
        return {
            column: 'alphanumericalColumn',
            type: 'ALPHANUM'
        }
    }

    function mockIsAlphanumLikeDimension() {
        scope.isAlphanumLikeDimension = function(dimension) {
            if (!dimension) {
            return;
            }
            return dimension.type == 'ALPHANUM' || (dimension.type == 'NUMERICAL' && dimension.numParams && dimension.numParams.mode == 'TREAT_AS_ALPHANUM');
        }
    }
}
