#! /bin/bash

# Log in Dataiku Cloud registry, from where the base image will be fetched. This is needed
# so that the various crane command in build-code-env-packages.sh can interact with the base
# image, that lives in Dataiku Cloud registry

FULL_IMAGE_NAME=$1

echo "INFO: On Dataiku Cloud. Login in to AWS ECR registry to interact with base image : $FULL_IMAGE_NAME" >&2
# full image name is like 000000000000.dkr.ecr.us-east-1.amazonaws.com/project/image:tag
REPOSITORY_ROOT=$(echo "$FULL_IMAGE_NAME" | sed 's_^\([^/]*\)/.*$_\1_') # 000000000000.dkr.ecr.us-east-1.amazonaws.com
REGION=$(echo "$REPOSITORY_ROOT" | sed 's_^[0-9]*\.dkr\.ecr\.\([^\.]*\)\.amazonaws.com$_\1_') # us-east-1
echo "INFO: Detected repository: $REPOSITORY_ROOT" >&2
echo "INFO: Detected region: $REGION" >&2

if [ -z `command -v aws` ]; then
    echo 'ERROR: required `aws` binary is not in PATH' >&2
    exit 1
fi

DOCKER_PASSWORD=$(aws ecr get-login-password --region $REGION)
if (( $? )); then
    echo 'WARNING: could not get password' >&2
fi
crane auth login --username AWS --password $DOCKER_PASSWORD $REPOSITORY_ROOT
if (( $? )); then
    echo 'WARNING: could not log in' >&2
else
    echo 'INFO: Logged in to AWS ECR.' >&2
fi
