## Base imports
import os

from dataiku.code_env_resources import clear_all_env_vars
from dataiku.code_env_resources import grant_permissions
from dataiku.code_env_resources import set_env_path
from dataiku.code_env_resources import set_env_var

# Clears all environment variables defined by previously run script
clear_all_env_vars()

## Hugging Face
# Set HuggingFace cache directory
set_env_path("HF_HOME", "huggingface")
hf_home_dir = os.getenv("HF_HOME")

# Import Hugging Face's transformers
import transformers

# Download pretrained model: automatically managed by Hugging Face,
# does not download anything if model is already in HF_HOME
# /!\ The same model revision needs to be specified when loading the model /!\
MODEL_REVISION = "1c4513b2eedbda136f57676a34eea67aba266e5c"
model = transformers.DistilBertModel.from_pretrained("distilbert-base-uncased", revision=MODEL_REVISION)

# Grant everyone read access to pretrained models in the HF_HOME folder
# (by default, only readable by the owner)
grant_permissions(hf_home_dir)
