package com.dataiku.dss.plugins.builtinmacros;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import com.dataiku.dip.experimenttracking.ExperimentTrackingGarbageCollectionReport;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.plugin.BackendClient;
import com.dataiku.dip.plugin.CustomRunnable;
import com.dataiku.dip.plugin.ProgressTracker;
import com.dataiku.dip.plugin.ResultTableDTO;
import com.dataiku.dip.plugin.ResultTableDTO.ResultTableColumnDTO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;

public class GarbageCollectExperiments implements CustomRunnable {
    private static final ExpressionBuilder.ExpressionBuilderFactory EBF = new ExpressionBuilder.ExpressionBuilderFactory();
    private String projectKey;
    private AuthCtx authCtx;

    private @Autowired ExperimentTrackingService experimentTrackingService;

    public GarbageCollectExperiments() {
    }

    @Override
    public void init(String projectKey, JsonObject config, JsonObject pluginConfig, ProgressTracker progressTracker, BackendClient backendClient) {
        this.projectKey = projectKey;
        this.authCtx = (AuthCtx) backendClient.getAuthCtx();
        SpringUtils.getInstance().autowire(this);
    }

    @Override
    public byte[] run() throws Exception {
        ExperimentTrackingGarbageCollectionReport garbageCollectionReport = experimentTrackingService.garbageCollect_NT(authCtx, projectKey);
        List<ResultTableColumnDTO> columns = Arrays.asList(
                new ResultTableColumnDTO("Object type", "STRING"),
                new ResultTableColumnDTO("Number of deleted objects", "STRING")
        );
        List<List<String>> data = Arrays.asList(
                Arrays.asList("Experiments", String.valueOf(garbageCollectionReport.numberOfDeletedExperiments)),
                Arrays.asList("Runs", String.valueOf(garbageCollectionReport.numberOfDeletedRuns))
        );
        return JSON.json(new ResultTableDTO("Garbage collect experiments", columns, data)).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void abort() {
    }

    private static Logger logger = Logger.getLogger("dku.macro.garbagecollectexperiments");
}