
if (-not $env:DIP_HOME) {
    Write-Host "[-] DIP_HOME is not defined, can't continue."
    Exit
}

if ((-not (Get-Command "node" -errorAction SilentlyContinue)) -or (-not (Get-Command "node" -errorAction SilentlyContinue))) {
    Write-Host "[-] Node or npm are not installed on this system, and are required to enable graphics export."
    Write-Host "[-] Install Node in Path, and relaunch this script."
}

Write-Host "[+] Installing additional modules for dashboard and flow export feature"

Push-Location -Path "$env:DKUINSTALLDIR/resources/graphics-export"
& npm install puppeteer@13.7.0 fs
Pop-Location

Write-Host "[+] Enabling graphics export in DSS"
& "$env:DIP_HOME/bin/dku" "__enable-graphics-export"

Write-Host "[+] Done"