#' Get the path to a managed folder.
#'
#' This method can only be used for local-filesystem based managed foldeers
#' For other kinds of managed folders (HDFS, S3, ...), use other functions:
#' dkuManagedFolderPartitionPaths, dkuManagedFolderDownloadPath, ...
#'
#' @param name the identifier of the managed folder
#' @return The path on disk to the managed folder
#'
#' @export
#' @importFrom httr POST
dkuManagedFolderPath <- function(name) {
    getPathURL = dku_intercom__get_jek_or_backend_url("/managed-folders/get-info")
    ensureAccessURL = dku_intercom__get_jek_or_backend_url("/managed-folders/ensure-direct-access")
    ref = dku__resolve_smart_name(name)

    resp = POST(getPathURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref)),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())

    dku__check_api_error(resp, "Failed to get Folder information")
    data <- content(resp)

    if (data$info$type != "Filesystem") {
        stop("Folder is not on the local filesystem, cannot perform direct filesystem access. Use the read/write API instead.")
    }

    resp2 = POST(ensureAccessURL,body = list(projectKey=dku__ref_to_pkey(ref), lookup=dku__ref_to_name(ref)),
        encode="form",  dku__get_auth_headers(), dku_intercom__get_httr_config())
    dku__check_api_error(resp2, "Failed to ensure folder access permissions")

    return(data$info$path)
}
