/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;

@Description(name="create_union", value="_FUNC_(tag, obj1, obj2, obj3, ...) - Creates a union with the object for given tag", extended="Example:\n  > SELECT _FUNC_(1, 1, \"one\") FROM src LIMIT 1;\n  one")
public class GenericUDFUnion
extends GenericUDF {
    private transient ObjectInspector tagOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.tagOI = arguments[0];
        ArrayList<ObjectInspector> unionOIs = new ArrayList<ObjectInspector>(arguments.length - 1);
        for (int i = 1; i < arguments.length; ++i) {
            unionOIs.add(arguments[i]);
        }
        return ObjectInspectorFactory.getStandardUnionObjectInspector(unionOIs);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        byte tag = (byte)((IntObjectInspector)this.tagOI).get(arguments[0].get());
        return new StandardUnionObjectInspector.StandardUnion(tag, arguments[tag + 1].get());
    }

    @Override
    public String getDisplayString(String[] children) {
        StringBuilder sb = new StringBuilder();
        sb.append("create_union(");
        for (int i = 0; i < children.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(children[i]);
        }
        sb.append(')');
        return sb.toString();
    }
}

