/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.server.api.PublicAPIMLflowBaseController;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.mlflow.api.proto.ModelRegistry;
import com.dataiku.dss.shadelib.org.mlflow_project.google.protobuf.MessageOrBuilder;
import com.dataiku.dss.shadelib.org.mlflow_project.google.protobuf.util.JsonFormat;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/api/{version:\\d\\.\\d}"})
public class PublicAPIMLflowRepositoryController
extends PublicAPIMLflowBaseController {
    @Autowired
    private TransactionService transactionService;
    public static DKULogger logger = DKULogger.getLogger((String)"dip.publicapi.mlflow.repository");

    @AuditedCall(value={"msgType", "create_registered_model", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/mlflow/registered-models/create", "/preview/mlflow/registered-models/create"}, method={RequestMethod.POST})
    public String createRegisteredModel(HttpServletRequest req, @RequestBody DSSRegisteredModelCreation info) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkRead(req, projectKey);
        }
        logger.warnV("Calling noop registry method %s", new Object[]{req.getServletPath()});
        return JsonFormat.printer().print((MessageOrBuilder)ModelRegistry.CreateRegisteredModel.Response.newBuilder().setRegisteredModel(ModelRegistry.RegisteredModel.newBuilder().setName(info.name).setDescription(info.name)));
    }

    @AuditedCall(value={"msgType", "create_registered_model_version", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/mlflow/model-versions/create"}, method={RequestMethod.POST})
    public String createRegisteredModelVersion(HttpServletRequest req, @RequestBody DSSCreateModelVersion info) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkRead(req, projectKey);
        }
        logger.warnV("Calling noop registry method %s", new Object[]{req.getServletPath()});
        return JsonFormat.printer().print((MessageOrBuilder)ModelRegistry.CreateModelVersion.Response.newBuilder().setModelVersion(ModelRegistry.ModelVersion.newBuilder().setName(info.name).setVersion("42").setCreationTimestamp(System.currentTimeMillis()).setLastUpdatedTimestamp(System.currentTimeMillis()).setUserId("dummy").setCurrentStage("dummy").setDescription("dummy").setSource(info.source).setRunId(info.run_id).setStatus(ModelRegistry.ModelVersionStatus.READY).setStatusMessage("dummy").addAllTags(new ArrayList()).setRunLink("dummy")));
    }

    @AuditedCall(value={"msgType", "get_registered_model", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/mlflow/registered-models/get"}, method={RequestMethod.GET})
    public String getRegisteredModel(HttpServletRequest req, @RequestParam String name) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkRead(req, projectKey);
        }
        logger.warnV("Calling noop registry method %s", new Object[]{req.getServletPath()});
        return JsonFormat.printer().print((MessageOrBuilder)ModelRegistry.GetRegisteredModel.Response.newBuilder().setRegisteredModel(ModelRegistry.RegisteredModel.newBuilder().setName(name).setDescription(name)));
    }

    @AuditedCall(value={"msgType", "get_registered_model_version", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/mlflow/model-versions/get"}, method={RequestMethod.GET})
    public String getRegisteredModelVersion(HttpServletRequest req, @RequestParam String name, @RequestParam String version) throws Exception {
        String projectKey = this.getProjectKeyFromHeaders(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.checkRead(req, projectKey);
        }
        logger.warnV("Calling noop registry method %s", new Object[]{req.getServletPath()});
        return JsonFormat.printer().print((MessageOrBuilder)ModelRegistry.GetModelVersion.Response.newBuilder().setModelVersion(ModelRegistry.ModelVersion.newBuilder().setName(name).setVersion(version).setCreationTimestamp(System.currentTimeMillis()).setLastUpdatedTimestamp(System.currentTimeMillis()).setUserId("dummy").setCurrentStage("dummy").setDescription("dummy").setSource("dummy").setRunId("dummy").setStatus(ModelRegistry.ModelVersionStatus.READY).setStatusMessage("dummy").addAllTags(new ArrayList()).setRunLink("dummy")));
    }

    public static class DSSRegisteredModelCreation {
        String name;
    }

    public static class DSSCreateModelVersion {
        String name;
        String source;
        String run_id;
    }
}

