/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.plugins.dev.DevPluginsService;
import com.dataiku.dip.plugins.dev.PluginsGitService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/plugins"})
public class PublicAPIPluginsDevController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DevPluginsService devPluginsService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private PluginsGitService pluginsGitService;

    @AuditedCall(value={"msgType", "plugindev-create", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/actions/createDev"}, method={RequestMethod.POST})
    public void createDevPlugin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        CreatePluginParams params = (CreatePluginParams)this.getRequestBodyAs(req, CreatePluginParams.class);
        FutureResponse futureResponse = this.devPluginsService.startCreatePlugin(params.pluginId, params.creationMode, params.gitRepository, params.gitCheckout, params.gitSubpath, authCtx);
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.futureService.waitForFinalResponse((FutureResponse)futureResponse).result);
    }

    @AuditedCall(value={"msgType", "plugindev-push", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/push"}, method={RequestMethod.POST})
    public void pushDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.push_NT(authCtx, pluginId, "origin", null, new DKUtils.SmartLogTailBuilder()));
    }

    @AuditedCall(value={"msgType", "plugindev-pull-rebase", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/pullRebase"}, method={RequestMethod.POST})
    public void pullRebaseDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.pullRebase_NT(pluginId, "origin", null, authCtx, new DKUtils.SmartLogTailBuilder()));
    }

    @AuditedCall(value={"msgType", "plugindev-fetch", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/fetch"}, method={RequestMethod.POST})
    public void fetchDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.fetch_NT(pluginId, "origin", authCtx, new DKUtils.SmartLogTailBuilder()));
    }

    @AuditedCall(value={"msgType", "plugindev-reset-to-local-head", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/resetToLocalHeadState"}, method={RequestMethod.POST})
    public void resetToLocalHeadDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.pluginsGitService.resetToHead_NT(pluginId);
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugindev-reset-to-remote-head", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/actions/resetToRemoteHeadState"}, method={RequestMethod.POST})
    public void resetToRemoteHeadDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        this.pluginsGitService.resetToUpstream_NT(authCtx, pluginId, "origin", null);
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugindev-get-git-remote", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/gitRemote"}, method={RequestMethod.GET})
    public void getRemoteDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        GitRemoteParams ret = new GitRemoteParams();
        ret.repositoryUrl = this.pluginsGitService.getRepository_NT(pluginId, "origin");
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "plugindev-set-git-remote", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/gitRemote"}, method={RequestMethod.POST})
    public void setRemoteDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        GitRemoteParams params = (GitRemoteParams)this.getRequestBodyAs(req, GitRemoteParams.class);
        String remoteName = "origin";
        this.pluginsGitService.addOrSetRepository_NT(pluginId, remoteName, params.repositoryUrl, authCtx);
        this.pluginsGitService.setUpstreamForLocalBranches_NT(authCtx, remoteName, pluginId);
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)"ok");
    }

    @AuditedCall(value={"msgType", "plugindev-rm-git-remote", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/gitRemote"}, method={RequestMethod.DELETE})
    public void rmRemoteDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.removeRemoteRepository_NT(pluginId, "origin", authCtx));
    }

    @AuditedCall(value={"msgType", "plugindev-list-git-branches", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/gitBranches"}, method={RequestMethod.GET})
    public void listBranchesDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.listAvailableBranches_NT(pluginId));
    }

    @AuditedCall(value={"msgType", "plugindev-set-active-git-branches", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/activeGitBranch"}, method={RequestMethod.GET})
    public void getCurrentBranchDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)this.pluginsGitService.getCurrentBranch_NT(pluginId));
    }

    @AuditedCall(value={"msgType", "plugindev-set-active-git-branches", "pluginId", "${pluginId}"})
    @RequestMapping(value={"/{pluginId}/activeGitBranch"}, method={RequestMethod.POST})
    public void setCurrentBranchDevPlugin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String pluginId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkDevelopPluginPrivilege(authCtx);
        }
        CreateBranchParams params = (CreateBranchParams)this.getRequestBodyAs(req, CreateBranchParams.class);
        String result = params.creation ? this.pluginsGitService.createBranch_NT(authCtx, pluginId, params.branch, null) : this.pluginsGitService.checkoutBranch_NT(authCtx, pluginId, params.branch);
        PublicAPIPluginsDevController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    public static class CreatePluginParams {
        public String pluginId;
        public DevPluginsService.DevPluginBootstrapMode creationMode;
        public String gitRepository;
        public String gitCheckout;
        public String gitSubpath;
    }

    public static class GitRemoteParams {
        public String repositoryUrl;
    }

    public static class CreateBranchParams {
        public String branch;
        public boolean creation = false;
    }
}

