/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.LuceneInitIndexEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneMultiIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMultiMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneSingleIndexManager;
import com.dataiku.dip.server.services.catalog.docportal.PythonDocPortalIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.external.ExternalCatalogIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.internal.InternalCatalogIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.pages.PagesSettingsIndexingQueueHandler;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LuceneConfiguration {
    public static boolean IS_CATALOG_ENABLED = DKUApp.getParams().getBoolParam("dku.catalog.enabled", true);
    @Autowired
    private PubSubService pubSubService;
    private static final String DOC_PORTAL_SCHEMA_FILE = "docportal/index-schema-docportal.json";
    private static final String DOC_PORTAL_INDEX_NAME = "docportal";
    private static final String EXTERNAL_SCHEMA_FILE = "external/index-schema-external.json";
    private static final String INTERNAL_SCHEMA_FILE = "internal/index-schema-internal.json";
    private static final String COLUMN_SCHEMA_FILE = "internal/index-schema-column.json";
    private static final String PAGE_SCHEMA_FILE = "pages/index-schema-page.json";
    private static final String ROOT_INDEX_DIRECTORY = "/data-catalog/data/lucene/index/";
    private static final String EXTERNAL_INDEX_NAME = "external-connection-objects";
    private static final String INTERNAL_INDEX_NAME = "dss";
    private static final String COLUMN_INDEX_NAME = "dss-columns";
    private static final String PAGE_INDEX_NAME = "pages-settings";
    public static final String ALIAS_NAME = "catalog-index-alias";
    private static final DKULogger logger = DKULogger.getLogger((String)LuceneConfiguration.class.getCanonicalName());

    @PostConstruct
    public void initIndex() throws IOException {
        IndexSearcher.setMaxClauseCount((int)DKUApp.getParams().getIntParam("dku.catalog.maxClauseCount", Integer.valueOf(4096)));
        DKUFileUtils.deleteDirectory((File)new File(System.getProperty("DIP_HOME") + "/data-catalog/data"));
        this.pubSubService.subscribe("backend-started", backendStartedEvent -> {
            if (IS_CATALOG_ENABLED) {
                this.pubSubService.publish((DSSEvent)new LuceneInitIndexEvent());
            } else {
                logger.warn((Object)"Indexing is disabled with [dku.catalog.enabled] and search results will be empty");
            }
        });
    }

    @Bean(value={"externalMappingsAnalyzer"})
    public LuceneMappingsAnalyzer externalMappingsAnalyzer() {
        return new LuceneMappingsAnalyzer("externalMappingsAnalyzer", LuceneConfiguration.getSchema(EXTERNAL_SCHEMA_FILE), ExternalCatalogIndexingQueueHandler.FACETS, ExternalCatalogIndexingQueueHandler.MULTIVALUED_FIELDS, ExternalCatalogIndexingQueueHandler.JSON_FIELDS);
    }

    @Bean(value={"internalMappingsAnalyzer"})
    public LuceneMappingsAnalyzer internalMappingsAnalyzer() {
        return new LuceneMappingsAnalyzer("internalMappingsAnalyzer", LuceneConfiguration.getSchema(INTERNAL_SCHEMA_FILE), InternalCatalogIndexingQueueHandler.FACETS, InternalCatalogIndexingQueueHandler.MULTIVALUED_FIELDS, InternalCatalogIndexingQueueHandler.JSON_FIELDS);
    }

    @Bean(value={"columnMappingsAnalyzer"})
    public LuceneMappingsAnalyzer columnMappingsAnalyzer() {
        return new LuceneMappingsAnalyzer("columnMappingsAnalyzer", LuceneConfiguration.getSchema(COLUMN_SCHEMA_FILE), InternalCatalogIndexingQueueHandler.FACETS_COLUMNS, InternalCatalogIndexingQueueHandler.MULTIVALUED_FIELDS_COLUMNS, InternalCatalogIndexingQueueHandler.JSON_FIELDS_COLUMNS);
    }

    @Bean(value={"pageMappingsAnalyzer"})
    public LuceneMappingsAnalyzer pageMappingsAnalyzer() {
        return new LuceneMappingsAnalyzer("pageMappingsAnalyzer", LuceneConfiguration.getSchema(PAGE_SCHEMA_FILE), PagesSettingsIndexingQueueHandler.FACETS);
    }

    @Bean(value={"pythonDocPortalMappingsAnalyzer"})
    public LuceneMappingsAnalyzer pythonDocPortalMappingsAnalyzer() {
        return new LuceneMappingsAnalyzer("pythonDocPortalMappingsAnalyzer", LuceneConfiguration.getSchema(DOC_PORTAL_SCHEMA_FILE), PythonDocPortalIndexingQueueHandler.FACETS);
    }

    @Bean(value={"internalAndExternalMultiMappingsAnalyzer"})
    public LuceneMultiMappingsAnalyzer internalAndExternalMultiMappingsAnalyzer() {
        return new LuceneMultiMappingsAnalyzer("internalAndExternalMultiMappingsAnalyzer", new LuceneMappingsAnalyzer[]{this.internalMappingsAnalyzer(), this.externalMappingsAnalyzer()});
    }

    @Bean(value={"externalIndexManager"})
    public LuceneSingleIndexManager externalIndexManager() throws IOException {
        return new LuceneSingleIndexManager(EXTERNAL_INDEX_NAME, Paths.get(System.getProperty("DIP_HOME") + "/data-catalog/data/lucene/index/external-connection-objects", new String[0]), this.externalMappingsAnalyzer());
    }

    @Bean(value={"internalIndexManager"})
    public LuceneSingleIndexManager internalIndexManager() throws IOException {
        return new LuceneSingleIndexManager(INTERNAL_INDEX_NAME, Paths.get(System.getProperty("DIP_HOME") + "/data-catalog/data/lucene/index/dss", new String[0]), this.internalMappingsAnalyzer());
    }

    @Bean(value={"columnIndexManager"})
    public LuceneSingleIndexManager columnIndexManager() throws IOException {
        return new LuceneSingleIndexManager(COLUMN_INDEX_NAME, Paths.get(System.getProperty("DIP_HOME") + "/data-catalog/data/lucene/index/dss-columns", new String[0]), this.columnMappingsAnalyzer());
    }

    @Bean(value={"pageIndexManager"})
    public LuceneSingleIndexManager pageIndexManager() throws IOException {
        return new LuceneSingleIndexManager(PAGE_INDEX_NAME, Paths.get(System.getProperty("DIP_HOME") + "/data-catalog/data/lucene/index/pages-settings", new String[0]), this.pageMappingsAnalyzer());
    }

    @Bean(value={"pythonDocPortalIndexManager"})
    public LuceneSingleIndexManager pythonDocPortalIndexManager() throws IOException {
        return new LuceneSingleIndexManager(DOC_PORTAL_INDEX_NAME, Paths.get(System.getProperty("DIP_HOME") + "/data-catalog/data/lucene/index/docportal", new String[0]), this.pythonDocPortalMappingsAnalyzer());
    }

    @Bean(value={"internalAndExternalMultiIndexManager"})
    public LuceneMultiIndexManager internalAndExternalMultiIndexManager() throws IOException {
        return new LuceneMultiIndexManager(ALIAS_NAME, this.internalAndExternalMultiMappingsAnalyzer(), this.internalIndexManager(), this.externalIndexManager());
    }

    private static String getSchema(String relativePath) {
        String string;
        block9: {
            InputStream schemaInputStream = LuceneConfiguration.class.getResourceAsStream(relativePath);
            try {
                if (schemaInputStream == null) {
                    throw new IllegalArgumentException("No resource found at " + relativePath);
                }
                string = IOUtils.toString((InputStream)schemaInputStream, (Charset)StandardCharsets.UTF_8);
                if (schemaInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (schemaInputStream != null) {
                        try {
                            schemaInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid path " + relativePath, e);
                }
            }
            schemaInputStream.close();
        }
        return string;
    }
}

