/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.internal;

import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import org.apache.commons.lang.StringUtils;

public class InternalDataCatalogHelper {
    private InternalDataCatalogHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static String objectKey(String projectKey, String groupId, String objectId, String workspaceKey) {
        return String.format("%s.%s.%s.%s", StringUtils.defaultString((String)projectKey, (String)""), groupId, objectId, StringUtils.defaultString((String)workspaceKey, (String)""));
    }

    public static String objectKey(String projectKey, ITaggingService.TaggableType objectType, String objectId, String workspaceKey) {
        return InternalDataCatalogHelper.objectKey(projectKey, objectType.toString(), objectId, workspaceKey);
    }

    public static String objectKey(TaggableObjectsService.TaggableObject to) {
        return InternalDataCatalogHelper.objectKey(to.getProjectKey(), to.getTaggableType(), to.getId(), null);
    }

    public static String objectKey(TaggableObjectsService.TaggableObjectRef tor) {
        return InternalDataCatalogHelper.objectKey(tor.projectKey, tor.type, tor.id, tor.workspaceKey);
    }

    public static String projectKey(String objectKey) {
        String projectKey = objectKey.split("\\.")[0];
        return "".equals(projectKey) ? null : projectKey;
    }

    public static String objectId(String objectKey) {
        return objectKey.split("\\.")[2];
    }
}

