/*
 * Decompiled with CFR 0.152.
 */
package be.quodlibet.boxable.text;

import be.quodlibet.boxable.text.TextToken;
import be.quodlibet.boxable.text.TokenType;
import java.io.IOException;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class Token {
    private final TokenType type;
    private final String data;

    public Token(TokenType type, String data) {
        this.type = type;
        this.data = data;
    }

    public String getData() {
        return this.data;
    }

    public TokenType getType() {
        return this.type;
    }

    public float getWidth(PDFont font) throws IOException {
        return font.getStringWidth(this.getData());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (Object)((Object)this.type) + "/" + this.data + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return this.getType() == token.getType() && Objects.equals(this.getData(), token.getData());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getData()});
    }

    public static Token text(TokenType type, String data) {
        return new TextToken(type, data);
    }
}

