/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.hbc.twitter4j;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.twitter.hbc.core.Client;
import com.twitter.hbc.twitter4j.BaseTwitter4jClient;
import com.twitter.hbc.twitter4j.handler.UserstreamHandler;
import com.twitter.hbc.twitter4j.message.DisconnectMessage;
import com.twitter.hbc.twitter4j.message.StallWarningMessage;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserStreamListener;

public class Twitter4jUserstreamClient
extends BaseTwitter4jClient {
    private final List<UserStreamListener> userstreamListeners;

    public Twitter4jUserstreamClient(Client client, BlockingQueue<String> blockingQueue, List<UserStreamListener> listeners, ExecutorService executorService) {
        super(client, blockingQueue, executorService);
        Preconditions.checkNotNull(listeners);
        this.userstreamListeners = ImmutableList.copyOf(listeners);
    }

    @Override
    protected void onStatus(long sitestreamUser, Status status) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onStatus(status);
        }
    }

    @Override
    protected void onDelete(long sitestreamUser, StatusDeletionNotice delete) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onDeletionNotice(delete);
        }
    }

    @Override
    protected void onTrackLimitationNotice(long sitestreamUser, int limit) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onTrackLimitationNotice(limit);
        }
    }

    @Override
    protected void onScrubGeo(long sitestreamUser, long userId, long upToStatusId) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onScrubGeo(userId, upToStatusId);
        }
    }

    @Override
    protected void onException(Exception e) {
        super.onException(e);
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onException(e);
        }
    }

    @Override
    protected void onDeleteDirectMessage(long sitestreamUser, long directMessageId, long userId) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onDeletionNotice(directMessageId, userId);
        }
    }

    @Override
    protected void onDirectMessage(long sitestreamUser, DirectMessage directMessage) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onDirectMessage(directMessage);
        }
    }

    @Override
    protected void onFriends(long sitestreamUser, long[] friendIds) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onFriendList(friendIds);
        }
    }

    @Override
    protected void onFavorite(long sitestreamUser, User source, User target, Status faved) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onFavorite(source, target, faved);
        }
    }

    @Override
    protected void onUnfavorite(long sitestreamUser, User source, User target, Status unfaved) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUnfavorite(source, target, unfaved);
        }
    }

    @Override
    protected void onBlock(long sitestreamUser, User source, User blockedUser) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onBlock(source, blockedUser);
        }
    }

    @Override
    protected void onUnblock(long sitestreamUser, User source, User unblockedUser) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUnblock(source, unblockedUser);
        }
    }

    @Override
    protected void onRetweet(long sitestreamUser, User user, User target, Status status) {
        for (UserStreamListener listener : this.userstreamListeners) {
            if (!(listener instanceof UserstreamHandler)) continue;
            ((UserstreamHandler)listener).onRetweet(user, target, status);
        }
    }

    @Override
    protected void onUserListCreation(long sitestreamUser, User user, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListCreation(user, userList);
        }
    }

    @Override
    protected void onUserListDeletion(long sitestreamUser, User user, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListDeletion(user, userList);
        }
    }

    @Override
    protected void onUserListMemberAddition(long sitestreamUser, User addedUser, User user, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListMemberAddition(addedUser, user, userList);
        }
    }

    @Override
    protected void onUserListMemberDeletion(long sitestreamUser, User deletedUser, User user, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListMemberDeletion(deletedUser, user, userList);
        }
    }

    @Override
    protected void onUserListSubscription(long sitestreamUser, User subscriber, User listOwner, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListSubscription(subscriber, listOwner, userList);
        }
    }

    @Override
    protected void onUserListUnsubscription(long sitestreamUser, User subscriber, User listOwner, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListUnsubscription(subscriber, listOwner, userList);
        }
    }

    @Override
    protected void onUserListUpdate(long sitestreamUser, User listOwner, UserList userList) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserListUpdate(listOwner, userList);
        }
    }

    @Override
    protected void onUserProfileUpdate(long sitestreamUser, User user) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onUserProfileUpdate(user);
        }
    }

    @Override
    protected void onFollow(long sitestreamUser, User user, User target) {
        for (UserStreamListener listener : this.userstreamListeners) {
            listener.onFollow(user, target);
        }
    }

    @Override
    protected void onUnfollow(long sitestreamUser, User user, User target) {
        for (UserStreamListener listener : this.userstreamListeners) {
            if (!(listener instanceof UserstreamHandler)) continue;
            ((UserstreamHandler)listener).onUnfollow(user, target);
        }
    }

    @Override
    protected void onDisconnectMessage(DisconnectMessage disconnect) {
        for (UserStreamListener listener : this.userstreamListeners) {
            if (!(listener instanceof UserstreamHandler)) continue;
            ((UserstreamHandler)listener).onDisconnectMessage(disconnect);
        }
    }

    @Override
    protected void onStallWarning(StallWarningMessage stallWarning) {
        for (UserStreamListener listener : this.userstreamListeners) {
            if (!(listener instanceof UserstreamHandler)) continue;
            ((UserstreamHandler)listener).onStallWarningMessage(stallWarning);
        }
    }

    @Override
    protected void onUnknownMessageType(String msg) {
        for (UserStreamListener listener : this.userstreamListeners) {
            if (listener instanceof UserstreamHandler) {
                ((UserstreamHandler)listener).onUnknownMessageType(msg);
                continue;
            }
            super.onUnknownMessageType(msg);
        }
    }
}

