/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Segment;
import com.datastax.driver.core.SegmentCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.nio.ByteOrder;

class BytesToSegmentDecoder
extends LengthFieldBasedFrameDecoder {
    private final SegmentCodec segmentCodec;
    private SegmentCodec.Header header;

    BytesToSegmentDecoder(SegmentCodec segmentCodec) {
        super(segmentCodec.headerLength() + 3 + Segment.MAX_PAYLOAD_LENGTH + 4, 0, segmentCodec.headerLength() + 3, 4, segmentCodec.headerLength() + 3);
        this.segmentCodec = segmentCodec;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        try {
            ByteBuf payloadAndCrc = (ByteBuf)super.decode(ctx, in);
            if (payloadAndCrc == null) {
                return null;
            }
            assert (this.header != null);
            Segment segment = this.segmentCodec.decode(this.header, payloadAndCrc);
            this.header = null;
            return segment;
        }
        catch (Exception e) {
            this.header = null;
            throw e;
        }
    }

    protected long getUnadjustedFrameLength(ByteBuf buffer, int offset, int length, ByteOrder order) {
        if (this.header == null) {
            this.header = this.segmentCodec.decodeHeader(buffer.slice(offset, length));
        }
        return this.header.payloadLength;
    }
}

