/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IAdminBlueprintRoleAssignmentsService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AdminBlueprintRoleAssignmentsController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminBlueprintRoleAssignmentsService adminBlueprintRoleAssignmentsService;

    @AuditedCall(value={"msgType", "blueprint-role-assignments-get", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/get"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        AdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)this.adminBlueprintRoleAssignmentsService.getBlueprintRoleAssignments(authCtx, blueprintId));
    }

    @AuditedCall(value={"msgType", "blueprint-role-assignments-get-or-null", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/get-or-null"}, method={RequestMethod.GET})
    public void getOrNull(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        BlueprintRoleAssignments blueprintRoleAssignments = this.adminBlueprintRoleAssignmentsService.getBlueprintRoleAssignmentsOrNull(authCtx, blueprintId);
        if (blueprintRoleAssignments != null) {
            AdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)blueprintRoleAssignments);
        }
    }

    @AuditedCall(value={"msgType", "blueprint-role-assignments-list"})
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/list"}, method={RequestMethod.GET})
    public void list(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        AdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, this.adminBlueprintRoleAssignmentsService.listBlueprintRoleAssignments(authCtx));
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_CREATE)
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintRoleAssignments blueprintRoleAssignments) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintRoleAssignments createdBlueprintRoleAssignments = this.adminBlueprintRoleAssignmentsService.createBlueprintRoleAssignments(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-role-assignments-create").with("blueprintId", createdBlueprintRoleAssignments.blueprintId).emit();
            AdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)createdBlueprintRoleAssignments);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-role-assignments-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_SAVE)
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam BlueprintRoleAssignments blueprintRoleAssignments) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            BlueprintRoleAssignments savedBlueprintRoleAssignments = this.adminBlueprintRoleAssignmentsService.saveBlueprintRoleAssignments(authCtx, blueprintRoleAssignments);
            this.auditTrailService.generic("blueprint-role-assignments-save").with("blueprintId", savedBlueprintRoleAssignments.blueprintId).emit();
            AdminBlueprintRoleAssignmentsController.writeJSON((HttpServletResponse)resp, (Object)savedBlueprintRoleAssignments);
        }
        catch (Exception e) {
            this.auditTrailService.failure("blueprint-role-assignments-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "blueprint-role-assignments-delete", "blueprintId", "${blueprintId}"})
    @RequestMapping(value={"/api/admin/blueprint-role-assignments/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.BLUEPRINT_ROLE_ASSIGNMENTS_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String blueprintId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminBlueprintRoleAssignmentsService.deleteBlueprintRoleAssignments(authCtx, blueprintId);
        AdminBlueprintRoleAssignmentsController.writeEmptyJSONObj((HttpServletResponse)resp);
    }
}

