/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.dss;

import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.dss.DSSArtifactContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class DSSProjectArtifactsContainer {
    private DSSArtifactContainer.DSSProjectArtifactContainer dssProject = null;
    private final Map<String, DSSArtifactContainer.DSSBundleArtifactContainer> dssBundles = new HashMap<String, DSSArtifactContainer.DSSBundleArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSDatasetArtifactContainer> dssDatasets = new HashMap<String, DSSArtifactContainer.DSSDatasetArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSSavedModelArtifactContainer> dssSavedModels = new HashMap<String, DSSArtifactContainer.DSSSavedModelArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer> dssRetrievableKnowledges = new HashMap<String, DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer>();
    private final Map<String, DSSArtifactContainer.DSSSavedModelVersionArtifactContainer> dssSavedModelVersions = new HashMap<String, DSSArtifactContainer.DSSSavedModelVersionArtifactContainer>();
    public final List<DSSArtifactContainer<?>> duplicatedArtifacts = new ArrayList();

    public DSSArtifactContainer.DSSProjectArtifactContainer getDSSProject() {
        return this.dssProject;
    }

    public Map<String, DSSArtifactContainer.DSSBundleArtifactContainer> getDSSBundles() {
        return this.dssBundles;
    }

    public Map<String, DSSArtifactContainer.DSSDatasetArtifactContainer> getDSSDatasets() {
        return this.dssDatasets;
    }

    public Map<String, DSSArtifactContainer.DSSSavedModelArtifactContainer> getDSSSavedModels() {
        return this.dssSavedModels;
    }

    public Map<String, DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer> getDSSRetrievableKnowledges() {
        return this.dssRetrievableKnowledges;
    }

    public Map<String, DSSArtifactContainer.DSSSavedModelVersionArtifactContainer> getDSSSavedModelVersions() {
        return this.dssSavedModelVersions;
    }

    public void setProject(Artifact artifact, boolean isCreation) {
        this.setProject(DSSArtifactContainer.buildProject(artifact, isCreation));
    }

    public void setProject(DSSArtifactContainer.DSSProjectArtifactContainer container) {
        if (this.dssProject == null) {
            this.dssProject = container;
        } else {
            this.duplicatedArtifacts.add(container);
        }
    }

    public void replaceProject(DSSArtifactContainer.DSSProjectArtifactContainer container) {
        this.dssProject = container;
    }

    public void addBundle(Artifact artifact) {
        this.addBundle(DSSArtifactContainer.buildBundle(artifact));
    }

    public void addBundle(DSSArtifactContainer.DSSBundleArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getDSSBundles, container);
    }

    public void replaceBundle(DSSArtifactContainer.DSSBundleArtifactContainer container) {
        this.dssBundles.put(container.getIdentifier(), container);
    }

    public void addDataset(Artifact artifact) {
        this.addDataset(DSSArtifactContainer.buildDataset(artifact));
    }

    public void addDataset(DSSArtifactContainer.DSSDatasetArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getDSSDatasets, container);
    }

    public void replaceDataset(DSSArtifactContainer.DSSDatasetArtifactContainer container) {
        this.dssDatasets.put(container.getIdentifier(), container);
    }

    public void addSavedModel(Artifact artifact) {
        this.addSavedModel(DSSArtifactContainer.buildSavedModel(artifact));
    }

    public void addSavedModel(DSSArtifactContainer.DSSSavedModelArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getDSSSavedModels, container);
    }

    public void replaceSavedModel(DSSArtifactContainer.DSSSavedModelArtifactContainer container) {
        this.dssSavedModels.put(container.getIdentifier(), container);
    }

    public void addRetrievableKnowledge(Artifact artifact) {
        this.addRetrievableKnowledge(DSSArtifactContainer.buildRetrievableKnowledge(artifact));
    }

    public void addRetrievableKnowledge(DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getDSSRetrievableKnowledges, container);
    }

    public void replaceRetrievableKnowledge(DSSArtifactContainer.DSSRetrievableKnowledgeArtifactContainer container) {
        this.dssRetrievableKnowledges.put(container.getIdentifier(), container);
    }

    public void addSavedModelVersion(Artifact artifact) {
        this.addSavedModelVersion(DSSArtifactContainer.buildSavedModelVersion(artifact));
    }

    public void addSavedModelVersion(DSSArtifactContainer.DSSSavedModelVersionArtifactContainer container) {
        this.checkDuplicateAndAdd(this::getDSSSavedModelVersions, container);
    }

    public void replaceSavedModelVersion(DSSArtifactContainer.DSSSavedModelVersionArtifactContainer container) {
        this.dssSavedModelVersions.put(container.getIdentifier(), container);
    }

    private <T extends DSSArtifactContainer<T>> void checkDuplicateAndAdd(Supplier<Map<String, T>> getTarget, T container) {
        Map<String, T> map = getTarget.get();
        if (map.containsKey(container.getIdentifier())) {
            this.duplicatedArtifacts.add(container);
        } else {
            map.put(container.getIdentifier(), container);
        }
    }
}

