/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.search;

import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactFilterArtifactFieldLogicVisitor;
import com.dataiku.gh.core.models.search.ArtifactFilterFieldConditionType;
import com.dataiku.gh.core.models.search.field_condition_types.TextConditionType;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ArtifactFilterArtifactVisitor
implements ArtifactFilter.IQueryableArtifactFilterVisitor {
    protected final EnrichedArtifactWithoutPermissions enrichedArtifact;
    protected final IArtifactsDataService artifactsDataService;
    public boolean artifactMatches;

    public ArtifactFilterArtifactVisitor(EnrichedArtifactWithoutPermissions enrichedArtifact, IArtifactsDataService artifactsDataService) {
        this.enrichedArtifact = enrichedArtifact;
        this.artifactsDataService = artifactsDataService;
    }

    private boolean handleNegation(boolean matches, ArtifactFilter artifactFilter) {
        return artifactFilter.negateCondition ? !matches : matches;
    }

    @Override
    public void visit(ArtifactFilter.FieldValueArtifactFilter fieldValueArtifactFilter) {
        ArrayList<Object> fieldValues = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)fieldValueArtifactFilter.fieldId)) {
            fieldValues.add(this.enrichedArtifact.artifact.fields.get(fieldValueArtifactFilter.fieldId));
        } else {
            fieldValues.addAll(this.enrichedArtifact.artifact.fields.values());
            fieldValues.add(this.enrichedArtifact.artifact.name);
        }
        boolean fieldValuesMatch = fieldValues.stream().anyMatch(fieldValue -> {
            List<Object> fieldValueIsListAsList;
            ArtifactFilterFieldConditionType conditionType = fieldValueArtifactFilter.conditionType;
            List<Object> list = fieldValueIsListAsList = fieldValue instanceof List ? (List<Object>)fieldValue : null;
            if (fieldValueIsListAsList != null) {
                if (fieldValueArtifactFilter.conditionType != ArtifactFilterFieldConditionType.CONTAINS && fieldValueArtifactFilter.conditionType != ArtifactFilterFieldConditionType.IS_NULL) {
                    return false;
                }
                if (fieldValueArtifactFilter.conditionType == ArtifactFilterFieldConditionType.CONTAINS) {
                    conditionType = ArtifactFilterFieldConditionType.EQUALS;
                }
            }
            List<Object> fieldValueAsList = fieldValueIsListAsList != null ? (fieldValueIsListAsList.isEmpty() ? Collections.singletonList(null) : fieldValueIsListAsList) : Collections.singletonList(fieldValue);
            ArtifactFilterFieldConditionType finalConditionType = conditionType;
            return fieldValueAsList.stream().anyMatch(innerFieldValue -> {
                if (innerFieldValue == null || finalConditionType == ArtifactFilterFieldConditionType.IS_NULL || fieldValueArtifactFilter.condition == null) {
                    return innerFieldValue == null && (finalConditionType == ArtifactFilterFieldConditionType.IS_NULL || finalConditionType == ArtifactFilterFieldConditionType.EQUALS && fieldValueArtifactFilter.condition == null);
                }
                return this.textMatchesSimple(innerFieldValue.toString(), finalConditionType, fieldValueArtifactFilter.condition, fieldValueArtifactFilter.caseSensitive) || this.numberMatchesSimple(innerFieldValue, finalConditionType, fieldValueArtifactFilter.condition) || this.booleanMatchesSimple(innerFieldValue, finalConditionType, fieldValueArtifactFilter.condition, fieldValueArtifactFilter.caseSensitive);
            });
        });
        if (fieldValueArtifactFilter.negateOperator) {
            fieldValuesMatch = !fieldValuesMatch;
        }
        this.artifactMatches = this.handleNegation(fieldValuesMatch, fieldValueArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.TypedFieldValueArtifactFilter typedFieldValueArtifactFilter) {
        ArtifactFilterArtifactFieldLogicVisitor fieldLogicVisitor = new ArtifactFilterArtifactFieldLogicVisitor(this.enrichedArtifact, typedFieldValueArtifactFilter.fieldId, this.artifactsDataService);
        typedFieldValueArtifactFilter.accept(fieldLogicVisitor);
        Boolean matches = fieldLogicVisitor.fieldMatches;
        if (matches != null && typedFieldValueArtifactFilter.negateOperator) {
            matches = matches == false;
        }
        this.artifactMatches = this.handleNegation(Boolean.TRUE.equals(matches), typedFieldValueArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.WorkflowStepArtifactFilter workflowStepArtifactFilter) {
        boolean workflowStatusMatches = this.enrichedArtifact.blueprintVersion.workflowDefinition.stepDefinitions.stream().filter(stepDefinition -> StringUtils.isBlank((CharSequence)workflowStepArtifactFilter.stepId) || StringUtils.equals((CharSequence)stepDefinition.id, (CharSequence)workflowStepArtifactFilter.stepId)).map(stepDefinition -> Optional.ofNullable(this.enrichedArtifact.artifact.workflow.steps.get(stepDefinition.id)).orElse(ArtifactWorkflowStep.build(ArtifactWorkflowStep.StepStatus.NOT_STARTED, true))).filter(step -> Boolean.TRUE.equals(step.visible)).anyMatch(step -> workflowStepArtifactFilter.negateOperator ? step.status != workflowStepArtifactFilter.status : step.status == workflowStepArtifactFilter.status);
        this.artifactMatches = this.handleNegation(workflowStatusMatches, workflowStepArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.SignoffStatusArtifactFilter signoffStatusArtifactFilter) {
        boolean signoffStatusMatches = this.enrichedArtifact.signoffs.stream().filter(signoff -> StringUtils.isBlank((CharSequence)signoffStatusArtifactFilter.stepId) || StringUtils.equals((CharSequence)signoff.signoffId.stepId, (CharSequence)signoffStatusArtifactFilter.stepId)).filter(signoff -> Optional.ofNullable(this.enrichedArtifact.artifact.workflow.steps.get(signoff.signoffId.stepId)).map(step -> step.visible).orElse(false)).anyMatch(signoff -> signoffStatusArtifactFilter.negateOperator ? signoff.status != signoffStatusArtifactFilter.status : signoff.status == signoffStatusArtifactFilter.status);
        this.artifactMatches = this.handleNegation(signoffStatusMatches, signoffStatusArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.BlueprintVersionsArtifactFilter blueprintVersionArtifactFilter) {
        this.artifactMatches = this.handleNegation(blueprintVersionArtifactFilter.blueprintVersionIds.contains(this.enrichedArtifact.blueprintVersion.id), blueprintVersionArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.BlueprintsArtifactFilter blueprintsArtifactFilter) {
        this.artifactMatches = this.handleNegation(blueprintsArtifactFilter.blueprintIds.contains(this.enrichedArtifact.blueprint.id), blueprintsArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.ArtifactsArtifactFilter artifactsArtifactFilter) {
        this.artifactMatches = this.handleNegation(artifactsArtifactFilter.artifactIds.contains(this.enrichedArtifact.artifact.id), artifactsArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.ArtifactNameFilter artifactNameFilter) {
        this.artifactMatches = this.handleNegation(this.textMatchesSimple(this.enrichedArtifact.artifact.name, this.mapToArtifactFilterFieldConditionType(artifactNameFilter.conditionType), artifactNameFilter.condition, artifactNameFilter.caseSensitive), artifactNameFilter);
    }

    @Override
    public void visit(ArtifactFilter.ArtifactIdFilter artifactIdFilter) {
        this.artifactMatches = this.handleNegation(this.textMatchesSimple(this.enrichedArtifact.artifact.id, this.mapToArtifactFilterFieldConditionType(artifactIdFilter.conditionType), artifactIdFilter.condition, artifactIdFilter.caseSensitive), artifactIdFilter);
    }

    @Override
    public void visit(ArtifactFilter.ArchivedStatusArtifactFilter archivedStatusArtifactFilter) {
        this.artifactMatches = this.handleNegation(archivedStatusArtifactFilter.isArchived == this.enrichedArtifact.artifact.status.archived, archivedStatusArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.AndArtifactFilter andArtifactFilter) {
        boolean andArtifactMatches = andArtifactFilter.artifactFilters.stream().allMatch(artifactFilter -> {
            ArtifactFilterArtifactVisitor visitor = new ArtifactFilterArtifactVisitor(this.enrichedArtifact, this.artifactsDataService);
            artifactFilter.getQueryableArtifactFilter().accept(visitor);
            return visitor.artifactMatches;
        });
        this.artifactMatches = this.handleNegation(andArtifactMatches, andArtifactFilter);
    }

    @Override
    public void visit(ArtifactFilter.OrArtifactFilter orArtifactFilter) {
        boolean orArtifactMatches = orArtifactFilter.artifactFilters.isEmpty() ? true : orArtifactFilter.artifactFilters.stream().anyMatch(artifactFilter -> {
            ArtifactFilterArtifactVisitor visitor = new ArtifactFilterArtifactVisitor(this.enrichedArtifact, this.artifactsDataService);
            artifactFilter.getQueryableArtifactFilter().accept(visitor);
            return visitor.artifactMatches;
        });
        this.artifactMatches = this.handleNegation(orArtifactMatches, orArtifactFilter);
    }

    protected boolean textMatchesSimple(String textValue, ArtifactFilterFieldConditionType conditionType, String condition, boolean caseSensitive) {
        switch (conditionType) {
            case EQUALS: {
                return caseSensitive ? textValue.equals(condition) : StringUtils.equalsIgnoreCase((CharSequence)textValue, (CharSequence)condition);
            }
            case CONTAINS: {
                return caseSensitive ? textValue.contains(condition) : StringUtils.containsIgnoreCase((CharSequence)textValue, (CharSequence)condition);
            }
            case START_WITH: {
                return caseSensitive ? textValue.startsWith(condition) : StringUtils.startsWithIgnoreCase((CharSequence)textValue, (CharSequence)condition);
            }
            case END_WITH: {
                return caseSensitive ? textValue.endsWith(condition) : StringUtils.endsWithIgnoreCase((CharSequence)textValue, (CharSequence)condition);
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)conditionType));
    }

    protected boolean numberMatchesSimple(Object value, ArtifactFilterFieldConditionType conditionType, @Nullable String condition) {
        if (condition == null) {
            return false;
        }
        if (!(value instanceof Double)) {
            return false;
        }
        Double doubleValue = (Double)value;
        Double doubleConditionOrNullIfNotADouble = null;
        try {
            doubleConditionOrNullIfNotADouble = Double.valueOf(condition);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (conditionType == ArtifactFilterFieldConditionType.EQUALS && doubleConditionOrNullIfNotADouble != null && Objects.equals(doubleConditionOrNullIfNotADouble, doubleValue)) {
            return true;
        }
        String textValue = doubleValue.toString();
        String textConditionForNumber = doubleConditionOrNullIfNotADouble != null && DoubleMath.isMathematicalInteger((double)doubleConditionOrNullIfNotADouble) ? String.valueOf(doubleConditionOrNullIfNotADouble.longValue()) : condition;
        boolean hasFirstAPlusOrMinus = textConditionForNumber.startsWith("+") || textConditionForNumber.startsWith("-");
        String prefix = "^" + (hasFirstAPlusOrMinus ? "" : "\\+?") + "0*";
        boolean containsADot = textConditionForNumber.contains(".");
        boolean containsAE = textConditionForNumber.toLowerCase().contains("e");
        String suffix = (containsADot || containsAE ? "" : "(\\.0*)?") + "$";
        switch (conditionType) {
            case EQUALS: {
                return Pattern.compile(prefix + Pattern.quote(textConditionForNumber) + suffix, 2).matcher(textValue).find();
            }
            case CONTAINS: {
                return Pattern.compile(Pattern.quote(textConditionForNumber), 2).matcher(textValue).find();
            }
            case START_WITH: {
                return Pattern.compile(prefix + Pattern.quote(textConditionForNumber), 2).matcher(textValue).find();
            }
            case END_WITH: {
                return Pattern.compile(Pattern.quote(textConditionForNumber) + suffix, 2).matcher(textValue).find();
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)conditionType));
    }

    protected boolean booleanMatchesSimple(Object value, ArtifactFilterFieldConditionType conditionType, @Nullable String condition, boolean caseSensitive) {
        String caseSensitiveCondition;
        if (condition == null) {
            return false;
        }
        if (!(value instanceof Boolean)) {
            return false;
        }
        Boolean booleanValue = (Boolean)value;
        String string = caseSensitiveCondition = caseSensitive ? condition : condition.toLowerCase();
        if (conditionType == ArtifactFilterFieldConditionType.EQUALS && ("true".equals(caseSensitiveCondition) || "false".equals(caseSensitiveCondition)) && booleanValue.toString().equals(caseSensitiveCondition)) {
            return true;
        }
        String textValue = booleanValue.toString();
        switch (conditionType) {
            case EQUALS: {
                return Pattern.compile("^" + Pattern.quote(condition) + "$", 2).matcher(textValue).matches();
            }
            case CONTAINS: {
                return Pattern.compile(Pattern.quote(condition), 2).matcher(textValue).matches();
            }
            case START_WITH: {
                return Pattern.compile("^" + Pattern.quote(condition), 2).matcher(textValue).matches();
            }
            case END_WITH: {
                return Pattern.compile(Pattern.quote(condition) + "$", 2).matcher(textValue).matches();
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)conditionType));
    }

    private ArtifactFilterFieldConditionType mapToArtifactFilterFieldConditionType(TextConditionType textConditionType) {
        switch (textConditionType) {
            case EQUALS: {
                return ArtifactFilterFieldConditionType.EQUALS;
            }
            case CONTAINS: {
                return ArtifactFilterFieldConditionType.CONTAINS;
            }
            case START_WITH: {
                return ArtifactFilterFieldConditionType.START_WITH;
            }
            case END_WITH: {
                return ArtifactFilterFieldConditionType.END_WITH;
            }
        }
        throw new ValidationException("Unhandled filter type " + String.valueOf((Object)textConditionType));
    }
}

