/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.signoff;

import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.visitors.ISignoffVisitor;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.Objects;

public class SignoffApproval {
    public String user;
    public SignoffApprovalStatus status;
    public String creationDate;
    @UINullable
    public String editionDate;
    @UINullable
    public String comment;

    public void updateCommentAndStatus(String comment, SignoffApprovalStatus status) {
        this.editionDate = DateUtils.now();
        this.comment = comment;
        this.status = status;
    }

    public void accept(ISignoffVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignoffApproval that = (SignoffApproval)o;
        return Objects.equals(this.user, that.user) && this.status == that.status && Objects.equals(this.creationDate, that.creationDate) && Objects.equals(this.editionDate, that.editionDate) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.status, this.creationDate, this.editionDate, this.comment});
    }

    public static SignoffApproval build(String user, String comment, SignoffApprovalStatus status) {
        SignoffApproval approval = new SignoffApproval();
        approval.creationDate = DateUtils.now();
        approval.editionDate = null;
        approval.user = user;
        approval.comment = comment;
        approval.status = status;
        return approval;
    }

    public static enum SignoffApprovalStatus {
        APPROVED,
        REJECTED,
        ABANDONED;

    }
}

