/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.governance.hide;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.bool.BooleanFieldDefinition;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.dss.search_artifacts.DSSIntegrationArtifactsSearchQueryBuilder;
import com.dataiku.gh.core.services.dss.sync.DSSObjectsToArtifactMapperService;
import com.dataiku.gh.core.services.governance.IGovernancePermissionService;
import com.dataiku.gh.core.services.governance.IGovernanceQueueExecutorService;
import com.dataiku.gh.core.services.governance.hide.IGovernanceHideService;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.roles_and_permissions.ICheckPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.context.UserRolesCacheContext;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.utils.ITransactionHandler;
import com.dataiku.gh.core.services.utils.ITransactionScope;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.artifacts.IArtifactDAO;
import com.dataiku.gh.core.storage.search.IArtifactSearchDAO;
import com.dataiku.gh.core.storage.sql.search.PartialEnrichedArtifact;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GovernanceHideService
implements IGovernanceHideService {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.govern-hide");
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private IGovernancePermissionService governancePermissionService;
    @Autowired
    private IArtifactDAO artifactDAO;
    @Autowired
    private ITransactionHandler transactionHandler;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ISystemArtifactService systemArtifactService;
    @Autowired
    private IArtifactSearchDAO artifactSearchDAO;
    @Autowired
    private IGovernanceQueueExecutorService automaticGovernanceQueueService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private ICheckPermissionsService checkPermissionsService;

    @Override
    public List<String> setArtifactVisibilities(AuthCtx authCtx, List<String> artifactIds, boolean hidden) throws IOException, DKUSecurityException {
        this.licenseEnforcementService.checkWriteGovernAllowed(authCtx);
        ArrayList<String> modifiedArtifacts = new ArrayList<String>();
        try (UserRolesCacheContext.ContextContainer rolesCache = UserRolesCacheContext.attachNewContext();
             ITransactionScope ts = this.transactionHandler.openNewWriteTransaction();){
            for (String artifactId : artifactIds) {
                EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
                AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = this.rolesAndPermissionsService.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(authCtx, enrichedArtifact);
                this.checkPermissionsService.checkArtifactReadPermission_NoLicenseCheck(assignedRolesAndPermissionsCtx.effectivePermissionsItem, enrichedArtifact.artifact.id);
                boolean hasPermission = this.governancePermissionService.hasAtLeastOneBPVWithCreatePermission(authCtx, GovernanceUtils.getDefaultGoverningBlueprintIdForDSSArtifact(enrichedArtifact.artifact));
                if (!hasPermission) {
                    throw new UnauthorizedException("Permission denied: unable to change this item visibility " + enrichedArtifact.artifact.name, "governable-items-visibility-change-denied");
                }
                modifiedArtifacts.addAll(this.systemSetArtifactVisibility(enrichedArtifact, hidden));
            }
            ts.commit();
        }
        if (!hidden) {
            try {
                this.automaticGovernanceQueueService.addToGovernanceQueue(modifiedArtifacts);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to add artifacts to the auto-governance queue", (Throwable)e);
            }
        }
        return modifiedArtifacts;
    }

    @Override
    @GHWriteTransaction
    public List<String> systemSetArtifactVisibility(EnrichedArtifact enrichedArtifact, boolean hidden) throws IOException {
        if (hidden && enrichedArtifact.artifact.fields.get("governed_by") != null) {
            throw new ValidationException(String.format("Unable to hide Artifact '%s', as it is governed.", enrichedArtifact.artifact.id));
        }
        if (!this.checkEntryArtifactVisibilityCanBeUpdated(enrichedArtifact, hidden)) {
            return Collections.emptyList();
        }
        if (!hidden) {
            List<EnrichedArtifact> artifactAndAncestry = this.artifactsDataService.getArtifactAndAncestryOfDataikuArtifact(enrichedArtifact);
            artifactAndAncestry.remove(0);
            for (EnrichedArtifact parent : artifactAndAncestry) {
                if (!Objects.equals(parent.artifact.fields.get("hidden_in_governable_items_table"), true)) continue;
                throw new ValidationException(String.format("The Artifact '%s' can't be un-hidden, as its ancestor Artifact '%s' is hidden.", enrichedArtifact.artifact.id, parent.artifact.id));
            }
        }
        List<String> updatedArtifactIds = this.setChildrenVisibility(enrichedArtifact, hidden);
        this.updateEntryArtifact(enrichedArtifact, updatedArtifactIds, hidden);
        return updatedArtifactIds;
    }

    @Override
    @GHWriteTransaction
    public List<String> systemSetChildrenVisibility(EnrichedArtifact enrichedArtifact, boolean hidden) throws IOException {
        if (!hidden) {
            List<EnrichedArtifact> artifactAndAncestry = this.artifactsDataService.getArtifactAndAncestryOfDataikuArtifact(enrichedArtifact);
            for (EnrichedArtifact parent : artifactAndAncestry) {
                if (!Objects.equals(parent.artifact.fields.get("hidden_in_governable_items_table"), true)) continue;
                throw new ValidationException(String.format("The Artifact '%s' can't be un-hidden, as its ancestor Artifact '%s' is hidden.", enrichedArtifact.artifact.id, parent.artifact.id));
            }
        }
        return this.setChildrenVisibility(enrichedArtifact, hidden);
    }

    private List<String> setChildrenVisibility(EnrichedArtifact enrichedArtifact, boolean hidden) throws IOException {
        ArrayList<String> updatedArtifactIds = new ArrayList<String>();
        Optional<List<ArtifactFilter>> possibleChildrenFetchingFilters = this.buildPotentialChildrenFetchingFilters(enrichedArtifact, hidden);
        if (possibleChildrenFetchingFilters.isPresent()) {
            long governedChildrenCount;
            List<ArtifactFilter> childrenToUpdateFilters = possibleChildrenFetchingFilters.get();
            if (hidden && (governedChildrenCount = this.artifactSearchDAO.searchCount(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Stream.concat(childrenToUpdateFilters.stream(), Stream.of(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("governed_by", null, true, true))).collect(Collectors.toList()))) > 0L) {
                throw new ValidationException(this.buildGovernedChildrenExceptionString(enrichedArtifact.artifact.id, governedChildrenCount, childrenToUpdateFilters));
            }
            updatedArtifactIds.addAll(this.artifactDAO.batchUpdateArtifactsField(childrenToUpdateFilters, "hidden_in_governable_items_table", hidden));
        }
        return updatedArtifactIds;
    }

    private String buildGovernedChildrenExceptionString(String artifactId, long governedChildrenCount, List<ArtifactFilter> childrenToUpdateFilters) throws IOException {
        List<String> firstChildrenIds;
        int fetchedIdsLimit;
        String governedChildrenMessage;
        if (governedChildrenCount > 5L) {
            governedChildrenMessage = "5 first";
            fetchedIdsLimit = 5;
        } else {
            governedChildrenMessage = String.valueOf(governedChildrenCount);
            fetchedIdsLimit = (int)governedChildrenCount;
        }
        try (Stream<PartialEnrichedArtifact> artifactStream = this.artifactSearchDAO.searchStream(ArtifactSearchSourceConfig.AllArtifactSearchSource.build(), Stream.concat(childrenToUpdateFilters.stream(), Stream.of(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("governed_by", null, true, true))).collect(Collectors.toList()), null, null);){
            firstChildrenIds = artifactStream.map(ea -> ea.artifact.id).limit(fetchedIdsLimit).toList();
        }
        return String.format("Unable to hide Artifact '%s', as some of its children are governed. %s IDs: %s.", artifactId, governedChildrenMessage, String.join((CharSequence)" ; ", firstChildrenIds));
    }

    private void updateEntryArtifact(EnrichedArtifact enrichedArtifact, List<String> updatedArtifactIds, boolean hidden) throws IOException {
        enrichedArtifact.artifact.fields.put("hidden_in_governable_items_table", hidden);
        this.systemArtifactService.updateSystemArtifact(enrichedArtifact.artifact);
        updatedArtifactIds.add(enrichedArtifact.artifact.id);
    }

    private boolean checkEntryArtifactVisibilityCanBeUpdated(EnrichedArtifact enrichedArtifact, boolean hidden) {
        FieldDefinition hiddenFieldDefinition = enrichedArtifact.blueprintVersion.fieldDefinitions.get("hidden_in_governable_items_table");
        if (!(hiddenFieldDefinition instanceof BooleanFieldDefinition)) {
            throw new ValidationException(String.format("The Artifact '%s' does not have a correct '%s' field", enrichedArtifact.artifact.id, "hidden_in_governable_items_table"));
        }
        return !Objects.equals(enrichedArtifact.artifact.fields.get("hidden_in_governable_items_table"), hidden);
    }

    private Optional<List<ArtifactFilter>> buildPotentialChildrenFetchingFilters(EnrichedArtifact parentArtifact, boolean hidden) {
        ArtifactFilter onlyFetchElementsWithHiddenStateToBeUpdated = DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("hidden_in_governable_items_table", String.valueOf(hidden), true, false);
        DSSProjectIdentifier projectIdentifier = DSSObjectsToArtifactMapperService.getProjectIdentifierFromDataikuProjectItemArtifact(parentArtifact.artifact);
        if (SystemProvidedConstants.DATAIKU_PROJECT.matchBlueprint(parentArtifact.blueprintVersion.id)) {
            return Optional.of(DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(projectIdentifier, (List<SystemProvidedEnrichedBlueprint>)Lists.newArrayList((Object[])new SystemProvidedEnrichedBlueprint[]{SystemProvidedConstants.DATAIKU_BUNDLE, SystemProvidedConstants.DATAIKU_SAVED_MODEL, SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION}), (List<ArtifactFilter>)Lists.newArrayList((Object[])new ArtifactFilter[]{onlyFetchElementsWithHiddenStateToBeUpdated})));
        }
        if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.matchBlueprint(parentArtifact.blueprintVersion.id)) {
            List<String> requiredKeys = List.of("node_id", "project_key", "saved_model_id");
            for (String key : requiredKeys) {
                if (parentArtifact.artifact.fields.containsKey(key)) continue;
                logger.error((Object)("Couldn't update model artifact with ID: " + parentArtifact.artifact.id + " as it's missing a " + key));
                return Optional.empty();
            }
            return Optional.of(DSSIntegrationArtifactsSearchQueryBuilder.buildFilters(projectIdentifier, Collections.singletonList(SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION), List.of(DSSIntegrationArtifactsSearchQueryBuilder.buildFieldValueArtifactFilter("saved_model_id", (String)parentArtifact.artifact.fields.get("saved_model_id"), false, false), onlyFetchElementsWithHiddenStateToBeUpdated)));
        }
        return Optional.empty();
    }
}

