/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.plugins;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.plugins.GHPluginAction;
import com.dataiku.gh.core.models.plugins.GHPluginActionMeta;
import com.dataiku.gh.core.models.plugins.PluginDesc;
import com.dataiku.gh.core.services.plugins.IPluginsLoadService;
import com.dataiku.gh.core.services.plugins.IPluginsRegistryService;
import com.dataiku.gh.core.services.plugins.PluginsClazzLoader;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import java.io.File;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pluginsLoadService")
public class PluginsLoadService
implements IPluginsLoadService {
    private File baseBuiltinDir;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private IPluginsRegistryService pluginsRegistryService;
    private static DKULogger logger = DKULogger.getLogger((String)"gh.plugins");

    @PostConstruct
    public void autoLoad() {
        logger.info((Object)"Init plugins load service");
        this.baseBuiltinDir = ApplicationConfigurator.getInstallFile((String[])new String[]{"plugins"});
        try (Transaction tr = this.transactionService.beginRead();){
            this.loadFromDirectory(this.baseBuiltinDir);
        }
        logger.debug((Object)"Done init plugins load service");
    }

    private void loadFromDirectory(File dir) {
        if (dir.isDirectory()) {
            for (File pluginDir : dir.listFiles()) {
                if (!pluginDir.isDirectory()) continue;
                try {
                    this.loadPlugin(pluginDir);
                }
                catch (Exception e) {
                    logger.warn((Object)("Loading plugin " + String.valueOf(pluginDir) + " failed"), (Throwable)e);
                }
                catch (UnsupportedClassVersionError e) {
                    logger.warn((Object)("Loading plugin " + String.valueOf(pluginDir) + " failed. Upgrade your version of Java to use it."), (Throwable)e);
                }
            }
        }
    }

    private void loadPlugin(File pluginDir) {
        logger.info((Object)("Loading plugin from " + String.valueOf(pluginDir)));
        String pluginId = pluginDir.getName();
        this.pluginsRegistryService.checkNotRegistered(pluginId);
        PluginDesc desc = new PluginDesc();
        this.pluginsRegistryService.register(pluginId, desc);
        this.loadBlueprints(pluginDir, pluginId, desc);
        this.loadActions(pluginDir, pluginId, desc);
    }

    private void loadActions(File pluginDir, String pluginId, PluginDesc desc) {
        File dir = new File(pluginDir, "actions");
        if (dir.isDirectory()) {
            for (File elementDirectory : dir.listFiles()) {
                File actionMetaFile = new File(elementDirectory, "action.json");
                if (!actionMetaFile.isFile()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading plugin action from " + String.valueOf(elementDirectory)));
                }
                try {
                    GHPluginActionMeta meta = (GHPluginActionMeta)JSON.parseFile((File)actionMetaFile, GHPluginActionMeta.class);
                    String elementId = elementDirectory.getName();
                    try {
                        File javaLibDir = new File(pluginDir, "java-lib");
                        PluginsClazzLoader clazzLoader = new PluginsClazzLoader();
                        clazzLoader.withJarsInRecursiveDir(javaLibDir.getAbsolutePath());
                        GHPluginAction actionInstance = (GHPluginAction)clazzLoader.newInstance(meta.className);
                        SpringUtils.getInstance().autowire((Object)actionInstance);
                        desc.actions.put(elementId, actionInstance);
                    }
                    catch (Error | Exception e) {
                        logger.errorV(e, "Cannot instantiate action class: %s for plugin: %s. Please check for an plugin update or fix the plugin", new Object[]{elementId, pluginId});
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("Loading plugin action from " + String.valueOf(elementDirectory) + " failed"), (Throwable)e);
                }
            }
        }
    }

    private void loadBlueprints(File pluginDir, String pluginId, PluginDesc desc) {
        File dir = new File(pluginDir, "blueprints");
        if (dir.isDirectory()) {
            for (File blueprintDir : dir.listFiles()) {
                File blueprintFile = new File(blueprintDir, "blueprint.json");
                if (!blueprintFile.isFile()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading plugin blueprint from " + String.valueOf(blueprintDir)));
                }
                try {
                    String blueprintId;
                    Blueprint blueprint = (Blueprint)JSON.parseFile((File)blueprintFile, Blueprint.class);
                    String identifier = blueprintDir.getName();
                    blueprint.id = blueprintId = IdentifiersUtils.buildBlueprintIdForPlugin(pluginId, identifier);
                    desc.blueprints.put(blueprint.id, blueprint);
                    this.loadBlueprintVersions(blueprintDir, blueprintId, pluginId, desc);
                }
                catch (Exception e) {
                    logger.warn((Object)("Loading plugin blueprint from " + String.valueOf(blueprintDir) + " failed"), (Throwable)e);
                }
            }
        }
    }

    private void loadBlueprintVersions(File blueprintDir, String blueprintId, String pluginId, PluginDesc desc) {
        File dir = new File(blueprintDir, "versions");
        if (dir.isDirectory()) {
            for (File blueprintVersionDir : dir.listFiles()) {
                File blueprintVersionFile = new File(blueprintVersionDir, "blueprint-version.json");
                if (!blueprintVersionFile.isFile()) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Loading plugin blueprint version from " + String.valueOf(blueprintVersionDir)));
                }
                try {
                    BlueprintVersion blueprintVersion = (BlueprintVersion)JSON.parseFile((File)blueprintVersionFile, BlueprintVersion.class);
                    String identifier = blueprintVersionDir.getName();
                    blueprintVersion.id = BlueprintVersionId.build(blueprintId, IdentifiersUtils.buildBlueprintVersionIdForPlugin(pluginId, identifier));
                    desc.blueprintVersions.put(blueprintVersion.id, blueprintVersion);
                }
                catch (Exception e) {
                    logger.warn((Object)("Loading plugin blueprint version from " + String.valueOf(blueprintVersionDir) + " failed"), (Throwable)e);
                }
            }
        }
    }
}

