/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.python_execution;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.kernel.GHPythonKernel;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.HookPhase;
import com.dataiku.gh.core.models.blueprints.LogicalHook;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.governance.AutoGovernanceScriptOutput;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.services.artifacts.IArtifactPatchupService;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.artifacts.context.EnrichedArtifactContext;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.PythonExecutionRequest;
import com.dataiku.gh.core.services.python_execution.PythonExecutionResponse;
import com.dataiku.gh.core.services.python_execution.PythonExecutionStatus;
import com.dataiku.gh.core.services.python_execution.autogovernance_script.AutoGovernanceScriptException;
import com.dataiku.gh.core.services.python_execution.autogovernance_script.AutoGovernanceScriptResponse;
import com.dataiku.gh.core.services.python_execution.logical_hooks.HooksExecutionResult;
import com.dataiku.gh.core.services.python_execution.logical_hooks.LogicalHookException;
import com.dataiku.gh.core.services.python_execution.logical_hooks.LogicalHookResponse;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathException;
import com.dataiku.gh.core.services.python_execution.migration_paths.MigrationPathResponse;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.TransactionUtils;
import com.dataiku.gh.core.services.validation.IArtifactValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.NeverForgettingQueue;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service
public class PythonExecutionService
implements IPythonExecutionService {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private IArtifactValidationService artifactValidationService;
    @Autowired
    private IArtifactPatchupService artifactPatchupService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private GHPythonKernel _kernel;
    private final Lock lock = new ReentrantLock();
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.logical-hook");

    @PostConstruct
    void init() throws Exception {
        this.startKernel();
    }

    private synchronized void startKernel() throws Exception {
        if (this._kernel == null || this._kernel.isFinished()) {
            this._kernel = new GHPythonKernel("Govern-Kernel", () -> new Thread(() -> {
                try {
                    this.startKernel();
                }
                catch (Exception e) {
                    logger.error((Object)"Unexpected error (python kernel cannot start). Ask your administrator to investigate.", (Throwable)e);
                }
            }).start());
            this._kernel.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <REQ extends PythonExecutionRequest, RESP extends PythonExecutionResponse> RESP applyHook(ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException> ticketSupplier, Supplier<REQ> requestSupplier, Class<RESP> clazz) throws IOException {
        try {
            long timeoutMs = DKUApp.getParams().getLongParam("dku.govern.python-execution.lock-timeout", 30000L);
            if (!this.lock.tryLock(timeoutMs, TimeUnit.MILLISECONDS)) throw new IOException("Cannot perform the action: unable to start the script (acquiring python execution lock was too long: " + timeoutMs + "ms). Ask your administrator to investigate.");
            try {
                APITicketService.Ticket ticket = (APITicketService.Ticket)ticketSupplier.get();
                PythonExecutionRequest req = (PythonExecutionRequest)requestSupplier.get();
                req.ticketSecret = ticket.getSecret();
                req.timeout = DKUApp.getParams().getLongParam("dku.govern.python-execution.execution-timeout", 60000L);
                try {
                    this.startKernel();
                }
                catch (Exception e) {
                    throw new IOException("Unexpected error (python kernel cannot start). Ask your administrator to investigate.", e);
                }
                PythonExecutionResponse resp = (PythonExecutionResponse)this._kernel.execute(req, clazz);
                this.apiTicketService.expireTicket(ticket);
                PythonExecutionResponse pythonExecutionResponse = resp;
                return (RESP)pythonExecutionResponse;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Unexpected error (python execution lock acquiring was interrupted). Ask your administrator to investigate.", e);
        }
    }

    private LogicalHookResponse applyHook(HookPhase hookPhase, LogicalHook hook, @Nullable EnrichedArtifact newEnrichedArtifact, @Nullable EnrichedArtifact existingEnrichedArtifact) throws IOException {
        return this.applyHook((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForLogicalHook(hook, newEnrichedArtifact, existingEnrichedArtifact)), () -> {
            PythonExecutionRequest.LogicalHookRequest req = new PythonExecutionRequest.LogicalHookRequest();
            req.hookPhase = hookPhase;
            req.hook = hook;
            req.existingEnrichedArtifact = existingEnrichedArtifact;
            req.newEnrichedArtifact = newEnrichedArtifact;
            return req;
        }, LogicalHookResponse.class);
    }

    private MigrationPathResponse applyMigration(BlueprintVersionMigrationPath migrationPath, EnrichedArtifact artifactToMigrate, EnrichedBlueprintVersion targetEnrichedBlueprintVersion) throws IOException {
        return this.applyHook((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)() -> this.createTicketForMigration(migrationPath)), () -> {
            PythonExecutionRequest.MigrationPathRequest req = new PythonExecutionRequest.MigrationPathRequest();
            req.migrationPath = migrationPath;
            req.sourceEnrichedArtifact = artifactToMigrate;
            req.targetEnrichedBlueprintVersion = targetEnrichedBlueprintVersion;
            return req;
        }, MigrationPathResponse.class);
    }

    private AutoGovernanceScriptResponse applyAutoGovernanceScript(String script, EnrichedArtifact dkuEnrichedArtifact) throws IOException {
        return this.applyHook((ExceptionUtils.ThrowingSupplier<APITicketService.Ticket, IOException>)((ExceptionUtils.ThrowingSupplier)this::createTicketForAutoGovernance), () -> {
            PythonExecutionRequest.AutoGovernanceScriptRequest req = new PythonExecutionRequest.AutoGovernanceScriptRequest();
            req.dkuEnrichedArtifact = dkuEnrichedArtifact;
            req.script = script;
            return req;
        }, AutoGovernanceScriptResponse.class);
    }

    private APITicketService.Ticket createTicketForLogicalHook(LogicalHook hook, @Nullable EnrichedArtifact newEnrichedArtifact, @Nullable EnrichedArtifact existingEnrichedArtifact) throws IOException {
        Optional<EnrichedArtifact> anyEnrichedArtifact = Optional.ofNullable(Optional.ofNullable(existingEnrichedArtifact).orElse(newEnrichedArtifact));
        Optional<String> blueprintVersionName = anyEnrichedArtifact.map(ea -> ea.blueprint.name + (String)(StringUtils.isNotBlank((CharSequence)ea.blueprintVersion.name) ? " (" + ea.blueprintVersion.name + ")" : ""));
        Optional<String> blueprintVersionId = anyEnrichedArtifact.map(ea -> ea.blueprintVersion.id.blueprintId + "-" + ea.blueprintVersion.id.versionId);
        String hookIdentifier = "logical-hook__" + blueprintVersionId.map(s -> s + "__").orElse("") + hook.name;
        String apiKeyLabel = "API Key for logical hook: " + hook.name;
        String apiKeyDesc = "API Key for logical hook: " + blueprintVersionName.map(s -> s + ", ").orElse("") + hook.name + ", " + hookIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(hookIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private APITicketService.Ticket createTicketForMigration(BlueprintVersionMigrationPath migration) throws IOException {
        String migrationIdentifier = "migration-path__" + migration.id;
        String apiKeyLabel = "API Key for migration path: " + migration.id;
        String apiKeyDesc = "API Key for migration migration: " + migration.name + ", " + migrationIdentifier;
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(migrationIdentifier, apiKeyLabel, apiKeyDesc);
    }

    private APITicketService.Ticket createTicketForAutoGovernance() throws IOException {
        String identifier = "autogovernance-script";
        String apiKeyLabel = "API Key for autogovernance-script";
        return this.createFakeAPIKeyAuthCtxFromIdentifiers(identifier, apiKeyLabel, apiKeyLabel);
    }

    private APITicketService.Ticket createFakeAPIKeyAuthCtxFromIdentifiers(String apiKeyId, String apiKeyLabel, String apiKeyDescription) throws IOException {
        GlobalScopePublicAPIKey publicAPIAPIKey = new GlobalScopePublicAPIKey();
        publicAPIAPIKey.id = apiKeyId;
        publicAPIAPIKey.label = apiKeyLabel;
        publicAPIAPIKey.description = apiKeyDescription;
        publicAPIAPIKey.createdBy = apiKeyId;
        publicAPIAPIKey.createdOn = System.currentTimeMillis();
        publicAPIAPIKey.globalPermissions.setMayManageGovern(true);
        GHAuthCtx publicAPIAuthCtx = GHAuthCtx.forAPIKey(publicAPIAPIKey);
        return this.apiTicketService.createTicket((AuthCtx)publicAPIAuthCtx, apiKeyId, (Object)this).withRefreshableAuthCtx(false);
    }

    private HooksExecutionResult applyHooks(HookPhase hookPhase, List<LogicalHook> hooksToApply, @Nullable EnrichedArtifact newEnrichedArtifact, @Nullable EnrichedArtifact existingEnrichedArtifact) throws IOException {
        ArrayList<String> artifactIdsToUpdate = new ArrayList<String>();
        if (hookPhase != HookPhase.DELETE) {
            this.artifactValidationService.validateArtifact(newEnrichedArtifact, existingEnrichedArtifact);
            this.artifactPatchupService.patchupArtifact(newEnrichedArtifact);
            if (newEnrichedArtifact != null) {
                newEnrichedArtifact.artifact.status.stepId = newEnrichedArtifact.artifact.getLegacyStepId(this.artifactWorkflowService.computeVisibleArtifactWorkflowSteps(newEnrichedArtifact));
            }
        }
        for (LogicalHook hook : hooksToApply) {
            LogicalHookResponse resp = this.applyHook(hookPhase, hook, newEnrichedArtifact, existingEnrichedArtifact);
            if (resp.status == null) {
                throw new LogicalHookException("Unexpected error (python kernel did not return any statuses). Ask your administrator to investigate.", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, Map.of());
            }
            if (resp.status == PythonExecutionStatus.ERROR) {
                throw new LogicalHookException(resp.message, hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, resp.fieldMessages);
            }
            if (hookPhase != HookPhase.DELETE) {
                if (resp.artifact == null) {
                    logger.warn((Object)("The following logical hook removed the artifact value: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name));
                } else {
                    try {
                        Artifact artifact = (Artifact)JSON.parse((String)resp.artifact, Artifact.class);
                        if (!Objects.equals(artifact.id, newEnrichedArtifact.artifact.id)) {
                            logger.warn((Object)("The following logical hook replaced the artifact ID: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name));
                            artifact.id = newEnrichedArtifact.artifact.id;
                        }
                        if (!Objects.equals(artifact.blueprintVersionId, newEnrichedArtifact.artifact.blueprintVersionId)) {
                            logger.warn((Object)("The following logical hook replaced the artifact blueprintVersion ID: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name));
                            artifact.blueprintVersionId = newEnrichedArtifact.artifact.blueprintVersionId;
                        }
                        this.setHookArtifactWithWorkflow(existingEnrichedArtifact, newEnrichedArtifact, artifact);
                    }
                    catch (JsonSyntaxException e) {
                        logger.warn((Object)("The following logical hook returned an invalid artifact value: " + newEnrichedArtifact.artifact.blueprintVersionId.toString() + ", " + hook.name + ", " + resp.artifact), (Throwable)e);
                    }
                }
                try {
                    this.artifactValidationService.validateArtifact(newEnrichedArtifact, existingEnrichedArtifact);
                }
                catch (ValidationException e) {
                    throw new LogicalHookException("The item returned by the logical hook is invalid", hook.name, existingEnrichedArtifact != null ? existingEnrichedArtifact : newEnrichedArtifact, e);
                }
                this.artifactPatchupService.patchupArtifact(newEnrichedArtifact);
            }
            artifactIdsToUpdate.addAll(resp.artifactIdsToUpdate);
        }
        return HooksExecutionResult.build(newEnrichedArtifact, artifactIdsToUpdate);
    }

    private void setHookArtifactWithWorkflow(EnrichedArtifact existingEnrichedArtifact, EnrichedArtifact newEnrichedArtifact, Artifact hookArtifact) {
        try (EnrichedArtifactContext.EnrichedArtifactContextContainer enrichedArtifactContext = EnrichedArtifactContext.attachNewContextOrKeepExistingOne();){
            String legacyStepId = newEnrichedArtifact.artifact.status.stepId;
            if (!Objects.equals(hookArtifact.status.stepId, legacyStepId)) {
                newEnrichedArtifact.artifact = hookArtifact;
                hookArtifact.workflow = this.artifactWorkflowService.getArtifactWorkflowFromInputStepId(existingEnrichedArtifact, newEnrichedArtifact);
            } else {
                hookArtifact.workflow = this.artifactWorkflowService.prepareWorkflowForSaving(newEnrichedArtifact, hookArtifact, true);
                newEnrichedArtifact.artifact = hookArtifact;
            }
        }
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForCreation(EnrichedArtifact newEnrichedArtifact) throws IOException {
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.CREATE, this.getHookList(newEnrichedArtifact.blueprintVersion, HookPhase.CREATE), newEnrichedArtifact, null);
        this.updateAffectedArtifacts(hooksExecutionResult, newEnrichedArtifact.artifact.id);
        return hooksExecutionResult;
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForUpdate(EnrichedArtifact newEnrichedArtifact, EnrichedArtifact existingEnrichedArtifact) throws IOException {
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.UPDATE, this.getHookList(existingEnrichedArtifact.blueprintVersion, HookPhase.UPDATE), newEnrichedArtifact, existingEnrichedArtifact);
        this.updateAffectedArtifacts(hooksExecutionResult, newEnrichedArtifact.artifact.id);
        return hooksExecutionResult;
    }

    @Override
    public HooksExecutionResult applyLogicalHooksForDeletion(EnrichedArtifact existingEnrichedArtifact) throws IOException {
        HooksExecutionResult hooksExecutionResult = this.applyHooks(HookPhase.DELETE, this.getHookList(existingEnrichedArtifact.blueprintVersion, HookPhase.DELETE), null, existingEnrichedArtifact);
        this.updateAffectedArtifacts(hooksExecutionResult, existingEnrichedArtifact.artifact.id);
        return hooksExecutionResult;
    }

    @Override
    public Artifact applyBlueprintVersionMigrationPath(EnrichedArtifact enrichedArtifactToMigrate, BlueprintVersionMigrationPath migration, EnrichedBlueprintVersion enrichedTargetBlueprintVersion) throws IOException {
        Artifact artifact;
        MigrationPathResponse resp = this.applyMigration(migration, enrichedArtifactToMigrate, enrichedTargetBlueprintVersion);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new MigrationPathException(resp.message, migration.id);
        }
        if (resp.migratedArtifact == null) {
            throw new MigrationPathException("The migration path did not return any artifact value", migration.id);
        }
        try {
            artifact = (Artifact)JSON.parse((String)resp.migratedArtifact, Artifact.class);
            if (!Objects.equals(artifact.id, enrichedArtifactToMigrate.artifact.id)) {
                logger.warn((Object)("The following migration path replaced the artifact ID: " + migration.id));
                artifact.id = enrichedArtifactToMigrate.artifact.id;
            }
            artifact.blueprintVersionId = migration.blueprintVersionIdTo;
            EnrichedArtifact newEnrichedArtifact = EnrichedArtifact.build(enrichedTargetBlueprintVersion.blueprint, enrichedTargetBlueprintVersion.blueprintVersion, enrichedTargetBlueprintVersion.blueprintVersionTrace, null, null, null, artifact, enrichedArtifactToMigrate.signoffs, enrichedArtifactToMigrate.enrichedArtifactDetails);
            artifact.workflow = this.artifactWorkflowService.prepareWorkflowForSaving(newEnrichedArtifact, artifact, true);
        }
        catch (JsonSyntaxException e) {
            throw new MigrationPathException("The following migration returned an invalid artifact value" + resp.migratedArtifact, migration.id, e);
        }
        this.updateAffectedArtifacts(null, Lists.newArrayList((Object[])new String[]{enrichedArtifactToMigrate.artifact.id}), enrichedArtifactToMigrate.artifact.id);
        return artifact;
    }

    @Override
    public AutoGovernanceScriptOutput applyScriptForAutoGovernance(EnrichedArtifact dkuEnrichedArtifact, String script) throws IOException {
        AutoGovernanceScriptOutput autoGovernanceScriptOutput;
        AutoGovernanceScriptResponse resp = this.applyAutoGovernanceScript(script, dkuEnrichedArtifact);
        if (resp.status == PythonExecutionStatus.ERROR) {
            throw new AutoGovernanceScriptException(resp.message, dkuEnrichedArtifact);
        }
        if (resp.scriptOutput == null) {
            throw new AutoGovernanceScriptException("The script did not return an autogovernance configuration to use", dkuEnrichedArtifact);
        }
        try {
            JsonObject jsonObject = (JsonObject)JSON.parse((String)resp.scriptOutput, JsonObject.class);
            if (jsonObject.has("childrenConfiguration")) {
                JsonObject childrenConfig = jsonObject.getAsJsonObject("childrenConfiguration");
                if (SystemProvidedConstants.DATAIKU_PROJECT.blueprintId.equals(dkuEnrichedArtifact.blueprint.id)) {
                    childrenConfig.addProperty("type", "project");
                } else if (SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId.equals(dkuEnrichedArtifact.blueprint.id)) {
                    childrenConfig.addProperty("type", "model");
                } else {
                    throw new ValidationException(String.format("artifact of `%s` and blueprint id `%s` cannot have a children configuration", dkuEnrichedArtifact.artifact.id, dkuEnrichedArtifact.blueprint.id));
                }
            }
            autoGovernanceScriptOutput = (AutoGovernanceScriptOutput)JSON.parse((String)jsonObject.toString(), AutoGovernanceScriptOutput.class);
        }
        catch (JsonSyntaxException e) {
            throw new AutoGovernanceScriptException("The autogovernance script returned an invalid configuration value: " + resp.scriptOutput, dkuEnrichedArtifact, e);
        }
        logger.debugV("Result of script governance on artifacts `%s` is `%s`", new Object[]{dkuEnrichedArtifact.artifact.id, autoGovernanceScriptOutput});
        return autoGovernanceScriptOutput;
    }

    private void updateAffectedArtifacts(@Nullable String artifactIdToIgnore, List<String> artifactIdsToUpdate, String contextualArtifactId) {
        TransactionUtils.executeAfterCommitWithinNewTransaction(this.transactionManager, () -> {
            NeverForgettingQueue<String> toUpdate = new NeverForgettingQueue<String>();
            try {
                String artifactId;
                if (StringUtils.isNotBlank((CharSequence)artifactIdToIgnore)) {
                    toUpdate.add(artifactIdToIgnore);
                    toUpdate.poll();
                }
                toUpdate.addAll(artifactIdsToUpdate);
                while ((artifactId = (String)toUpdate.poll()) != null) {
                    try {
                        EnrichedArtifact affectedArtifact = this.artifactsDataService.getArtifact(artifactId);
                        HooksExecutionResult affectedArtifactHooksExecutionResult = this.applyLogicalHooksForUpdate(affectedArtifact, affectedArtifact);
                        this.artifactsDataService.storeArtifact(affectedArtifactHooksExecutionResult.newEnrichedArtifact, false);
                        toUpdate.addAll(affectedArtifactHooksExecutionResult.artifactIdsToUpdate);
                    }
                    catch (NotFoundException e) {
                        logger.info((Object)("Artifact " + artifactId + " was not found while trying to apply hooks for artifact " + artifactIdToIgnore + ".This can happen if " + artifactId + " was deleted while those hooks were being applied."));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Your action has been successfully executed, however there was a problem while running dependent hooks. It is possible that some dependent items were not correctly updated. Reload the page to have the latest changes. If the problem persists, please write down the artifact id (" + contextualArtifactId + ")  and contact your administrator.", e);
            }
        });
    }

    private void updateAffectedArtifacts(HooksExecutionResult hooksExecutionResult, String contextualArtifactId) {
        this.updateAffectedArtifacts(hooksExecutionResult.newEnrichedArtifact != null ? hooksExecutionResult.newEnrichedArtifact.artifact.id : null, hooksExecutionResult.artifactIdsToUpdate, contextualArtifactId);
    }

    private List<LogicalHook> getHookList(BlueprintVersion blueprintVersion, HookPhase hookPhase) {
        return blueprintVersion.logicalHookList.stream().filter(hook -> hook.phases.contains((Object)hookPhase)).collect(Collectors.toList());
    }
}

