/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.dao.UserSession;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.NativeCache;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.SessionsDAO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class FileBasedSessionsDAO
implements SessionsDAO {
    private static final RelFile dataFile = new RelFile(RelFile.global((String)"run"), new String[]{"user-sessions.json"});
    private final NativeCache.CachedReadWriteFS cache = NativeCache.build((File)ApplicationConfigurator.getBaseFolderF());
    private static Logger logger = Logger.getLogger((String)"dku.sessions.files");

    public FileBasedSessionsDAO() throws IOException {
        this.cache.registerMetrics("dku.sessions.files.cache", DSSMetrics.registry());
    }

    @Override
    public synchronized void addSession(String userLogin, UserSession ut) throws IOException {
        SessionsFile f = this.readSessionsFile();
        ut.user = userLogin;
        f.tokens.add(ut);
        this.cache.writeObject(dataFile, (Object)f);
    }

    @Override
    public synchronized void removeExistingSessionsForUser(String user) throws IOException {
        if (this.cache.isFile(dataFile)) {
            SessionsFile f = (SessionsFile)this.cache.readObjectUnsafe(dataFile, SessionsFile.class);
            ListIterator<UserSession> utit = f.tokens.listIterator();
            while (utit.hasNext()) {
                UserSession userSession = utit.next();
                if (user == null || !user.equals(userSession.user)) continue;
                utit.remove();
            }
            this.cache.writeObject(dataFile, (Object)f);
        }
    }

    @Override
    public synchronized void removeSession(String accessToken) throws IOException {
        if (this.cache.isFile(dataFile)) {
            SessionsFile f = (SessionsFile)this.cache.readObjectUnsafe(dataFile, SessionsFile.class);
            ListIterator<UserSession> utit = f.tokens.listIterator();
            while (utit.hasNext()) {
                if (!utit.next().accessToken.equals(accessToken)) continue;
                utit.remove();
            }
            this.cache.writeObject(dataFile, (Object)f);
        }
    }

    @Override
    public synchronized UserSession getUserLoginWithSession(String accessToken) throws IOException {
        if (this.cache.isFile(dataFile)) {
            SessionsFile f = this.readSessionsFile();
            this.cleanupExpired(f);
            for (UserSession ut : f.tokens) {
                if (!ut.accessToken.equals(accessToken)) continue;
                return ut;
            }
        }
        return null;
    }

    @Override
    public synchronized UserSession getUserLoginWithIdentity(String identityToken) throws IOException {
        if (this.cache.isFile(dataFile)) {
            SessionsFile f = this.readSessionsFile();
            this.cleanupExpired(f);
            for (UserSession ut : f.tokens) {
                if (!ut.identityToken.equals(identityToken)) continue;
                return ut;
            }
        }
        return null;
    }

    private SessionsFile readSessionsFile() throws IOException {
        if (this.cache.isFile(dataFile)) {
            try {
                SessionsFile f = (SessionsFile)this.cache.readObjectUnsafe(dataFile, SessionsFile.class);
                if (f != null) {
                    return f;
                }
                logger.warn((Object)"Found empty user-sessions.json file, will recreate");
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to read user-sessions.json file, will recreate", (Throwable)e);
            }
        }
        return new SessionsFile();
    }

    private synchronized void cleanupExpired(SessionsFile f) throws IOException {
        int nbBefore = f.tokens.size();
        long now = System.currentTimeMillis();
        ListIterator<UserSession> utit = f.tokens.listIterator();
        while (utit.hasNext()) {
            UserSession ut = utit.next();
            if (ut.forcedExpire <= 0L || ut.forcedExpire >= now) continue;
            logger.info((Object)("Expiring user session for " + ut.user + " (forced by token)"));
            utit.remove();
        }
        int nbAfter = f.tokens.size();
        if (nbAfter < nbBefore) {
            this.cache.writeObject(dataFile, (Object)f);
        }
    }

    public static class SessionsFile {
        public List<UserSession> tokens = new ArrayList<UserSession>();
    }
}

