/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.dao;

import com.dataiku.dip.dao.UserSession;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.SessionsDAO;
import com.dataiku.gh.server.services.PubSubService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class InMemorySessionsDAO
implements SessionsDAO {
    public static final String EXPIRING_USER_SESSION_FOR = "Expiring user session for ";
    @Autowired
    private PubSubService pubSub;
    private final Map<String, UserSession> sessions = new HashMap<String, UserSession>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sessions.memory");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSession(String userLogin, UserSession ut) throws IOException {
        GeneralSettingsDAO.GeneralSettings gs = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN();
        InMemorySessionsDAO inMemorySessionsDAO = this;
        synchronized (inMemorySessionsDAO) {
            if (gs.security.forceSingleSessionPerUser) {
                this.removeExistingSessionsForUser(userLogin);
            }
            ut.user = userLogin;
            this.sessions.put(ut.accessToken, ut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSession(String accessToken) throws IOException {
        InMemorySessionsDAO inMemorySessionsDAO = this;
        synchronized (inMemorySessionsDAO) {
            this.sessions.remove(accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSession getUserLoginWithSession(String accessToken) throws IOException {
        this.cleanupExpired();
        InMemorySessionsDAO inMemorySessionsDAO = this;
        synchronized (inMemorySessionsDAO) {
            UserSession us = this.sessions.get(accessToken);
            if (us != null) {
                us.refreshed = System.currentTimeMillis();
            }
            return us;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSession getUserLoginWithIdentity(String identityToken) throws IOException {
        InMemorySessionsDAO inMemorySessionsDAO = this;
        synchronized (inMemorySessionsDAO) {
            for (UserSession ut : this.sessions.values()) {
                if (!ut.identityToken.contentEquals(identityToken)) continue;
                return ut;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExistingSessionsForUser(String user) {
        InMemorySessionsDAO inMemorySessionsDAO = this;
        synchronized (inMemorySessionsDAO) {
            Iterator<Map.Entry<String, UserSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, UserSession> e = it.next();
                UserSession ut = e.getValue();
                if (user == null || !user.equals(ut.user)) continue;
                logger.info((Object)("Removing existing session for " + ut.user + " (" + String.valueOf((Object)ExpirationType.FORCE_SINGLE_SESSION) + ")"));
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupExpired() {
        try {
            GeneralSettingsDAO.GeneralSettings gs = ((GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class)).getUnsafeAutoTXN();
            InMemorySessionsDAO inMemorySessionsDAO = this;
            synchronized (inMemorySessionsDAO) {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<String, UserSession>> it = this.sessions.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, UserSession> e = it.next();
                    UserSession ut = e.getValue();
                    if (gs.security.sessionsMaxTotalTimeMinutes > 0 && ut.granted + (long)gs.security.sessionsMaxTotalTimeMinutes * 60L * 1000L < now) {
                        logger.info((Object)(EXPIRING_USER_SESSION_FOR + ut.user + " (" + String.valueOf((Object)ExpirationType.GRANT_EXPIRED) + ")"));
                        it.remove();
                    } else if (gs.security.sessionsMaxIdleTimeMinutes > 0 && ut.refreshed + (long)gs.security.sessionsMaxIdleTimeMinutes * 60L * 1000L < now) {
                        logger.info((Object)(EXPIRING_USER_SESSION_FOR + ut.user + " (" + String.valueOf((Object)ExpirationType.REFRESH_EXPIRED) + ")"));
                        it.remove();
                    }
                    if (ut.forcedExpire <= 0L || ut.forcedExpire >= now) continue;
                    logger.info((Object)(EXPIRING_USER_SESSION_FOR + ut.user + " (" + String.valueOf((Object)ExpirationType.FORCED_BY_TOKEN) + ")"));
                    it.remove();
                }
            }
        }
        catch (IOException e1) {
            logger.warn((Object)"Failed to expire user sessions", (Throwable)e1);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExpirationType {
        FORCED_BY_TOKEN{

            public String toString() {
                return "forced by token";
            }
        }
        ,
        REFRESH_EXPIRED{

            public String toString() {
                return "refresh expired";
            }
        }
        ,
        GRANT_EXPIRED{

            public String toString() {
                return "grant expired";
            }
        }
        ,
        FORCE_SINGLE_SESSION{

            public String toString() {
                return "force single session";
            }
        };

    }
}

