/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class PurchaseReservedInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedInstancesOfferingRequest>, PurchaseReservedInstancesOfferingRequest> {
    @Override
    public Request<PurchaseReservedInstancesOfferingRequest> marshall(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        ReservedInstanceLimitPrice limitPrice;
        if (purchaseReservedInstancesOfferingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseReservedInstancesOfferingRequest> request = new DefaultRequest<PurchaseReservedInstancesOfferingRequest>(purchaseReservedInstancesOfferingRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseReservedInstancesOffering");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedInstancesOfferingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(purchaseReservedInstancesOfferingRequest.getInstanceCount()));
        }
        if (purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId() != null) {
            request.addParameter("ReservedInstancesOfferingId", StringUtils.fromString(purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId()));
        }
        if ((limitPrice = purchaseReservedInstancesOfferingRequest.getLimitPrice()) != null) {
            if (limitPrice.getAmount() != null) {
                request.addParameter("LimitPrice.Amount", StringUtils.fromDouble(limitPrice.getAmount()));
            }
            if (limitPrice.getCurrencyCode() != null) {
                request.addParameter("LimitPrice.CurrencyCode", StringUtils.fromString(limitPrice.getCurrencyCode()));
            }
        }
        if (purchaseReservedInstancesOfferingRequest.getPurchaseTime() != null) {
            request.addParameter("PurchaseTime", StringUtils.fromDate(purchaseReservedInstancesOfferingRequest.getPurchaseTime()));
        }
        return request;
    }
}

