/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.controllers;

import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.auth.AuthVerificationService;
import com.dataiku.lambda.server.LambdaAPIControllerBase;
import com.dataiku.lambda.services.LambdaOpenAPIService;
import com.dataiku.lambda.services.ServicesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class OpenAPIController
extends LambdaAPIControllerBase {
    @Autowired
    private ServicesService serviceService;
    @Autowired
    private AuthVerificationService authService;
    @Autowired
    private LambdaOpenAPIService lambdaOpenAPIService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.openapi.controller");

    @RequestMapping(value={"/public/api/v1/{serviceId}/swagger"}, method={RequestMethod.GET}, produces={"application/json"})
    public void serveSwagger(HttpServletRequest req, HttpServletResponse resp, @PathVariable String serviceId) throws Exception {
        try (ErrorContext.ACNDC c1 = ErrorContext.pushWithNDC((String)("svc:" + serviceId));){
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Got swagger file request for service " + serviceId));
            }
            this.authService.checkAuth(serviceId, this.serviceService.getServiceManagerCheck(serviceId).getConfig(), req);
            File openAPIDocFile = this.lambdaOpenAPIService.getOpenAPIDocFileOrNull_Check(serviceId);
            if (openAPIDocFile == null) {
                OpenAPIController.send404((String)"Documentation file not found", (HttpServletResponse)resp);
                return;
            }
            FileInputStream inputStream = new FileInputStream(openAPIDocFile);
            this.writeStream(resp, inputStream, MimeTypeUtils.fromExtension((String)"json").mimeType, openAPIDocFile.getName());
        }
    }
}

