/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;

public class PairwiseFeatureTextExtractor
implements ModelExtractor<String> {
    private final String jsonPath;
    private final JsonPath compiled;

    public PairwiseFeatureTextExtractor(String jsonPath) {
        this.jsonPath = jsonPath;
        this.compiled = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]);
    }

    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        try {
            String pairwiseFeatureName = (String)documentContext.read(this.compiled);
            if (pairwiseFeatureName != null) {
                for (PairwiseFeatureType pairwiseFeatureType : PairwiseFeatureType.values()) {
                    if (!pairwiseFeatureType.name().equals(pairwiseFeatureName)) continue;
                    return pairwiseFeatureType.getUserFriendlyName();
                }
                return pairwiseFeatureName;
            }
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
        catch (PathNotFoundException e) {
            throw new IOException("Cannot extract the JsonPath \"" + this.jsonPath + "\".");
        }
    }

    private static enum PairwiseFeatureType {
        DISABLED("Disabled"),
        ENABLED_MANUAL("Enabled"),
        ENABLED_AUTOMATIC("Enabled (automatic)");

        private String userFriendlyName;

        private PairwiseFeatureType(String userFriendlyName) {
            this.userFriendlyName = userFriendlyName;
        }

        String getUserFriendlyName() {
            return this.userFriendlyName;
        }
    }
}

