/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.extract;

import com.dataiku.dip.analysis.ml.prediction.split.ForcedSplitGenerator;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.prediction.split.SplitUtils;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.ProcessorOutputToSIP;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.input.utils.CountingProcessorOutput;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.ShakerStreamService;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;

public class ForcedSampleExtractor
implements ForcedSplitGenerator {
    @Autowired
    private ShakerStreamService shakerStreamService;
    private final AuthCtx authCtx;
    private Dataset dataset;
    private ClusteringMLTask.ClusterSampling params;
    private File targetFolder;
    private SerializedShakerScript script;
    private Schema preparationOutputSchema;

    public ForcedSampleExtractor(AuthCtx authCtx, Dataset dataset, ClusteringMLTask.ClusterSampling params, SerializedShakerScript script, Schema preparationOutputSchema, File targetFolder) {
        SpringUtils.getInstance().autowire((Object)this);
        this.authCtx = authCtx;
        this.preparationOutputSchema = preparationOutputSchema;
        this.dataset = dataset;
        this.params = params;
        this.script = script;
        this.targetFolder = targetFolder;
    }

    @Override
    public SplitDesc compute() throws Exception {
        SplitDesc newDesc = new SplitDesc();
        newDesc.format = "csv1";
        newDesc.generationDate = System.currentTimeMillis();
        newDesc.cparams = this.params;
        newDesc.schema = this.preparationOutputSchema;
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        File fullPath = SplitUtils.getSavedModelFullSetFile(this.targetFolder);
        CountingProcessorOutput fullWriter = SplitUtils.getWriterToSingleFile(fullPath, newDesc.schema, (ColumnFactory)cf);
        ProcessorOutputToSIP fullPipeline = this.shakerStreamService.getProcessorOutput(this.authCtx, this.dataset.getProjectKey(), this.script, (ProcessorOutput)fullWriter, (ColumnFactory)cf, (RowFactory)rf);
        UniversalSingleThreadPusher ustp = new UniversalSingleThreadPusher(this.authCtx, this.dataset, (ProcessorOutput)fullPipeline, (ColumnFactory)cf, (RowFactory)rf);
        ustp.setDatasetSelection(this.params.selection);
        ustp.push();
        fullWriter.lastRowEmitted();
        newDesc.fullPath = fullPath.getName();
        newDesc.fullRows = fullWriter.getCount();
        return newDesc;
    }
}

