/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.clustering.flow;

import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPaths;
import com.dataiku.dip.analysis.ml.SMMgmtService;
import com.dataiku.dip.analysis.ml.SMStatus;
import com.dataiku.dip.analysis.ml.SMVersionHeader;
import com.dataiku.dip.analysis.ml.clustering.ClusteringResultsReader;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.ResultsReaderBase;
import com.dataiku.dip.analysis.model.ClusteringModelingParams;
import com.dataiku.dip.analysis.model.clustering.ClusteringMLTask;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelDetails;
import com.dataiku.dip.analysis.model.clustering.ClusteringModelSnippetData;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClusteringSMMgmtService
extends SMMgmtService {
    @Autowired
    private SavedModelsCRUDService crudService;
    private static Logger logger = Logger.getLogger((String)"dku.ml.savedmodels");

    public ClusteringSMStatus getStatus_NT(SavedModel sm) {
        TransactionContext.assertNoAttachedTransaction();
        ClusteringSMStatus ret = new ClusteringSMStatus();
        ret.activeVersionId = sm.activeVersion;
        ret.task = (ClusteringMLTask)sm.miniTask;
        for (FullModelId fmi : this.listUsableVersions(sm)) {
            try {
                ClusteringSMVersionHeader vh = new ClusteringSMVersionHeader();
                vh.versionId = fmi.getSavedModelVersionID();
                vh.active = vh.versionId.equals(ret.activeVersionId);
                vh.snippet = ClusteringResultsReader.makeSnippet(fmi);
                ((ClusteringModelSnippetData)vh.snippet).sessionDate = ((ClusteringModelSnippetData)vh.snippet).trainInfo == null ? 0L : ((ClusteringModelSnippetData)vh.snippet).trainInfo.endTime;
                ret.versions.add(vh);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to create model snippet", (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public List<FullModelId> listUsableVersions(SavedModel sm) {
        return ClusteringSMMgmtService.listVersionFolders(sm).stream().map(f -> new FullModelId(sm.projectKey, sm.getId(), f.getName())).filter(FullModelId::isModelUsable).collect(Collectors.toList());
    }

    public void deleteVersion(SavedModel sm, String version) throws IOException {
        if (org.apache.commons.lang.StringUtils.equals((String)sm.activeVersion, (String)version)) {
            throw new IllegalArgumentException("Cannot delete a model's active version");
        }
        File versionFolder = MLPaths.savedModelVersionFolder(sm, version);
        if (!versionFolder.isDirectory()) {
            throw new IllegalArgumentException("Can't find model version: " + version);
        }
        DKUFileUtils.forceDelete((File)versionFolder);
    }

    public void createFromMLTask(AuthCtx authCtx, FullModelId fmi, SavedModel targetSM) throws Exception {
        String versionId;
        File targetSMFolder = MLPaths.savedModelBaseFolder(targetSM.projectKey, targetSM.id);
        DKUFileUtils.mkdirs((File)targetSMFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(targetSMFolder);
        FilesystemACLUtils.grantFSReadACLs(authCtx, targetSM.projectKey, targetSMFolder);
        targetSM.activeVersion = versionId = "initial";
        this.copyFromMLTask(fmi, targetSM, versionId);
        this.crudService.addDeployedSavedModelVersionSuffixAndUpdateLabel(targetSM, versionId);
    }

    public String updateFromMLTask(FullModelId fmi, SavedModel targetSM) throws Exception {
        String newVersionId = "" + System.currentTimeMillis();
        this.copyFromMLTask(fmi, targetSM, newVersionId);
        return newVersionId;
    }

    protected void copyFromMLTask(FullModelId fmi, SavedModel targetSM, String versionId) throws Exception {
        File targetFolder = MLPaths.savedModelVersionFolder(targetSM, versionId);
        assert (!targetFolder.isDirectory());
        DKUFileUtils.mkdirs((File)targetFolder);
        ClusteringModelDetails details = ClusteringResultsReader.makeDetails(fmi);
        ClusteringMLTask cmlTask = new ClusteringMLTask();
        cmlTask.modeling = new ClusteringModelingParams();
        cmlTask.modeling.metrics = details.modeling.metrics;
        ClusteringMLTask trainTask = fmi.parseSessionFile("mltask.json", ClusteringMLTask.class);
        cmlTask.backendType = trainTask.backendType;
        cmlTask.sparkParams.sparkConf = trainTask.sparkParams.sparkConf;
        cmlTask.sparkParams.sparkExecutionEngine = trainTask.sparkParams.sparkExecutionEngine;
        cmlTask.sparkParams.sparkUseGlobalMetastore = trainTask.sparkParams.sparkUseGlobalMetastore;
        cmlTask.envSelection = trainTask.envSelection;
        cmlTask.guessPolicy = trainTask.guessPolicy;
        cmlTask.sparkParams.sparkPreparedDFStorageLevel = trainTask.sparkParams.sparkPreparedDFStorageLevel;
        targetSM.miniTask = cmlTask;
        try {
            SplitDesc.SplitRef sr = (SplitDesc.SplitRef)JSON.parseFile((File)fmi.getSessionFile("split_ref.json"), SplitDesc.SplitRef.class);
            File srcSplitFolder = fmi.getTaskLoc().getSplitsFolder();
            SplitDesc sd = (SplitDesc)JSON.parseFile((File)DKUFileUtils.getWithinFollowLink((File)srcSplitFolder, (String[])new String[]{sr.splitInstanceId + ".json"}), SplitDesc.class);
            DKUFileUtils.mkdirs((File)DKUFileUtils.getWithinFollowLink((File)targetFolder, (String[])new String[]{"split"}));
            if (sd.fullPath != null) {
                String fullPathExtension = PathUtils.getSmartExtension((String)sd.fullPath);
                String fullPathFileName = "full." + fullPathExtension;
                FileUtils.copyFile((File)DKUFileUtils.getWithinFollowLink((File)srcSplitFolder, (String[])new String[]{sd.fullPath}), (File)DKUFileUtils.getWithinFollowLink((File)targetFolder, (String[])new String[]{"split/" + fullPathFileName}));
                sd.fullPath = fullPathFileName;
            }
            JSON.prettyToFile((Object)sd, (File)DKUFileUtils.getWithinFollowLink((File)targetFolder, (String[])new String[]{"split/split.json"}));
        }
        catch (FileNotFoundException e) {
            logger.info((Object)"Failed to copy split", (Throwable)e);
        }
        FileUtils.copyFileToDirectory((File)fmi.getSessionFile("script.json"), (File)targetFolder);
        FileUtils.copyFileToDirectory((File)fmi.getSessionFile("core_params.json"), (File)targetFolder);
        File eScriptFile = fmi.getSessionFile("escript.json");
        if (eScriptFile.isFile()) {
            FileUtils.copyFileToDirectory((File)eScriptFile, (File)targetFolder);
        }
        for (File f : fmi.getPreprocessingFolder().listFiles()) {
            if (!DKUFileUtils.isFile((File)f) || !StringUtils.endsWithAny((String)f.getName(), (String[])new String[]{".json", ".pkl", ".pkl.gz", ".csv", ".dss", ".log"})) continue;
            FileUtils.copyFileToDirectory((File)f, (File)targetFolder);
        }
        for (File f : fmi.getModelFolder().listFiles()) {
            if (!DKUFileUtils.isFile((File)f) || !StringUtils.endsWithAny((String)f.getName(), (String[])new String[]{".json", ".pkl", ".csv", ".dss", ".zip"})) continue;
            FileUtils.copyFileToDirectory((File)f, (File)targetFolder);
        }
        fmi.saveSmOriginFromAnalysis(targetFolder);
        targetSM.lastExportedFrom = fmi.toString();
    }

    public boolean setActive(SavedModel sm, String versionId) throws Exception {
        boolean changed;
        boolean bl = changed = !org.apache.commons.lang.StringUtils.equals((String)sm.activeVersion, (String)versionId);
        if (changed) {
            FullModelId newFMI = new FullModelId(sm.projectKey, sm.id, versionId);
            if (!newFMI.isModelUsable()) {
                throw ErrorContext.iaef((String)"The new active version to set (%s) is not valid", (Object)versionId, (Object[])new Object[0]);
            }
            String originalVersion = sm.activeVersion;
            sm.activeVersion = versionId;
            this.crudService.save(sm, false, false);
            if (originalVersion == null) {
                return true;
            }
            FullModelId oldFMI = new FullModelId(sm.projectKey, sm.id, originalVersion);
            SplitDesc old = ResultsReaderBase.readSplitDesc(oldFMI);
            SplitDesc nu = ResultsReaderBase.readSplitDesc(newFMI);
            return old == null || !SchemaComparator.findIncompatibilities(old.schema, nu.schema, true).isEmpty();
        }
        return false;
    }

    @UIModel
    public static class ClusteringSMStatus
    extends SMStatus<ClusteringSMVersionHeader> {
        public ClusteringMLTask task;
    }

    public static class ClusteringSMVersionHeader
    extends SMVersionHeader<ClusteringModelSnippetData> {
    }
}

