/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.llm;

import com.dataiku.dip.analysis.ml.llm.LLMSavedModelVersionDeployment;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLHttpClient;
import com.dataiku.dip.llm.online.bedrock.RawBedrockClient;
import java.util.Optional;

public class LLMSavedModelVersionDeploymentWithStatus
extends LLMSavedModelVersionDeployment {
    public final DeploymentStatus status;
    public final AzureMLHttpClient.AzureDeployment rawAzureDeployment;
    public final RawBedrockClient.BedrockProvisionedThroughput bedrockProvisionedThroughput;

    public LLMSavedModelVersionDeploymentWithStatus(String deploymentId, String versionId, LLMSavedModelVersionDeployment.DeploymentType deploymentType, DeploymentStatus status, LLMSavedModelVersionDeployment.CreationMethod creationMethod, long createdOn, String createdBy, AzureMLHttpClient.AzureDeployment rawAzureDeployment) {
        super(deploymentId, versionId, deploymentType, creationMethod, createdOn, createdBy);
        this.bedrockProvisionedThroughput = null;
        this.rawAzureDeployment = rawAzureDeployment;
        this.status = status;
    }

    public LLMSavedModelVersionDeploymentWithStatus(String deploymentId, String versionId, LLMSavedModelVersionDeployment.DeploymentType deploymentType, DeploymentStatus status, LLMSavedModelVersionDeployment.CreationMethod creationMethod, long createdOn, String createdBy, RawBedrockClient.BedrockProvisionedThroughput bedrockProvisionedThroughput) {
        super(deploymentId, versionId, deploymentType, creationMethod, createdOn, createdBy);
        this.rawAzureDeployment = null;
        this.bedrockProvisionedThroughput = bedrockProvisionedThroughput;
        this.status = status;
    }

    public static LLMSavedModelVersionDeploymentWithStatus fromDeployment(LLMSavedModelVersionDeployment deployment, Optional<AzureMLHttpClient.AzureDeployment> azureDeployment, DeploymentStatus missingDeploymentStatus) {
        return new LLMSavedModelVersionDeploymentWithStatus(deployment.deploymentId, deployment.versionId, deployment.deploymentType, LLMSavedModelVersionDeploymentWithStatus.getDeploymentStatusFromAzureDeployment(azureDeployment, missingDeploymentStatus), deployment.creationMethod, deployment.createdOn, deployment.createdBy, azureDeployment.isPresent() ? azureDeployment.get() : null);
    }

    public static LLMSavedModelVersionDeploymentWithStatus fromBedrockDeployment(LLMSavedModelVersionDeployment deployment, Optional<RawBedrockClient.BedrockProvisionedThroughput> bedrockProvisionedThroughput, DeploymentStatus missingDeploymentStatus) {
        return new LLMSavedModelVersionDeploymentWithStatus(deployment.deploymentId, deployment.versionId, deployment.deploymentType, LLMSavedModelVersionDeploymentWithStatus.getDeploymentStatusFromBedrockProvisionedThroughput(bedrockProvisionedThroughput, missingDeploymentStatus), deployment.creationMethod, deployment.createdOn, deployment.createdBy, bedrockProvisionedThroughput.isPresent() ? bedrockProvisionedThroughput.get() : null);
    }

    private static DeploymentStatus getDeploymentStatusFromBedrockProvisionedThroughput(Optional<RawBedrockClient.BedrockProvisionedThroughput> bedrockProvisionedThroughput, DeploymentStatus missingDeploymentStatus) {
        if (bedrockProvisionedThroughput.isPresent()) {
            switch (bedrockProvisionedThroughput.get().status) {
                case "Updating": 
                case "Creating": {
                    return DeploymentStatus.CREATING;
                }
                case "InService": {
                    return DeploymentStatus.AVAILABLE;
                }
            }
            return DeploymentStatus.IN_ERROR;
        }
        return missingDeploymentStatus;
    }

    private static DeploymentStatus getDeploymentStatusFromAzureDeployment(Optional<AzureMLHttpClient.AzureDeployment> deployment, DeploymentStatus missingDeploymentStatus) {
        if (deployment.isPresent()) {
            switch (deployment.get().properties.provisioningState) {
                case "Succeeded": {
                    return DeploymentStatus.AVAILABLE;
                }
                case "Creating": {
                    return DeploymentStatus.CREATING;
                }
            }
            return DeploymentStatus.IN_ERROR;
        }
        return missingDeploymentStatus;
    }

    public static enum DeploymentStatus {
        NOT_FOUND,
        CREATING,
        AVAILABLE,
        IN_ERROR;

    }
}

