/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.deployments;

import com.dataiku.dip.apideployer.datamodel.actual.MultiNodeProjectDeploymentHeavyStatus;
import com.dataiku.dip.apideployer.datamodel.config.MultiAutomationNodeInfra;
import com.dataiku.dip.apideployer.datamodel.config.MultiNodeProjectDeployment;
import com.dataiku.dip.apideployer.deployments.AbstractProjectDeploymentManager;
import com.dataiku.dip.apideployer.engine.DeploymentHooksRunner;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.directory.NodeConnection;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.nodeclients.AutomationNodeClient;
import com.dataiku.dip.projects.importexport.AbstractBundleService;
import com.dataiku.dip.projects.importexport.BundleActivator;
import com.dataiku.dip.projects.importexport.BundlePreloader;
import com.dataiku.dip.projects.importexport.model.BundleActivationTestResult;
import com.dataiku.dip.scheduler.scenarios.TestingStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiNodeProjectDeploymentManager
extends AbstractProjectDeploymentManager<MultiNodePreparePreloadAndActivateReport> {
    public static final String AUTOMATION_NODE_ID_PREFIX = "[Automation node %s]: ";
    private final MultiNodeProjectDeployment deployment;
    private final MultiAutomationNodeInfra infra;
    private final List<NodeConnection> nodeConnections;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.automation.manager");

    public MultiNodeProjectDeploymentManager(@Nonnull AuthCtx authCtx, MultiNodeProjectDeployment deployment, MultiAutomationNodeInfra infra) {
        super(authCtx, deployment);
        this.deployment = deployment;
        this.infra = infra;
        this.nodeConnections = infra.getConnectionInfos();
    }

    @Override
    @Nonnull
    protected MultiNodePreparePreloadAndActivateReport initializeDeploymentReport() {
        return new MultiNodePreparePreloadAndActivateReport(this.isProjectStandardsFeatureAllowed());
    }

    @Override
    @Nonnull
    protected List<AbstractProjectDeploymentManager.ScenarioRunsByNode> retrieveScenarioRunsWithinDateRange_NT(String fromDate, String toDate) {
        ArrayList<AbstractProjectDeploymentManager.ScenarioRunsByNode> scenarioRunsByNode = new ArrayList<AbstractProjectDeploymentManager.ScenarioRunsByNode>();
        for (NodeConnection nodeConnection : this.nodeConnections) {
            if (!nodeConnection.canOpenClient()) {
                logger.errorV("The automation node %s cannot be reached (%s). Cannot retrieve the scenario runs", new Object[]{nodeConnection.automationNodeId, nodeConnection.nodeDirectoryStatus});
                continue;
            }
            try {
                AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);
                try {
                    scenarioRunsByNode.add(new AbstractProjectDeploymentManager.ScenarioRunsByNode(nodeConnection.automationNodeId, client.getScenarioRunsWithinDateRange(this.targetProjectKey, fromDate, toDate, true)));
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
            catch (Exception e) {
                logger.errorV((Throwable)e, "Unable to retrieve scenario runs from automation node id %s", new Object[]{nodeConnection.automationNodeId});
            }
        }
        return scenarioRunsByNode;
    }

    @Override
    @Nonnull
    protected InfoMessage.InfoMessages synchronisationPreparation() throws CodedException {
        logger.info((Object)("Prepare sync on infra " + this.infra.id + " of " + JSON.json((Object)this.deployment)));
        String CODE = "prepare";
        logger.info((Object)("Performing prepare for deployment " + this.deployment.id));
        MultiNodesSynchronisationPreparationReport report = new MultiNodesSynchronisationPreparationReport();
        for (NodeConnection nodeConnection : this.nodeConnections) {
            logger.infoV("Start prepare sync on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            InfoMessage.InfoMessages nodeReport = this.prepareSyncOnAutomationNode(nodeConnection);
            nodeReport.prefixMessageTitles(String.format(AUTOMATION_NODE_ID_PREFIX, nodeConnection.automationNodeId));
            logger.infoV("Finished prepare sync on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            nodeReport.summarize();
            if (InfoMessage.Severity.ERROR.equals((Object)nodeReport.maxSeverity)) {
                logger.errorV("Prepare sync failed on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.koNodes;
            } else if (InfoMessage.Severity.WARNING.equals((Object)nodeReport.maxSeverity)) {
                logger.infoV("Prepare sync succeeded with warning on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            } else {
                logger.infoV("Prepare sync succeeded on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            }
            report.mergeFrom(nodeReport);
        }
        logger.infoV("End of prepare sync for deployment %s, succeeded on %d nodes, and failed on %d nodes", new Object[]{this.deployment.id, report.okNodes, report.koNodes});
        if (report.isEmpty()) {
            logger.info((Object)"Report for prepare is empty");
        } else {
            logger.infoV("prepare report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    @Nonnull
    protected MultiNodesBundlePreloadingReport bundlePreloading(DKUtils.SmartLogTailBuilder logTailBuilder) throws InterruptedException {
        logger.infoV("Preload bundle %s on automation node project %s for infra %s", new Object[]{this.deployment.bundleId, this.targetProjectKey, this.infra.id});
        String CODE = "preload";
        logger.info((Object)("Performing preload for deployment " + this.deployment.id));
        MultiNodesBundlePreloadingReport report = new MultiNodesBundlePreloadingReport();
        boolean isPreloadingPartiallySuccessful = false;
        for (NodeConnection nodeConnection : this.nodeConnections) {
            logger.infoV("Start preloading bundle %s on automation node id %s", new Object[]{this.deployment.bundleId, nodeConnection.automationNodeId});
            BundlePreloader.BundlePreloadingReport nodeReport = this.preloadOnAutomationNode(nodeConnection, logTailBuilder);
            nodeReport.prefixMessageTitles(String.format(AUTOMATION_NODE_ID_PREFIX, nodeConnection.automationNodeId));
            logger.infoV("Finished preloading bundle %s on automation node id %s", new Object[]{this.deployment.bundleId, nodeConnection.automationNodeId});
            nodeReport.summarize();
            if (InfoMessage.Severity.ERROR.equals((Object)nodeReport.maxSeverity)) {
                logger.errorV("Bundle preload failed on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.koNodes;
                if (!isPreloadingPartiallySuccessful && this.isProjectPresentOnAutomationNode(nodeConnection)) {
                    isPreloadingPartiallySuccessful = true;
                }
            } else if (InfoMessage.Severity.WARNING.equals((Object)nodeReport.maxSeverity)) {
                logger.infoV("Bundle preload succeeded with warning on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
                isPreloadingPartiallySuccessful = true;
            } else {
                logger.infoV("Bundle preload succeeded on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
                isPreloadingPartiallySuccessful = true;
            }
            report.mergeFrom(nodeReport);
            if (!isPreloadingPartiallySuccessful) continue;
            neverEverDeployed.remove(this.getDeployment().id);
        }
        if (this.nodeConnections.isEmpty()) {
            neverEverDeployed.remove(this.getDeployment().id);
        }
        if (report.isEmpty()) {
            logger.info((Object)"Report for preload is empty");
        } else {
            logger.infoV("preload report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    public TestingStatus getTestingStatus(@Nullable String bundleId, @Nullable String automationNodeId) throws IOException, CodedException {
        if (automationNodeId == null) {
            throw new IllegalArgumentException("You need to specify an automation node id to retrieve the testing status of a multi node deployment.");
        }
        NodeConnection nodeConnection = this.getNodeConnection(automationNodeId);
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);){
            TestingStatus testingStatus = client.getTestingStatus(this.deployment.basicInfoUnsafe().getDeployedItemId(), bundleId);
            return testingStatus;
        }
    }

    @Override
    public TestingStatus runTestScenarios(@Nullable String automationNodeId) throws CodedException, IOException {
        if (automationNodeId == null) {
            throw new IllegalArgumentException("You need to specify an automation node id to run test scenarios on a multi node deployment.");
        }
        NodeConnection nodeConnection = this.getNodeConnection(automationNodeId);
        try (AutomationNodeClient client = this.automationNodeProxyUserClient(nodeConnection);){
            TestingStatus testingStatus = client.runTestScenarios(this.deployment.basicInfoUnsafe().getDeployedItemId());
            return testingStatus;
        }
    }

    @VisibleForTesting
    NodeConnection getNodeConnection(String automationNodeId) {
        return this.nodeConnections.stream().filter(connection -> Objects.equals(connection.automationNodeId, automationNodeId)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("The automation node id %s is not found for infrastructure %s", automationNodeId, this.infra.id)));
    }

    @Override
    @Nonnull
    protected MultiNodesActivationCheckingReport activationChecking_NT() throws InterruptedException {
        logger.infoV("Running activation checks for bundle %s on automation node project %s for infra %s", new Object[]{this.deployment.bundleId, this.targetProjectKey, this.infra.id});
        String CODE = "activate-check";
        logger.info((Object)("Performing + activate-check for deployment " + this.deployment.id));
        MultiNodesActivationCheckingReport report = new MultiNodesActivationCheckingReport();
        for (NodeConnection nodeConnection : this.nodeConnections) {
            logger.infoV("Start activate check on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            BundleActivationTestResult nodeReport = this.activateCheckOnAutomationNode_NT(nodeConnection);
            nodeReport.prefixMessageTitles(String.format(AUTOMATION_NODE_ID_PREFIX, nodeConnection.automationNodeId));
            logger.infoV("Finished activate check on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            nodeReport.summarize();
            if (InfoMessage.Severity.ERROR.equals((Object)nodeReport.maxSeverity)) {
                logger.errorV("Activation check failed on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.koNodes;
            } else if (InfoMessage.Severity.WARNING.equals((Object)nodeReport.maxSeverity)) {
                logger.infoV("Activation check succeeded with warning on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            } else {
                logger.infoV("Activation check succeeded on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            }
            report.mergeFrom(nodeReport);
        }
        if (report.isEmpty()) {
            logger.info((Object)"Report for activate-check is empty");
        } else {
            logger.infoV("activate-check report: %s", new Object[]{report.report("\n")});
        }
        return report;
    }

    @Override
    protected MultiNodeProjectDeployment getDeployment() {
        return this.deployment;
    }

    @Override
    protected MultiAutomationNodeInfra getInfra() {
        return this.infra;
    }

    @Override
    protected MultiNodeProjectDeploymentHeavyStatus createNewHeavyStatus(String deploymentId, String infraId) {
        return new MultiNodeProjectDeploymentHeavyStatus(deploymentId, infraId);
    }

    @Override
    @Nonnull
    protected String getInfraPrettyName() {
        return "multi automation nodes " + this.getInfra().id;
    }

    @Override
    @Nonnull
    protected MultiNodesBundleActivationReport doDeployment(DKUtils.SmartLogTailBuilder logTailBuilder) throws IOException, InterruptedException {
        logger.infoV("Activating bundle %s on automation node project %s for infra %s", new Object[]{this.deployment.bundleId, this.targetProjectKey, this.infra.id});
        MultiNodesBundleActivationReport report = new MultiNodesBundleActivationReport();
        InfoMessage.InfoMessages additionalMessages = new InfoMessage.InfoMessages();
        AbstractBundleService.BundleActivationOptions bundleActivationOptions = this.buildBundleActivationOptions(additionalMessages);
        bundleActivationOptions.updateDelaySec = this.infra.updateDelaySecs;
        bundleActivationOptions.alivePolicyOnUpdate = this.infra.setInstanceAsNotAliveDuringDeploymentUpdate ? AbstractBundleService.AlivePolicyOnUpdate.INSTANCE : AbstractBundleService.AlivePolicyOnUpdate.PROJECT;
        logger.infoV("The deployment alive policy on update is: %s", new Object[]{bundleActivationOptions.alivePolicyOnUpdate});
        report.mergeFrom(additionalMessages);
        for (NodeConnection nodeConnection : this.nodeConnections) {
            logger.infoV("Start activation of bundle on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            logTailBuilder.appendLine(String.format("Start activation of bundle on automation node id %s", nodeConnection.automationNodeId));
            BundleActivator.BundleActivationReport nodeReport = this.doDeploymentOnAutomationNode(nodeConnection, bundleActivationOptions, logTailBuilder);
            nodeReport.prefixMessageTitles(String.format(AUTOMATION_NODE_ID_PREFIX, nodeConnection.automationNodeId));
            logger.infoV("Finished activation of bundle on automation node id %s", new Object[]{nodeConnection.automationNodeId});
            nodeReport.summarize();
            if (InfoMessage.Severity.ERROR.equals((Object)nodeReport.maxSeverity)) {
                logger.errorV("Bundle activation failed on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.koNodes;
            } else if (InfoMessage.Severity.WARNING.equals((Object)nodeReport.maxSeverity)) {
                logger.infoV("Bundle activation succeeded with warning on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            } else {
                logger.infoV("Bundle activation succeeded on automation node id %s", new Object[]{nodeConnection.automationNodeId});
                ++report.okNodes;
            }
            report.mergeFrom(nodeReport);
        }
        if (report.maxSeverity != InfoMessage.Severity.ERROR) {
            logger.debugV("Deployment completed without error on infra %s, updating deploymentTag", new Object[]{this.infra.id});
            this.updateDeploymentTag();
        } else {
            logger.warnV("Deployment completed with error on infra %s, not updating deploymentTag", new Object[]{this.infra.id});
        }
        FutureProgress.incrementState((double)1.0);
        return report;
    }

    @Override
    @Nonnull
    protected DeploymentHooksRunner.DeploymentHookMetadata getDeploymentHookMetadata() {
        return new DeploymentHooksRunner.MultiNodeProjectDeploymentHookMetadata(this.nodeConnections, this.infra.trustAllSSLCertificates, this.deployment, this.infra.getProxyUserForTargetProject(this.authCtx, this.deployment.getTargetProjectKey()));
    }

    public static class MultiNodePreparePreloadAndActivateReport
    extends AbstractProjectDeploymentManager.ProjectDeploymentReport {
        MultiNodesSynchronisationPreparationReport multiNodesSynchronisationPreparationReport;
        MultiNodesBundlePreloadingReport multiNodesBundlePreloadingReport;
        MultiNodesActivationCheckingReport multiNodesActivationCheckingReport;
        MultiNodesBundleActivationReport multiNodesBundleActivationReport;

        private MultiNodePreparePreloadAndActivateReport() {
            super(false);
        }

        public MultiNodePreparePreloadAndActivateReport(boolean projectStandardsAllowed) {
            super(projectStandardsAllowed);
        }

        @Override
        public MultiNodePreparePreloadAndActivateReport copyHookStatusWithSensitiveDataAdded() {
            MultiNodePreparePreloadAndActivateReport copy = this.copyWithNonAdminDeploymentFailureMessage();
            copy.deploymentHookExecutionStatus.updateMessageWithSensitiveData();
            return copy;
        }

        @Override
        public MultiNodePreparePreloadAndActivateReport copyWithNonAdminDeploymentFailureMessage() {
            MultiNodePreparePreloadAndActivateReport copy = new MultiNodePreparePreloadAndActivateReport(this.isProjectStandardsFeatureAllowed());
            copy.mergeFrom(this);
            copy.copyInterruptedAndHookStatus(this);
            copy.projectStandardsCheckReport = (InfoMessage.InfoMessages)JSON.deepCopy((Object)this.projectStandardsCheckReport);
            copy.multiNodesSynchronisationPreparationReport = (MultiNodesSynchronisationPreparationReport)((Object)JSON.deepCopy((Object)((Object)this.multiNodesSynchronisationPreparationReport)));
            copy.multiNodesBundlePreloadingReport = (MultiNodesBundlePreloadingReport)((Object)JSON.deepCopy((Object)((Object)this.multiNodesBundlePreloadingReport)));
            copy.multiNodesActivationCheckingReport = (MultiNodesActivationCheckingReport)((Object)JSON.deepCopy((Object)((Object)this.multiNodesActivationCheckingReport)));
            copy.multiNodesBundleActivationReport = (MultiNodesBundleActivationReport)((Object)JSON.deepCopy((Object)((Object)this.multiNodesBundleActivationReport)));
            return copy;
        }

        @Override
        public void setActualDeploymentStepReport(@Nonnull InfoMessage.InfoMessages report) {
            if (!(report instanceof MultiNodesBundleActivationReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of activate report. Expected a %s, got a %s", MultiNodesBundleActivationReport.class, report.getClass()));
            }
            this.multiNodesBundleActivationReport = (MultiNodesBundleActivationReport)report;
            this.mergeFrom(report);
        }

        @Override
        public MultiNodesSynchronisationPreparationReport getSynchronisationPreparationReport() {
            return this.multiNodesSynchronisationPreparationReport;
        }

        @Override
        public MultiNodesBundlePreloadingReport getBundlePreloadingReport() {
            return this.multiNodesBundlePreloadingReport;
        }

        @Override
        public MultiNodesActivationCheckingReport getActivationCheckingReport() {
            return this.multiNodesActivationCheckingReport;
        }

        @Override
        public MultiNodesBundleActivationReport getBundleActivationReport() {
            return this.multiNodesBundleActivationReport;
        }

        @Override
        public void mergeFromSynchronisationPreparationReport(@Nonnull InfoMessage.InfoMessages report) {
            if (!(report instanceof MultiNodesSynchronisationPreparationReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of prepare report. Expected a %s, got a %s", MultiNodesSynchronisationPreparationReport.class, report.getClass()));
            }
            this.multiNodesSynchronisationPreparationReport = (MultiNodesSynchronisationPreparationReport)report;
            this.mergeFrom(report);
        }

        @Override
        public void mergeFromBundlePreloadingReport(@Nonnull InfoMessage.InfoMessages report) {
            if (!(report instanceof MultiNodesBundlePreloadingReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of preload report. Expected a %s, got a %s", MultiNodesBundlePreloadingReport.class, report.getClass()));
            }
            this.multiNodesBundlePreloadingReport = (MultiNodesBundlePreloadingReport)report;
            this.mergeFrom(report);
        }

        @Override
        public void mergeFromActivationCheckingReport(@Nonnull BundleActivationTestResult report) {
            if (!(report instanceof MultiNodesActivationCheckingReport)) {
                throw new AssertionError((Object)String.format("Unexpected type of activate check report. Expected a %s, got a %s", MultiNodesActivationCheckingReport.class, ((Object)((Object)report)).getClass()));
            }
            this.multiNodesActivationCheckingReport = (MultiNodesActivationCheckingReport)report;
            this.mergeFrom(report);
        }
    }

    public static class MultiNodesSynchronisationPreparationReport
    extends InfoMessage.InfoMessages {
        public int okNodes = 0;
        public int koNodes = 0;
    }

    public static class MultiNodesBundlePreloadingReport
    extends BundlePreloader.BundlePreloadingReport {
        public int okNodes = 0;
        public int koNodes = 0;
    }

    public static class MultiNodesActivationCheckingReport
    extends BundleActivationTestResult {
        public int okNodes = 0;
        public int koNodes = 0;
    }

    public static class MultiNodesBundleActivationReport
    extends BundleActivator.BundleActivationReport {
        public int okNodes = 0;
        public int koNodes = 0;
    }
}

