/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.HDFSConnection;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.security.impersonation.GroupImpersonationRule;
import com.dataiku.dip.security.impersonation.ImpersonationConfig;
import com.dataiku.dip.security.impersonation.UserImpersonationRule;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.Map;
import org.apache.commons.cli.Options;

public class EnableImpersonationCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cli.impersonation");

    @Override
    public String usageString() {
        return "__enable-impersonation";
    }

    @Override
    public String description() {
        return "";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, "__enable-impersonation", true);
        CLISetup.doSpringUtilsAndCoreServicesSetup();
        try (DKUTransactionService ts = new DKUTransactionService();
             RWTransaction rwt = ts.beginWriteAsDSS();){
            GeneralSettingsDAO.GeneralSettings gs = (GeneralSettingsDAO.GeneralSettings)rwt.readObject("general-settings.json", GeneralSettingsDAO.GeneralSettings.class);
            ImpersonationConfig is = gs.impersonation;
            boolean firstTime = !is.enabled;
            logger.info((Object)("Setting-up impersonation, firstTime=" + firstTime));
            assert (is != null);
            is.enabled = true;
            if (is.userRules.isEmpty() && is.groupRules.isEmpty()) {
                is.userRules.add(UserImpersonationRule.newGlobalIdentity());
                is.groupRules.add(GroupImpersonationRule.newGlobalIdentity());
            }
            gs.hiveSettings.engineCreationSettings.executionEngine = HiveRecipeMeta.HiveExecutionEngine.HIVESERVER2;
            if (firstTime) {
                for (SparkExecutionConfig sec : gs.sparkSettings.executionConfigs) {
                    sec.conf.add(new ClusterProperty("spark.yarn.security.tokens.hive.enabled", "false"));
                    sec.conf.add(new ClusterProperty("spark.yarn.security.credentials.hadoopfs.enabled", "false"));
                    sec.conf.add(new ClusterProperty("spark.security.credentials.hive.enabled", "false"));
                    sec.conf.add(new ClusterProperty("spark.security.credentials.hadoopfs.enabled", "false"));
                }
            }
            rwt.writeObject("general-settings.json", (Object)gs);
            if (firstTime) {
                Map<String, DSSConnection> conns = ConnectionsDAO.get().list();
                boolean modified = false;
                for (DSSConnection conn : conns.values()) {
                    HDFSConnection hconn;
                    if (conn.type.equals("HDFS") && conn.allowManagedDatasets) {
                        hconn = (HDFSConnection)conn;
                        hconn.params.namingRule.hdfsPathDatasetNamePrefix = "${projectKey}/";
                        hconn.params.namingRule.hiveDatabaseName = "dataiku_${projectKey}";
                        modified = true;
                        continue;
                    }
                    if (!conn.type.equals("HDFS")) continue;
                    hconn = (HDFSConnection)conn;
                    hconn.params.aclSynchronizationMode = HDFSConnection.ACLSynchronizationMode.NONE;
                    modified = true;
                }
                if (modified) {
                    ConnectionsDAO.get().writeList(conns);
                }
            }
            rwt.commit("CLI: Enabled multi-user-security (from command-line)");
        }
        return 0;
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }
}

