/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;

public class ImpalaOverrideMask {
    public boolean enabled;
    public boolean jdbc;
    public boolean preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes;
    public boolean additionalUserToGrantAccessToWhenImpersonating;
    public boolean engineCreationSettings;

    public static ImpalaOverrideMask fromJsonObject(JsonObject settings) {
        ImpalaOverrideMask mask = new ImpalaOverrideMask();
        if (settings == null) {
            return mask;
        }
        mask.enabled = true;
        if (settings.has("useURL") && !settings.get("useURL").isJsonNull()) {
            mask.jdbc = true;
        }
        if (settings.has("additionalUserToGrantAccessToWhenImpersonating") && !settings.get("additionalUserToGrantAccessToWhenImpersonating").isJsonNull()) {
            mask.additionalUserToGrantAccessToWhenImpersonating = true;
        }
        if (settings.has("engineCreationSettings") && !settings.get("engineCreationSettings").isJsonNull()) {
            mask.engineCreationSettings = true;
        }
        if (settings.has("preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes") && !settings.get("preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes").isJsonNull()) {
            mask.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes = true;
        }
        return mask;
    }

    public ImpalaSettings apply(ImpalaSettings base, ImpalaSettings overrides) {
        ImpalaSettings overriden = (ImpalaSettings)JSON.deepCopy((Object)base);
        if (!this.enabled) {
            return overriden;
        }
        overriden.enabled = overrides.enabled;
        if (this.jdbc) {
            overriden.connectionProperties = overrides.connectionProperties;
            overriden.datanodes = overrides.datanodes;
            overriden.port = overrides.port;
            overriden.principal = overrides.principal;
            overriden.useSimbaDriver = overrides.useSimbaDriver;
            overriden.useURL = overrides.useURL;
            overriden.displayedUrl = overrides.displayedUrl;
            overriden.url = overrides.url;
            overriden.driver = overrides.driver;
            overriden.authBehavior = overrides.authBehavior;
            overriden.password = overrides.password;
            overriden.user = overrides.user;
            overriden.credentialsMode = overrides.credentialsMode;
            overriden.isSelfSigned = overrides.isSelfSigned;
            overriden.trustStorePassword = overrides.trustStorePassword;
            overriden.trustStorePath = overrides.trustStorePath;
            overriden.useSsl = overrides.useSsl;
        }
        if (this.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes) {
            overriden.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes = overrides.preCreateManagedDatasetFolderBeforeMetastoreSyncForDirectWriteRecipes;
        }
        if (this.additionalUserToGrantAccessToWhenImpersonating) {
            overriden.additionalUserToGrantAccessToWhenImpersonating = overrides.additionalUserToGrantAccessToWhenImpersonating;
        }
        if (this.engineCreationSettings) {
            overriden.engineCreationSettings = overrides.engineCreationSettings;
        }
        return overriden;
    }
}

