/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterRegistry;
import com.dataiku.dip.cluster.LoadedPythonPluginCluster;
import com.dataiku.dip.cluster.PythonPluginClusterDesc;
import com.dataiku.dip.cluster.PythonPluginClusterHandler;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.custom.CustomPythonElementService;
import com.dataiku.dip.custom.PluginComponentDescValidator;
import com.dataiku.dip.utils.JSON;
import java.io.File;
import java.io.IOException;
import org.springframework.stereotype.Service;

@Service
public class PythonPluginClustersService
extends CustomPythonElementService<PythonPluginClusterDesc, LoadedPythonPluginCluster> {
    @Override
    public String getFolderName() {
        return "python-clusters";
    }

    @Override
    public String getPrefix() {
        return "cluster";
    }

    @Override
    protected String getCodeExtension(LoadedPythonPluginCluster desc) {
        return ".py";
    }

    @Override
    public Class<PythonPluginClusterDesc> getDescClass() {
        return PythonPluginClusterDesc.class;
    }

    @Override
    public Class<LoadedPythonPluginCluster> getLoadedDescClass() {
        return LoadedPythonPluginCluster.class;
    }

    @Override
    protected void removeElement(LoadedPythonPluginCluster desc) {
        ClusterRegistry.deregister(desc.clusterType);
    }

    @Override
    protected String makeType(String pluginId, String elementId) {
        return "pycluster_" + pluginId + "_" + elementId;
    }

    @Override
    protected LoadedPythonPluginCluster load(String elementType, String pluginId, String elementId, File file) throws IOException {
        LoadedPythonPluginCluster loaded = new LoadedPythonPluginCluster(elementId, pluginId, elementType, (PythonPluginClusterDesc)JSON.parseFile((File)file, PythonPluginClusterDesc.class));
        PythonPluginClusterHandler.PythonPluginClusterMeta clusterMeta = new PythonPluginClusterHandler.PythonPluginClusterMeta(pluginId, loaded, this);
        ClusterRegistry.register(clusterMeta);
        return loaded;
    }

    @Override
    public InfoMessage.InfoMessages validate(String componentId, String pluginId, final PythonPluginClusterDesc desc) {
        return new PluginComponentDescValidator(componentId){

            @Override
            public InfoMessage.InfoMessages validate() {
                if (desc.params != null) {
                    this.genericValidateParams(desc.params, PythonPluginClustersService.this.getPrefix());
                }
                this.genericValidateMeta(desc.meta);
                return this.messages;
            }
        }.validate();
    }
}

