/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.ClusterProperty;
import com.dataiku.dip.cluster.ClusterPropertyList;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.spark.SparkExecutionConfig;
import com.google.common.collect.Lists;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SparkSettings {
    public boolean sparkEnabled;
    public String sparkHome;
    public List<String> additionalSparkSubmitJars = Lists.newArrayList();
    public List<SimpleKeyValue> environmentVariables = Lists.newArrayList();
    public ClusterPropertyList executionConfigsGenericOverrides = new ClusterPropertyList();
    public List<SparkExecutionConfig> executionConfigs = new ArrayList<SparkExecutionConfig>();
    public String configForJupyter = "default";
    public String configForSEK = "default";
    public String configForInteractive = "default";
    public boolean useNativeProcessors = false;
    public GlobalSparkEngineCreationSettings engineCreationSettings = new GlobalSparkEngineCreationSettings();
    public YarnClusterSettings yarnClusterSettings = new YarnClusterSettings();
    public AbstractSparkRecipeParams.SparkExecutionEngine interactiveExecutionEngine = null;

    @Transient
    public SparkExecutionConfig getDefault() {
        if (this.executionConfigs.isEmpty()) {
            throw new IllegalStateException("No spark configuration exist");
        }
        for (SparkExecutionConfig sec : this.executionConfigs) {
            if (!"default".equals(sec.name)) continue;
            return sec;
        }
        return this.executionConfigs.get(0);
    }

    @Transient
    public SparkExecutionConfig getByName(String name) {
        for (SparkExecutionConfig sec : this.executionConfigs) {
            if (!name.equals(sec.name)) continue;
            return sec;
        }
        throw new IllegalArgumentException("Spark Config not found: " + name);
    }

    @Transient
    public SparkExecutionConfig getByNameOrNull(String name, SparkConfigSelectionMode selectionMode) {
        SparkExecutionConfig defaultConfig = null;
        SparkExecutionConfig jupyterConfig = null;
        SparkExecutionConfig sekConfig = null;
        SparkExecutionConfig interactiveConfig = null;
        for (SparkExecutionConfig sec : this.executionConfigs) {
            if (name.equals(sec.name)) {
                return sec;
            }
            if (StringUtils.equals((String)"default", (String)sec.name)) {
                defaultConfig = sec;
            }
            if (StringUtils.equals((String)this.configForJupyter, (String)sec.name)) {
                jupyterConfig = sec;
            }
            if (StringUtils.equals((String)this.configForSEK, (String)sec.name)) {
                sekConfig = sec;
            }
            if (!StringUtils.equals((String)this.configForInteractive, (String)sec.name)) continue;
            interactiveConfig = sec;
        }
        if (selectionMode == SparkConfigSelectionMode.WITH_DEFAULT_IF_EMPTY) {
            return defaultConfig;
        }
        if (selectionMode == SparkConfigSelectionMode.WITH_JUPYTER_IF_EMPTY) {
            return jupyterConfig;
        }
        if (selectionMode == SparkConfigSelectionMode.WITH_SEK_IF_EMPTY) {
            return sekConfig;
        }
        if (selectionMode == SparkConfigSelectionMode.WITH_INTERACTIVE_IF_EMPTY) {
            return interactiveConfig;
        }
        return null;
    }

    @Transient
    public SparkExecutionConfig getByNameOrNull(String name) {
        for (SparkExecutionConfig sec : this.executionConfigs) {
            if (!name.equals(sec.name)) continue;
            return sec;
        }
        return null;
    }

    public SparkSettings() {
    }

    public SparkSettings(SparkSettings sparkSettings) {
        this.sparkEnabled = sparkSettings.sparkEnabled;
        this.sparkHome = sparkSettings.sparkHome;
        this.additionalSparkSubmitJars.addAll(sparkSettings.additionalSparkSubmitJars);
        sparkSettings.environmentVariables.forEach(cfg -> this.environmentVariables.add(new SimpleKeyValue(cfg)));
        this.executionConfigsGenericOverrides = sparkSettings.executionConfigsGenericOverrides.deepCopy();
        sparkSettings.executionConfigs.forEach(cfg -> this.executionConfigs.add(cfg.deepCopy()));
        this.configForJupyter = sparkSettings.configForJupyter;
        this.configForSEK = sparkSettings.configForSEK;
        this.configForInteractive = sparkSettings.configForInteractive;
        this.useNativeProcessors = sparkSettings.useNativeProcessors;
        this.engineCreationSettings = sparkSettings.engineCreationSettings.deepCopy();
        this.yarnClusterSettings = sparkSettings.yarnClusterSettings.deepCopy();
        this.interactiveExecutionEngine = sparkSettings.interactiveExecutionEngine != null ? sparkSettings.interactiveExecutionEngine : null;
    }

    public SparkSettings deepCopy() {
        return new SparkSettings(this);
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        for (SparkExecutionConfig executionConfig : this.executionConfigs) {
            for (ClusterProperty property : executionConfig.conf) {
                if (!property.secret) continue;
                property.value = cryptoService.encryptIfNotEncryptedOrEmpty(property.value);
            }
        }
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        for (SparkExecutionConfig executionConfig : this.executionConfigs) {
            for (ClusterProperty property : executionConfig.conf) {
                if (!property.secret) continue;
                property.value = cryptoService.decryptIfEncrypted(property.value);
            }
        }
    }

    public static enum SparkConfigSelectionMode {
        NO_DEFAULT_IF_EMPTY,
        WITH_DEFAULT_IF_EMPTY,
        WITH_JUPYTER_IF_EMPTY,
        WITH_SEK_IF_EMPTY,
        WITH_INTERACTIVE_IF_EMPTY;

    }

    public static class GlobalSparkEngineCreationSettings {
        public AbstractSparkRecipeParams.SparkExecutionEngine executionEngine = AbstractSparkRecipeParams.SparkExecutionEngine.SPARK_SUBMIT;
        public String executionConfig;
        public boolean useGlobalMetastore;

        GlobalSparkEngineCreationSettings() {
        }

        GlobalSparkEngineCreationSettings(GlobalSparkEngineCreationSettings settings) {
            this.executionEngine = settings.executionEngine;
            this.executionConfig = settings.executionConfig;
            this.useGlobalMetastore = settings.useGlobalMetastore;
        }

        GlobalSparkEngineCreationSettings deepCopy() {
            return new GlobalSparkEngineCreationSettings(this);
        }
    }

    public static class YarnClusterSettings {
        public String connectionName;
        public String location;
        public String tunnelConnectionName;
        public String tunnelRemoteHost;

        public YarnClusterSettings() {
        }

        YarnClusterSettings(YarnClusterSettings settings) {
            this.connectionName = settings.connectionName;
            this.location = settings.location;
            this.tunnelConnectionName = settings.tunnelConnectionName;
            this.tunnelRemoteHost = settings.tunnelRemoteHost;
        }

        YarnClusterSettings deepCopy() {
            return new YarnClusterSettings(this);
        }
    }
}

