/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import java.io.IOException;

public abstract class AbstractNodeCodeEnvsAccessService {
    protected abstract boolean doesEnvExist(CodeEnvModel.EnvLang var1, String var2) throws IOException;

    public void checkEnvExists(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        if (!this.doesEnvExist(envLang, envName)) {
            if (DSSInternalCodeEnvsService.DSSInternalCodeEnvType.isInternalCodeEnvName(envName)) {
                throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_INTERNAL_ENV, envLang.name() + " env " + envName + " not found");
            }
            String err = envLang.name() + " env " + envName + " doesn't exist";
            if (envName.startsWith("plugin_") && ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.CDE) {
                err = err + ". An admin must rebuild the container image with the relevant plugin";
            }
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV, err);
        }
    }

    public void checkEnvDoesntExists(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        if (this.doesEnvExist(envLang, envName)) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_EXISTING_ENV, envLang.name() + " env " + envName + " already exists");
        }
    }
}

