/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.preprocessing.SentenceEmbeddingModelMeta;
import com.dataiku.dip.code.DSSInternalCodeEnvsService;
import com.dataiku.dip.code.DesignNodeCodeEnvPackagePresets;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.containers.exec.ContainerExecImagesHelper;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class CodeEnvModel {
    public static final String ACTUAL_FOLDER_NAME = "actual";
    public static final String AUTOMATION_CODE_ENVS = "acode-envs";
    public static final String CONDA_SPEC_FILE_NAME = "environment.spec";
    public static final String DESC_JSON_FILE_NAME = "desc.json";
    public static final String DESC_FOLDER_NAME = "desc";
    public static final String DESIGN_CODE_ENVS = "code-envs";
    public static final String ENV_FOLDER_NAME = "env";
    public static final String ENV_JSON_FILE_NAME = "env.json";
    public static final String LINKS_FOLDER_NAME = "links";
    public static final String RESOURCES_ENV_JSON_FILE_NAME = "resources_env.json";
    public static final String RESOURCES_MODELS_META_JSON_FILE_NAME = "models_meta.json";
    public static final String RESOURCES_FOLDER_NAME = "resources";
    public static final String RESOURCES_INIT_SCRIPT_FILE_NAME = "resources_init.py";
    public static final String SPEC_FOLDER_NAME = "spec";
    public static final String VERSIONS_FOLDER_NAME = "versions";
    public static final String ENV_DRAFT_CONFIG_FILE_NAME = "draft_config.json";
    public static final String LATEST_VERSION = "Latest";
    private static DKULogger logger = DKULogger.getLogger((String)"dku.codeenvs");

    public static PythonEnvDesc.CorePythonPackagesSet getAutoCorePackagesSet(StandardPythonInterpreter pythonInterpreter, boolean conda) {
        PythonEnvDesc.CorePythonPackagesSet autoCorePackageSet = conda && pythonInterpreter == StandardPythonInterpreter.PYTHON310 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS14 : (pythonInterpreter == StandardPythonInterpreter.PYTHON27 || pythonInterpreter == StandardPythonInterpreter.PYTHON35 ? PythonEnvDesc.CorePythonPackagesSet.LEGACY_PANDAS023 : (pythonInterpreter == StandardPythonInterpreter.PYTHON39 || pythonInterpreter == StandardPythonInterpreter.PYTHON310 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS13 : (pythonInterpreter == StandardPythonInterpreter.PYTHON311 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS15 : (pythonInterpreter == StandardPythonInterpreter.PYTHON312 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS21 : (pythonInterpreter == StandardPythonInterpreter.PYTHON313 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS22 : PythonEnvDesc.CorePythonPackagesSet.PANDAS11)))));
        logger.infoV("getAutoCorePackageSet, interpreter=%s conda=%s -> %s", new Object[]{pythonInterpreter, conda, autoCorePackageSet});
        return autoCorePackageSet;
    }

    public static PythonEnvDesc.CorePythonPackagesSet getDefaultCorePackagesSet(StandardPythonInterpreter pythonInterpreter) {
        PythonEnvDesc.CorePythonPackagesSet defaultCorePackageSet = pythonInterpreter == StandardPythonInterpreter.PYTHON27 || pythonInterpreter == StandardPythonInterpreter.PYTHON35 ? PythonEnvDesc.CorePythonPackagesSet.LEGACY_PANDAS023 : (pythonInterpreter == StandardPythonInterpreter.PYTHON36 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS11 : (pythonInterpreter == StandardPythonInterpreter.PYTHON37 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS13 : (pythonInterpreter == StandardPythonInterpreter.PYTHON38 ? PythonEnvDesc.CorePythonPackagesSet.PANDAS20 : PythonEnvDesc.CorePythonPackagesSet.PANDAS23)));
        logger.infoV("getDefaultCorePackageSet, interpreter=%s -> %s", new Object[]{pythonInterpreter, defaultCorePackageSet});
        return defaultCorePackageSet;
    }

    public static class PythonEnvDesc
    extends AbstractEnvDesc {
        @Nullable
        public Boolean useReferenceSpec;
        public String yarnPythonBin;
        public StandardPythonInterpreter pythonInterpreter = StandardPythonInterpreter.PYTHON39;
        public String customInterpreter;
        public boolean installCorePackages;
        public CorePythonPackagesSet corePackagesSet;
        public boolean installJupyterSupport;
        public DockerImageResourcesOptions dockerImageResources = DockerImageResourcesOptions.INIT;
        public boolean updateResourcesApiNode;
        public List<PythonInterpreterChange> pythonInterpreterChangeHistory = new ArrayList<PythonInterpreterChange>();
        public List<PredefinedContainerHook> predefinedContainerHooks = new ArrayList<PredefinedContainerHook>();
        public DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset upstreamPreset;

        public boolean useReferenceSpec() {
            return this.useReferenceSpec != null && this.useReferenceSpec != false;
        }

        public static enum DockerImageResourcesOptions {
            INIT,
            COPY,
            NONE;

        }

        public static enum CorePythonPackagesSet {
            LEGACY_PANDAS023,
            PANDAS10,
            PANDAS11,
            PANDAS12,
            PANDAS13,
            PANDAS14,
            PANDAS15,
            PANDAS20,
            PANDAS21,
            PANDAS22,
            PANDAS23,
            AUTO,
            DEFAULT;

        }
    }

    public static class CodeEnvResourcesModelsMeta {
        public Map<String, SentenceEmbeddingModelMeta> sentence_transformers = new HashMap<String, SentenceEmbeddingModelMeta>();

        public Map<String, Integer> getResourcesModelsMetaSizes() {
            HashMap<String, Integer> resourcesModelsMetaSizes = new HashMap<String, Integer>();
            resourcesModelsMetaSizes.put("sentenceTransformers", this.sentence_transformers.size());
            return resourcesModelsMetaSizes;
        }
    }

    public static class CodeEnvResourcesEnvVariables {
        public Map<String, ResourcesEnvVariable> variables = new HashMap<String, ResourcesEnvVariable>();

        public Map<String, String> resolve(File root) {
            HashMap<String, String> resolvedEnvVariables = new HashMap<String, String>();
            this.variables.forEach((name, resourcesEnvVariable) -> {
                switch (resourcesEnvVariable.type) {
                    case RAW_STRING: {
                        resolvedEnvVariables.put((String)name, resourcesEnvVariable.value);
                        break;
                    }
                    case RELATIVE_PATH: {
                        resolvedEnvVariables.put((String)name, DKUFileUtils.getWithin((File)root, (String[])new String[]{resourcesEnvVariable.value}).getAbsolutePath());
                        break;
                    }
                }
            });
            return resolvedEnvVariables;
        }

        public Map<String, String> resolveUnsafe(String path) {
            HashMap<String, String> resolvedEnvVariables = new HashMap<String, String>();
            this.variables.forEach((name, resourcesEnvVariable) -> {
                switch (resourcesEnvVariable.type) {
                    case RAW_STRING: {
                        resolvedEnvVariables.put((String)name, resourcesEnvVariable.value);
                        break;
                    }
                    case RELATIVE_PATH: {
                        if (!path.startsWith("/")) {
                            throw new IllegalArgumentException("Path should be absolute, i.e. start with '/'.");
                        }
                        resolvedEnvVariables.put((String)name, PathUtils.concatLNT((String[])new String[]{path, resourcesEnvVariable.value}));
                        break;
                    }
                }
            });
            return resolvedEnvVariables;
        }
    }

    public static class ResourcesEnvVariable {
        private String value;
        private EnvVariableType type;
    }

    public static enum EnvVariableType {
        RAW_STRING,
        RELATIVE_PATH;

    }

    public static class RPluginEnvDesc
    extends AbstractPluginEnvDesc {
    }

    public static class PythonPluginEnvDesc
    extends AbstractPluginEnvDesc {
        public List<StandardPythonInterpreter> acceptedPythonInterpreters = Lists.newArrayList();
        public PythonEnvDesc.CorePythonPackagesSet corePackagesSet;

        public static PythonPluginEnvDesc createNewWithDefaults() {
            PythonPluginEnvDesc pythonPluginEnvDesc = new PythonPluginEnvDesc();
            pythonPluginEnvDesc.acceptedPythonInterpreters = Lists.newArrayList((Object[])new StandardPythonInterpreter[]{StandardPythonInterpreter.PYTHON36, StandardPythonInterpreter.PYTHON37, StandardPythonInterpreter.PYTHON38, StandardPythonInterpreter.PYTHON39, StandardPythonInterpreter.PYTHON310, StandardPythonInterpreter.PYTHON311, StandardPythonInterpreter.PYTHON312, StandardPythonInterpreter.PYTHON313});
            pythonPluginEnvDesc.corePackagesSet = PythonEnvDesc.CorePythonPackagesSet.AUTO;
            return pythonPluginEnvDesc;
        }
    }

    public static abstract class AbstractPluginEnvDesc {
        public boolean forceConda;
        public boolean installCorePackages;
        public boolean installJupyterSupport;
    }

    public static class EnvFullRef {
        public final EnvLang lang;
        public final String name;
        public final String version;

        public EnvFullRef(EnvLang codeEnvLang, String codeEnvName, @Nullable String codeEnvVersion) {
            this.lang = codeEnvLang;
            this.name = codeEnvName;
            this.version = codeEnvVersion != null ? codeEnvVersion : CodeEnvModel.LATEST_VERSION;
        }
    }

    public static class EnvVersionRef {
        public String envName;
        public String envVersion;
    }

    public static class AutomationNewEnvSpec {
        public CodeEnvDeploymentMode deploymentMode;
        public EnvLang envLang;
        public String envName;
        public StandardPythonInterpreter pythonInterpreter;
        public String customInterpreter;
        public boolean conda;
        public String externalCondaEnvName;
        public boolean installCorePackages;
        public boolean installJupyterSupport;
        public String owner;
    }

    public static class DesignNewPythonEnvSpec
    extends PythonEnvDesc {
        public String envName;

        public void initializeCorePackageSetBasedOnInterpreter() {
            if (this.corePackagesSet == null) {
                this.corePackagesSet = CodeEnvModel.getDefaultCorePackagesSet(this.pythonInterpreter);
            }
        }
    }

    public static class DesignNewREnvSpec
    extends REnvDesc {
        public String envName;
    }

    public static enum EnvImportSpecificationMode {
        SPECIFIED,
        ACTUAL;

    }

    public static enum BasePackagesInstallMethod {
        PRE_BUILT,
        PIP;

    }

    public static class PackageNames {
        public static final String ACCELERATE = "accelerate";
        public static final String AZURE_SEARCH_DOCUMENTS = "azure-search-documents";
        public static final String AZURE_CORE = "azure-core";
        public static final String AZURE_IDENTITY = "azure-identity";
        public static final String BITSANDBYTES = "bitsandbytes";
        public static final String CHROMADB = "chromadb";
        public static final String CLOUDPICKLE = "cloudpickle";
        public static final String CMDSTANPY = "cmdstanpy";
        public static final String DATASETS = "datasets";
        public static final String ECONML = "econml";
        public static final String EINOPS = "einops";
        public static final String FASTDIGEST = "fastdigest";
        public static final String FLASK = "flask";
        public static final String FAISS_CPU = "faiss-cpu";
        public static final String GLUONTS = "gluonts";
        public static final String GRPCIO = "grpcio";
        public static final String H5PY = "h5py";
        public static final String HF_TRANSFER = "hf-transfer";
        public static final String ITSDANGEROUS = "itsdangerous";
        public static final String JINJA2 = "Jinja2";
        public static final String KERAS = "keras";
        public static final String LANGCHAIN = "langchain";
        public static final String LANGCHAIN_COMMUNITY = "langchain-community";
        public static final String LANGCHAIN_ELASTICSEARCH = "langchain-elasticsearch";
        public static final String LIGHTGBM = "lightgbm";
        public static final String LIGHTNING = "lightning";
        public static final String PYTORCH_LIGHTNING = "pytorch-lightning";
        public static final String MARKUPSAFE = "MarkupSafe";
        public static final String MXNET = "mxnet";
        public static final String OPENSEARCH_PY = "opensearch-py";
        public static final String PEFT = "peft";
        public static final String PILLOW = "pillow";
        public static final String PMDARIMA = "pmdarima";
        public static final String PROPHET = "prophet";
        public static final String PROTOBUF = "protobuf";
        public static final String PYAML = "pyaml";
        public static final String PYDANTIC = "pydantic";
        public static final String PYKAFKA = "pykafka";
        public static final String SAFETENSORS = "safetensors";
        public static final String SCIKIT_OPTIMIZE = "scikit-optimize";
        public static final String SCIPY = "scipy";
        public static final String SENTENCE_PIECE = "sentencepiece";
        public static final String SENTENCE_TRANSFORMERS = "sentence-transformers";
        public static final String SSECLIENT = "sseclient";
        public static final String SKLEARN = "scikit-learn";
        public static final String SKORCH = "skorch";
        public static final String STATSMODELS = "statsmodels";
        public static final String TDIGEST = "tdigest";
        public static final String TENSORFLOW = "tensorflow";
        public static final String TENSORFLOW_AND_CUDA = "tensorflow[and-cuda]";
        public static final String TIMM = "timm";
        public static final String TENSORFLOW_MACOS = "tensorflow-macos";
        public static final String TENSORFLOW_METAL = "tensorflow-metal";
        public static final String TIKTOKEN = "tiktoken";
        public static final String TOKENIZERS = "tokenizers";
        public static final String TORCH = "torch";
        public static final String TRANSFORMERS = "transformers[torch]";
        public static final String TRL = "trl";
        public static final String VLLM = "vllm";
        public static final String WERKZEUG = "Werkzeug";
        public static final String XGBOOST = "xgboost";
        public static final String PYSQLITE3_BINARY = "pysqlite3-binary";
        public static final String QDRANT_CLIENT = "qdrant_client";
        public static final String RAGAS = "ragas";
        public static final String BERT_SCORE = "bert-score";
        public static final String BLEU = "sacrebleu";
        public static final String ROUGE = "rouge-score";
    }

    public static class CodeEnvUpdateSettings {
        public boolean upgradeAllPackages;
        public boolean forceRebuildEnv;
        public String versionToUpdate;
        public boolean updateResources = true;

        public static CodeEnvUpdateSettings forInternalEnv() {
            CodeEnvUpdateSettings updateSettings = new CodeEnvUpdateSettings();
            updateSettings.upgradeAllPackages = true;
            updateSettings.forceRebuildEnv = true;
            updateSettings.updateResources = true;
            return updateSettings;
        }
    }

    public static class AutomationUIREnv
    extends AutomationUIEnv<AutomationUIREnvVersion> {
    }

    public static class AutomationUIPythonEnv
    extends AutomationUIEnv<AutomationUIPythonEnvVersion> {
    }

    public static class AutomationUIEnv<V extends AbstractAutomationUIEnvVersion<?>>
    extends PermissionAndContainerConfBearingDesc {
        public CodeEnvDeploymentMode deploymentMode;
        public EnvLang envLang;
        public String envName;
        public String externalCondaEnvName;
        public boolean unknownKernelSpecStatus;
        public SerializedError kernelSpecsListingError;
        public boolean canUpdateCodeEnv;
        public boolean canManageUsersCodeEnv;
        public AutomationEnvLevelEnvSettings envSettings;
        public V currentVersion;
        public List<V> versions = new ArrayList<V>();
        public V noVersion;
    }

    public static class AutomationUIREnvVersion
    extends AbstractAutomationUIEnvVersion<REnvDesc> {
    }

    public static class AutomationUIPythonEnvVersion
    extends AbstractAutomationUIEnvVersion<PythonEnvDesc> {
        public PythonEnvInfo info;
        public String resourcesInitScript = "";
        public List<PredefinedContainerHook> predefinedContainerHooks = new ArrayList<PredefinedContainerHook>();
    }

    public static class AbstractAutomationUIEnvVersion<T extends AbstractEnvDesc>
    extends EnvSpecFilesBase {
        @Nullable
        public String versionId;
        public String path;
        public String kernelSpecName;
        public Map<String, String> kernelSpecNames = Maps.newHashMap();
        public List<String> links = Lists.newArrayList();
        public boolean ready;
        public T desc;
    }

    public static class DesignUIREnv
    extends AbstractDesignUIEnv<REnvDesc> {
    }

    public static class DesignUIPythonEnv
    extends AbstractDesignUIEnv<PythonEnvDesc> {
        public PythonEnvInfo info;
        public String resourcesInitScript = "";
        public List<PredefinedContainerHook> predefinedContainerHooks = new ArrayList<PredefinedContainerHook>();
    }

    public static abstract class AbstractDesignUIEnv<T extends AbstractEnvDesc>
    extends EnvSpecFilesBase {
        public CodeEnvDeploymentMode deploymentMode;
        public String owner;
        public boolean usableByAll;
        public EnvLang envLang;
        public String envName;
        public String externalCondaEnvName;
        public String path;
        public String kernelSpecName;
        public boolean unknownKernelSpecStatus;
        public SerializedError kernelSpecsListingError;
        public boolean canUpdateCodeEnv;
        public boolean canManageUsersCodeEnv;
        public List<PermissionItem> permissions;
        public T desc;
    }

    public static class EnvSpecFilesBase
    extends ContainerConfBearingDesc {
        public String mandatoryPackageList = "";
        public String mandatoryCondaEnvironment = "";
        public String specPackageList;
        public String specCondaEnvironment;
        public String actualPackageList;
        public String actualCondaEnvironment;
        public DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset upstreamPreset;
    }

    public static class EnvSpecData<D extends AbstractEnvDesc> {
        public D desc;
        public String packageList;
        public String condaEnvSpec;
        public String resourcesInitScript = "";
    }

    public static class REnvActualData
    extends AbstractEnvActualData {
    }

    public static class PythonEnvActualData
    extends AbstractEnvActualData {
        public String pythonVersion;
    }

    public static abstract class AbstractEnvActualData {
        public boolean conda;
        public String nocondaEnvSpec;
        public String condaEnvSpec;
    }

    public static class PythonEnvInfo {
        public String pythonVersion;
    }

    @UIModel
    public static class CodeEnvListItem
    extends ContainerConfBearingDesc {
        public String envName;
        public EnvLang envLang;
        public CodeEnvDeploymentMode deploymentMode;
        public String owner;
        public boolean canUpdateCodeEnv;
        public boolean canManageUsersCodeEnv;
        public String kernelSpecName;
        public List<String> kernelSpecNames;
        public boolean unknownKernelSpecStatus;
        public StandardPythonInterpreter pythonInterpreter;
        public boolean isUptodate;
        public DesignNodeCodeEnvPackagePresets.CodeEnvPackagePreset upstreamPreset;
        Set<String> builtForContainerConfs;
        public List<OutdatedItem> outdatedItems = new ArrayList<OutdatedItem>();

        public boolean isPythonInterpreterDeprecated() {
            return this.pythonInterpreter != null && this.pythonInterpreter.isDeprecated();
        }

        public CodeEnvListItem withOutdatedRequirementsWarning(DSSInternalCodeEnvsService.DSSInternalCodeEnv internalCodeEnv, EnvSpecData<AbstractEnvDesc> currentEnvSpec) throws IOException {
            Object d = currentEnvSpec.desc;
            if (!(d instanceof PythonEnvDesc)) {
                return this;
            }
            PythonEnvDesc desc = (PythonEnvDesc)d;
            if (!desc.useReferenceSpec()) {
                return this;
            }
            File latestRequirementsFile = DKUFileUtils.getWithin((File)internalCodeEnv.getResourceSpecFolder(), (String[])new String[]{CodeEnvModel.SPEC_FOLDER_NAME, EnvLang.PYTHON.getPackageFileName()});
            String latestPackageList = FileUtils.readFileToString((File)latestRequirementsFile, (Charset)StandardCharsets.UTF_8);
            if (!Objects.equals(currentEnvSpec.packageList, latestPackageList)) {
                this.outdatedItems.add(OutdatedItem.REQUIREMENTS);
            }
            return this;
        }

        public CodeEnvListItem withOutdatedContainerImagesWarning() {
            List<Object> configsToCheck;
            GeneralSettingsDAO.GeneralSettings settings = ApplicationConfigurator.getGeneralSettings();
            if (this.allContainerConfs) {
                configsToCheck = settings.containerSettings.listConfigsForWorkloadType(WorkloadType.USER_CODE);
            } else {
                configsToCheck = new ArrayList();
                for (String string : this.containerConfs) {
                    ContainerExecRuntimeConfig containerConfig = settings.containerSettings.getByNameOrNull(string);
                    if (containerConfig == null) {
                        logger.warn((Object)String.format("Container config '%s' does not exist, maybe was renamed or deleted?", string));
                        this.outdatedItems.add(OutdatedItem.CONTAINER_IMAGES);
                        return this;
                    }
                    configsToCheck.add(containerConfig);
                }
            }
            for (ContainerExecRuntimeConfig containerExecRuntimeConfig : configsToCheck) {
                if (ContainerExecImagesHelper.builtForContainerConf(containerExecRuntimeConfig, this.envName, this.envLang, null)) continue;
                this.outdatedItems.add(OutdatedItem.CONTAINER_IMAGES);
                return this;
            }
            return this;
        }

        public static enum OutdatedItem {
            REQUIREMENTS,
            CONTAINER_IMAGES;

        }
    }

    public static enum CodeEnvDeploymentMode {
        DSS_INTERNAL,
        DESIGN_MANAGED,
        DESIGN_NON_MANAGED,
        PLUGIN_MANAGED,
        PLUGIN_NON_MANAGED,
        AUTOMATION_VERSIONED,
        AUTOMATION_SINGLE,
        AUTOMATION_NON_MANAGED_PATH,
        EXTERNAL_CONDA_NAMED;

    }

    public static class REnvDesc
    extends AbstractEnvDesc {
        public String yarnRBin;
        public boolean installCorePackages;
        public boolean installJupyterSupport;
    }

    public static class JuliaEnvDesc
    extends AbstractEnvDesc {
    }

    public static class PredefinedContainerHook {
        public PredefinedContainerHookType type;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PredefinedContainerHook that = (PredefinedContainerHook)o;
            return this.type == that.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type});
        }
    }

    public static enum PredefinedContainerHookType {
        SYSTEM_LEVEL_CUDA_112_CUDNN_811,
        SYSTEM_LEVEL_CUDA_122_CUDNN_897,
        CUDA_SUPPORT_FOR_TORCH2_WITH_PYPI_NVIDIA_PACKAGES,
        BASIC_GPU_ENABLING,
        PYTHON36_SUPPORT,
        PYTHON37_SUPPORT,
        PYTHON38_SUPPORT,
        AGENT_TOOL_MCP_SERVERS_SUPPORT,
        TESSERACT_OCR_SUPPORT;

    }

    public static enum ContainerCacheBustingLocation {
        BEGINNING,
        AFTER_START_DOCKERFILE,
        AFTER_PACKAGES,
        AFTER_AFTER_PACKAGES_DOCKERFILE,
        END,
        NONE;

    }

    public static class CodeEnvSettings
    extends GeneralSettingsDAO.AbstractCodeEnvExtraSettings {
        public boolean inheritGlobalSettings = true;
    }

    public static abstract class AbstractEnvDesc
    extends PermissionAndContainerConfBearingDesc {
        public boolean conda;
        public VersionTag creationTag = new VersionTag();
        public VersionTag versionTag = new VersionTag();
        public CodeEnvDeploymentMode deploymentMode;
        public String externalCondaEnvName;
        public CodeEnvSettings envSettings = new CodeEnvSettings();
    }

    public static class AutomationEnvRootDef
    extends PermissionAndContainerConfBearingDesc {
        public CodeEnvDeploymentMode deploymentMode;
        public AutomationEnvLevelEnvSettings envSettings = new AutomationEnvLevelEnvSettings();
    }

    public static class AutomationEnvLevelEnvSettings
    extends GeneralSettingsDAO.AbstractCodeEnvExtraSettings {
        public boolean overrideImportedEnvSettings = false;
    }

    public static class PythonInterpreterChange {
        public StandardPythonInterpreter previousPythonVersion;
        public String previousPackageList;
        public long modifiedOn;

        public PythonInterpreterChange(StandardPythonInterpreter previousPythonVersion, String previousPackageList, long modifiedOn) {
            this.previousPythonVersion = previousPythonVersion;
            this.previousPackageList = previousPackageList;
            this.modifiedOn = modifiedOn;
        }
    }

    public static class EnvDeletionResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }

    public static class EnvVersionCreationResult
    extends EnvCreationResult {
        public AbstractAutomationUIEnvVersion<?> version;

        public EnvVersionCreationResult(String envName) {
            super(envName);
        }
    }

    public static class EnvCreationResult {
        public String envName;
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();

        public EnvCreationResult(String envName) {
            this.envName = envName;
        }
    }

    public static class EnvImageRebuildResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public String logFileName;
        public List<String> imagesBuilt;
    }

    public static class EnvUpdateResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }

    public static class PermissionAndContainerConfBearingDesc
    extends ContainerConfBearingDesc {
        public String owner;
        public boolean usableByAll;
        public List<PermissionItem> permissions = new ArrayList<PermissionItem>();
    }

    public static class ContainerConfBearingDesc {
        public boolean allContainerConfs = false;
        public List<String> containerConfs = new ArrayList<String>();
        public boolean allSparkKubernetesConfs = false;
        public List<String> sparkKubernetesConfs = new ArrayList<String>();
        public String dockerfileAtStart;
        public String dockerfileBeforePackages;
        public String dockerfileAfterCondaPackages;
        public String dockerfileAfterPackages;
        public String dockerfileAtEnd;
        public ContainerCacheBustingLocation containerCacheBustingLocation = ContainerCacheBustingLocation.AFTER_START_DOCKERFILE;
        public RebuildDependentCodeStudioTemplates rebuildDependentCodeStudioTemplates = RebuildDependentCodeStudioTemplates.ASK;

        public static enum RebuildDependentCodeStudioTemplates {
            ASK,
            ALL,
            NONE;

        }
    }

    public static class PermissionItem {
        public String group;
        public boolean update;
        public boolean use;
        public boolean manageUsers;

        public PermissionItem() {
        }

        public PermissionItem(PermissionItem key) {
            this.group = key.group;
            this.update = key.update;
            this.use = key.use;
            this.manageUsers = key.manageUsers;
        }

        public PermissionItem deepCopy() {
            return new PermissionItem(this);
        }
    }

    public static class CodeEnvUsage {
        public EnvUsage envUsage;
        public String projectKey;
        public String objectId;
        public EnvLang envLang;
        public String envName;
        public Boolean accessible = true;

        public CodeEnvUsage(EnvLang envLang, String envName, EnvUsage envUsage, String projectKey, String objectId) {
            this.envLang = envLang;
            this.envName = envName;
            this.envUsage = envUsage;
            this.projectKey = projectKey;
            this.objectId = objectId;
        }

        public void notAccessible() {
            this.accessible = false;
        }
    }

    public static class UsedCodeEnvRef {
        public final EnvLang envLang;
        public final String envName;

        public UsedCodeEnvRef(UsedCodeEnvRef o) {
            this.envLang = o.envLang;
            this.envName = o.envName;
        }

        public UsedCodeEnvRef(EnvLang envLang, String envName) {
            this.envLang = envLang;
            this.envName = envName;
        }

        public String toString() {
            return "<UsedCodeEnv lang=" + String.valueOf((Object)this.envLang) + " name=" + this.envName + ">";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.envLang == null ? 0 : this.envLang.hashCode());
            result = 31 * result + (this.envName == null ? 0 : this.envName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UsedCodeEnvRef other = (UsedCodeEnvRef)obj;
            if (this.envLang != other.envLang) {
                return false;
            }
            return !(this.envName == null ? other.envName != null : !this.envName.equals(other.envName));
        }
    }

    public static enum EnvUsage {
        PROJECT,
        RECIPE,
        NOTEBOOK,
        PLUGIN,
        SCENARIO,
        SCENARIO_STEP,
        SCENARIO_TRIGGER,
        DATASET_METRIC,
        DATASET_CHECK,
        DATASET,
        WEBAPP,
        REPORT,
        API_SERVICE_ENDPOINT,
        SAVED_MODEL,
        MODEL,
        CODE_STUDIO_TEMPLATE,
        RETRIEVABLE_KNOWLEDGE;

    }

    public static enum EnvLang {
        PYTHON("python", "requirements.txt", PythonEnvDesc.class),
        R("R", "rPackages.txt", REnvDesc.class),
        JULIA("julia", "Project.toml", JuliaEnvDesc.class);

        private final String languageInfo;
        private final String packageFileName;
        private final Class<? extends AbstractEnvDesc> descClazz;

        private EnvLang(String languageInfo, String packageFileName, Class<? extends AbstractEnvDesc> descClazz) {
            this.languageInfo = languageInfo;
            this.packageFileName = packageFileName;
            this.descClazz = descClazz;
        }

        public String getLanguageInfo() {
            return this.languageInfo;
        }

        public String getFolderName() {
            return this.languageInfo;
        }

        public String getPackageFileName() {
            return this.packageFileName;
        }

        public Class<? extends AbstractEnvDesc> getDescClazz() {
            return this.descClazz;
        }
    }
}

