/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.openai.OpenAIChatAPI;
import com.dataiku.dip.llm.online.openai.OpenAIImageHandling;
import com.dataiku.dip.llm.online.openai.OpenAIPricing;
import com.dataiku.dip.llm.utils.ImageGenerationUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.services.ConnectionsTestService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class OpenAIConnection
extends AbstractLLMConnection<OpenAIModel, HardcodedOpenAIModel, CustomOpenAIModel> {
    public static final EnrichedLLMStructuredRef.FieldRange TEMPERATURE_RANGE = new EnrichedLLMStructuredRef.FieldRange(0.0, 2.0, 0.02);
    public static final EnrichedLLMStructuredRef.FieldRange TOP_K_RANGE = null;
    public OpenAIConnectionParams params = new OpenAIConnectionParams();
    public static final String connectionType = "OpenAI";
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.connections.openai");

    @Override
    public void expandParametersInPlaceAtDAOLevelUsingGlobalContextOnly(VariablesContext vc) {
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(ICredentialsService.BasicCredential.class));
        ICredentialsService.BasicCredential creds = new ICredentialsService.BasicCredential("", this.params.apiKey);
        return clazz.cast(creds);
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public AbstractLLMConnection.AbstractLLMConnectionParams getLLMConnectionParams() {
        return this.params;
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings securitySettings) {
        this.params.apiKey = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.apiKey);
        this.params.encryptProperties(this.params.customHeaders, cryptoService);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.apiKey = cryptoService.decryptIfEncrypted(this.params.apiKey);
        this.params.decryptProperties(this.params.customHeaders, cryptoService);
    }

    @Override
    protected boolean isHardcodedModelEnabled(HardcodedOpenAIModel hardcodedModel) {
        return hardcodedModel.allowedModel.apply(this.params);
    }

    @Override
    protected List<HardcodedOpenAIModel> listRawHardcodedModels() {
        return Arrays.asList(HardcodedOpenAIModel.values());
    }

    @Override
    protected OpenAIModel loadRawHardcodedModel(HardcodedOpenAIModel hardcodedModel) {
        OpenAIModel model = hardcodedModel.toModel();
        this.loadDefaultHardcodedModelSettings(hardcodedModel, model);
        return model;
    }

    @Override
    protected DKULogger getLogger() {
        return logger;
    }

    @Override
    protected List<CustomOpenAIModel> listRawCustomModels() {
        return this.params.customModels;
    }

    @Override
    protected OpenAIModel loadRawCustomModel(CustomOpenAIModel rawCustomModel) {
        OpenAIModel model = rawCustomModel.toModel();
        this.loadDefaultCustomModelSettings(rawCustomModel, model);
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean useMaxCompletionToken() {
        boolean useMaxCompletionToken = true;
        String maxTokenLegacyParameter = ConnectionUtils.getParamsFromProperties(this.getDkuProperties()).getParam("dku.connection.llm.maxTokensName");
        if (maxTokenLegacyParameter != null) {
            logger.warnV("Bypassing maxTokensAPIMode=%s by dku.connection.llm.maxTokensName=%s", new Object[]{this.params.maxTokensAPIMode, maxTokenLegacyParameter});
            if (maxTokenLegacyParameter.equals("max_tokens")) {
                return false;
            }
            if (!maxTokenLegacyParameter.equals("max_completion_tokens")) throw new IllegalArgumentException("The dku.connection.llm.maxTokensName property must be either set to max_tokens or max_completion_tokens. Please check Max tokens API mode parameter.");
            return true;
        }
        if (this.params.maxTokensAPIMode == OpenAIConnectionParams.OpenAIMaxTokensAPIMode.AUTO) {
            return Strings.isNullOrEmpty((String)this.params.customURL);
        }
        if (this.params.maxTokensAPIMode == OpenAIConnectionParams.OpenAIMaxTokensAPIMode.LEGACY) {
            return false;
        }
        if (this.params.maxTokensAPIMode != OpenAIConnectionParams.OpenAIMaxTokensAPIMode.MODERN) throw new IllegalArgumentException(String.format("Unknown value for Max tokens API Mode: %s", new Object[]{this.params.maxTokensAPIMode}));
        return true;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testOpenAI(this, authCtx);
    }

    public static class OpenAIConnectionParams
    extends AbstractLLMConnection.AbstractLLMConnectionParams {
        public AbstractLLMConnection.HTTPBasedLLMNetworkSettings networkSettings = new AbstractLLMConnection.HTTPBasedLLMNetworkSettings();
        public int maxParallelism = 8;
        public boolean allowGPT5;
        public boolean allowGPT5Mini;
        public boolean allowGPT5Nano;
        public boolean allowGPT5Chat;
        public boolean allowO1Mini;
        public boolean allowO1;
        public boolean allowO3Mini;
        public boolean allowO3;
        public boolean allowO4Mini;
        public boolean allowO3Pro;
        public boolean allowEmbedding3Small = true;
        public boolean allowEmbedding3Large;
        public boolean allowEmbeddingAda2;
        public boolean allowDallE3;
        public boolean allowGPTImage1;
        public boolean allowGPT41;
        public boolean allowGPT41Mini;
        public boolean allowGPT41Nano;
        public boolean allowGPT4oMini;
        public boolean allowGPT4o;
        public boolean allowGPT35Turbo;
        public boolean allowGPT4Turbo;
        public boolean allowGPT4;
        public boolean allowGPT35TurboInstruct;
        public boolean allowGPT3Davinci;
        public boolean allowGPT3Babbage;
        public List<CustomOpenAIModel> customModels = new ArrayList<CustomOpenAIModel>();
        public String apiKey;
        public String organizationId;
        public String customURL;
        public List<AbstractSQLConnection.CustomDatabaseProperty> customHeaders = new ArrayList<AbstractSQLConnection.CustomDatabaseProperty>();
        public OpenAIMaxTokensAPIMode maxTokensAPIMode = OpenAIMaxTokensAPIMode.AUTO;

        public static enum OpenAIMaxTokensAPIMode {
            AUTO,
            MODERN,
            LEGACY;

        }
    }

    public static enum HardcodedOpenAIModel implements AbstractLLMConnection.IHardcodedConnectionModel<OpenAIModel>
    {
        GPT5("gpt-5", "GPT-5", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT5, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT5_MINI("gpt-5-mini", "GPT-5 mini", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT5Mini, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT5_NANO("gpt-5-nano", "GPT-5 nano", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT5Nano, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT5_CHAT("gpt-5-chat-latest", "GPT-5 Chat", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT5Chat, OpenAIChatAPI.CHAT_COMPLETIONS),
        O1("o1", "o1", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowO1, OpenAIChatAPI.CHAT_COMPLETIONS),
        O3_MINI("o3-mini", "o3 mini", OpenAIModelType.COMPLETION_CHAT, false, p -> p.allowO3Mini, OpenAIChatAPI.CHAT_COMPLETIONS),
        O3("o3", "o3", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowO3, OpenAIChatAPI.CHAT_COMPLETIONS),
        O3_PRO("o3-pro", "o3 pro", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowO3Pro, OpenAIChatAPI.RESPONSES),
        O4_MINI("o4-mini", "o4 mini", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, false, p -> p.allowO4Mini, OpenAIChatAPI.CHAT_COMPLETIONS),
        EMBEDDING_3_SMALL("text-embedding-3-small", "Embedding v3 Small", OpenAIModelType.TEXT_EMBEDDING_EXTRACTION, false, 1536, 8191, p -> p.allowEmbedding3Small),
        EMBEDDING_3_LARGE("text-embedding-3-large", "Embedding v3 Large", OpenAIModelType.TEXT_EMBEDDING_EXTRACTION, false, 3072, 8191, p -> p.allowEmbedding3Large),
        EMBEDDING_ADA("text-embedding-ada-002", "Embedding Ada v2 (Legacy)", OpenAIModelType.TEXT_EMBEDDING_EXTRACTION, false, 1536, 8191, p -> p.allowEmbeddingAda2),
        GPT_IMAGE_1("gpt-image-1", "GPT Image 1", OpenAIModelType.IMAGE_GENERATION, OpenAIImageHandling.GPT_IMAGE_1, p -> p.allowGPTImage1),
        IMAGEGEN_DALLE3("dall-e-3", "DallE-3", OpenAIModelType.IMAGE_GENERATION, OpenAIImageHandling.DALL_E_3, p -> p.allowDallE3),
        GPT41("gpt-4.1", "GPT-4.1", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT41, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT41_MINI("gpt-4.1-mini", "GPT-4.1 mini", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowGPT41Mini, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT41_NANO("gpt-4.1-nano", "GPT-4.1 nano", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowGPT41Nano, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4O_MINI("gpt-4o-mini", "GPT-4o mini", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, true, p -> p.allowGPT4oMini, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4O("gpt-4o", "GPT-4o", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT4o, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4_TURBO("gpt-4-turbo", "GPT 4 Turbo", OpenAIModelType.COMPLETION_CHAT_MULTIMODAL, p -> p.allowGPT4Turbo, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4("gpt-4", "GPT 4", OpenAIModelType.COMPLETION_CHAT, p -> p.allowGPT4, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT35_TURBO_LARGE_CONTEXT("gpt-3.5-turbo-16k", "GPT 3.5 Chat (Turbo / ChatGPT) (legacy large context alias)", OpenAIModelType.COMPLETION_CHAT, p -> p.allowGPT35Turbo, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4_TURBO_PREVIEW_1106("gpt-4-1106-preview", "GPT 4 Turbo (legacy preview 1106 model)", OpenAIModelType.COMPLETION_CHAT, p -> p.allowGPT4Turbo, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT4_TURBO_PREVIEW("gpt-4-turbo-preview", "GPT 4 Turbo (legacy preview model)", OpenAIModelType.COMPLETION_CHAT, p -> p.allowGPT4Turbo, OpenAIChatAPI.CHAT_COMPLETIONS),
        O1_MINI("o1-mini", "o1 mini (deprecated / scheduled for retirement on Oct. 27th, 2025)", OpenAIModelType.COMPLETION_CHAT_NO_SYSTEM_PROMPT, false, p -> p.allowO1Mini, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT35_TURBO("gpt-3.5-turbo", "GPT 3.5 Turbo (legacy)", OpenAIModelType.COMPLETION_CHAT, true, p -> p.allowGPT35Turbo, OpenAIChatAPI.CHAT_COMPLETIONS),
        GPT3_DAVINCI("davinci-002", "Legacy GPT 3 Base model - Davinci (high quality, slower)", OpenAIModelType.COMPLETION_SIMPLE, p -> p.allowGPT3Davinci, null),
        GPT3_BABBAGE("babbage-002", "Legacy GPT 3 Base model - Babbage (faster and lower cost)", OpenAIModelType.COMPLETION_SIMPLE, p -> p.allowGPT3Babbage, null),
        GPT35_TURBO_INSTRUCT("gpt-3.5-turbo-instruct", "Legacy GPT 3.5 Instruct - InstructGPT style model", OpenAIModelType.COMPLETION_SIMPLE, p -> p.allowGPT35TurboInstruct, null);

        public final String id;
        public final String displayName;
        public final Integer embeddingSize;
        public final Integer maxTokensLimit;
        public final OpenAIModelType modelType;
        public final boolean canBeFineTuned;
        public final OpenAIImageHandling imageHandlingMode;
        public final Function<OpenAIConnectionParams, Boolean> allowedModel;
        public final OpenAIChatAPI api;

        private HardcodedOpenAIModel(String id, String displayName, OpenAIModelType openAIModelType, Function<OpenAIConnectionParams, Boolean> allowedModel, OpenAIChatAPI openAIChatAPI) {
            this(id, displayName, openAIModelType, false, null, null, null, allowedModel, openAIChatAPI);
        }

        private HardcodedOpenAIModel(String id, String displayName, OpenAIModelType openAIModelType, boolean canBeFineTuned, Function<OpenAIConnectionParams, Boolean> allowedModel, OpenAIChatAPI openAIChatAPI) {
            this(id, displayName, openAIModelType, canBeFineTuned, null, null, null, allowedModel, openAIChatAPI);
        }

        private HardcodedOpenAIModel(String id, String displayName, OpenAIModelType openAIModelType, OpenAIImageHandling imageHandlingMode, Function<OpenAIConnectionParams, Boolean> allowedModel) {
            this(id, displayName, openAIModelType, false, null, null, imageHandlingMode, allowedModel, null);
        }

        private HardcodedOpenAIModel(String id, String displayName, OpenAIModelType openAIModelType, boolean canBeFineTuned, Integer embeddingSize, Integer maxTokensLimit, Function<OpenAIConnectionParams, Boolean> allowedModel) {
            this(id, displayName, openAIModelType, canBeFineTuned, embeddingSize, maxTokensLimit, null, allowedModel, null);
        }

        private HardcodedOpenAIModel(String id, String displayName, OpenAIModelType openAIModelType, boolean canBeFineTuned, Integer embeddingSize, Integer maxTokensLimit, OpenAIImageHandling imageHandlingMode, Function<OpenAIConnectionParams, Boolean> allowedModel, OpenAIChatAPI openAIChatAPI) {
            this.id = id;
            this.displayName = displayName;
            this.modelType = openAIModelType;
            this.embeddingSize = embeddingSize;
            this.maxTokensLimit = maxTokensLimit;
            this.canBeFineTuned = canBeFineTuned;
            this.imageHandlingMode = imageHandlingMode;
            this.allowedModel = allowedModel;
            this.api = openAIChatAPI;
        }

        @Override
        public OpenAIModel toModel() {
            OpenAIModel model = new OpenAIModel();
            model.id = this.id;
            model.displayName = this.displayName;
            model.modelType = this.modelType;
            model.embeddingSize = this.embeddingSize;
            model.maxTokensLimit = this.maxTokensLimit;
            model.canBeFineTuned = this.canBeFineTuned;
            model.api = this.api;
            if (this.modelType == OpenAIModelType.TEXT_EMBEDDING_EXTRACTION) {
                model.embeddingCost = OpenAIPricing.getOpenAIEmbeddingCostPer1KTokens(this.id);
            } else if (this.modelType == OpenAIModelType.COMPLETION_SIMPLE || this.modelType == OpenAIModelType.COMPLETION_CHAT || this.modelType == OpenAIModelType.COMPLETION_CHAT_MULTIMODAL || this.modelType == OpenAIModelType.COMPLETION_CHAT_NO_SYSTEM_PROMPT) {
                model.completionCost = OpenAIPricing.getOpenAICompletionCostPer1KTokens(this.id);
                model.promptCost = OpenAIPricing.getOpenAIPromptCostPer1KTokens(this.id);
            }
            if (this.modelType == OpenAIModelType.IMAGE_GENERATION && this.imageHandlingMode != null) {
                model.imageHandlingMode = this.imageHandlingMode;
            }
            return model;
        }
    }

    public static class OpenAIModel
    extends AbstractLLMConnection.BaseModel
    implements LLMModelHandle.FineTuneableModel<OpenAIModel> {
        public boolean isDKUFineTuned;
        public OpenAIModelType modelType;
        public OpenAIChatAPI api;
        @Nullable
        public OpenAIImageHandling imageHandlingMode;
        @Nullable
        public String baseModelId;

        public boolean isChatModel() {
            return this.modelType.useChatAPI;
        }

        @Override
        public double getEstimatedImageGenerationCost(LLMClient.ImageGenerationQuery query) {
            String size = ImageGenerationUtils.getWxHString(query, 1024, 1024);
            return OpenAIPricing.getOpenAIEstimatedImageGenerationCost(this.imageHandlingMode, query.nbImagesToGenerate, size, query.quality);
        }

        @Override
        public Optional<String> getInvalidityReason() {
            if (StringUtils.isBlank((CharSequence)this.getId())) {
                return Optional.of("Empty model id");
            }
            if (this.modelType == null) {
                return Optional.of("Missing model type");
            }
            return Optional.empty();
        }

        @Override
        public boolean canBeUsedForPurpose(@Nonnull AbstractLLMConnection.LLMUsagePurpose purpose) {
            if (this.modelType == null) {
                return false;
            }
            if (purpose.equals((Object)AbstractLLMConnection.LLMUsagePurpose.FINE_TUNING)) {
                return this.canBeFineTuned();
            }
            return this.modelType.matchesPurpose(purpose);
        }

        @Override
        public LLMStructuredRef asStructuredRef(String connection) {
            return LLMStructuredRef.forOpenAIConnection(connection, this.getId());
        }

        @Override
        public AbstractLLMConnection.ModelCapabilities getModelCapabilities() {
            AbstractLLMConnection.ModelCapabilities capabilities = new AbstractLLMConnection.ModelCapabilities();
            capabilities.canGenerateCrossLanguageOutput = true;
            capabilities.handlesSystemMessage = this.isChatModel();
            capabilities.supportsImageInputs = this.canBeUsedForPurpose(AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT);
            capabilities.temperatureRange = TEMPERATURE_RANGE;
            capabilities.topKRange = TOP_K_RANGE;
            return capabilities;
        }

        @Override
        public OpenAIModel toFineTunedModel(LLMModelSnippetData snippetData) {
            OpenAIModel fineTunedModel = new OpenAIModel();
            fineTunedModel.id = snippetData.llmSMInfo.remoteModelId;
            fineTunedModel.baseModelId = this.getId();
            fineTunedModel.isDKUFineTuned = true;
            fineTunedModel.canBeFineTuned = true;
            fineTunedModel.modelType = this.modelType;
            fineTunedModel.api = this.api;
            fineTunedModel.displayName = this.displayName;
            fineTunedModel.embeddingSize = this.embeddingSize;
            fineTunedModel.maxTokensLimit = this.maxTokensLimit;
            fineTunedModel.promptCost = this.promptCost;
            fineTunedModel.completionCost = this.completionCost;
            fineTunedModel.embeddingCost = this.embeddingCost;
            return fineTunedModel;
        }

        @Override
        public String getBaseModelId() {
            return this.isDKUFineTuned ? this.baseModelId : null;
        }
    }

    public static class CustomOpenAIModel
    extends AbstractLLMConnection.CustomModel<OpenAIModel> {
        public String id;
        public String displayName;
        public OpenAIModelType modelType;
        public OpenAIChatAPI api = OpenAIChatAPI.CHAT_COMPLETIONS;
        @Nullable
        public OpenAIImageHandling imageHandlingMode = OpenAIImageHandling.DALL_E_3;

        @Override
        public OpenAIModel toModel() {
            OpenAIModel model = new OpenAIModel();
            model.loadFromCustomModel(this);
            model.id = this.id;
            model.displayName = this.displayName;
            model.modelType = this.modelType;
            model.api = this.api;
            if (this.modelType == OpenAIModelType.IMAGE_GENERATION && this.imageHandlingMode != null) {
                model.imageHandlingMode = this.imageHandlingMode;
            }
            return model;
        }
    }

    public static enum OpenAIModelType {
        COMPLETION_SIMPLE(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION), false),
        COMPLETION_CHAT(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION), true),
        COMPLETION_CHAT_NO_SYSTEM_PROMPT(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION), true),
        COMPLETION_CHAT_MULTIMODAL(Arrays.asList(AbstractLLMConnection.LLMUsagePurpose.SUMMARIZATION, AbstractLLMConnection.LLMUsagePurpose.CLASSIFICATION_WITH_USER_PROVIDED_CLASSES, AbstractLLMConnection.LLMUsagePurpose.EMOTION_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.SENTIMENT_ANALYSIS, AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION, AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT), true),
        TEXT_EMBEDDING_EXTRACTION(Collections.singletonList(AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION), false),
        IMAGE_GENERATION(Collections.singletonList(AbstractLLMConnection.LLMUsagePurpose.IMAGE_GENERATION), false);

        public final List<AbstractLLMConnection.LLMUsagePurpose> matchingPurposes;
        public final boolean useChatAPI;

        private OpenAIModelType(List<AbstractLLMConnection.LLMUsagePurpose> purposes, boolean useChatAPI) {
            this.matchingPurposes = purposes;
            this.useChatAPI = useChatAPI;
        }

        public boolean matchesPurpose(AbstractLLMConnection.LLMUsagePurpose purpose) {
            return this.matchingPurposes.contains((Object)purpose);
        }
    }
}

