/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.AccessTokenInjectingConnection;
import com.dataiku.dip.connections.ConnectionCredentialUtils;
import com.dataiku.dip.connections.ConnectionUtils;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionWithPerUserOAuth2Credentials;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SimpleSQLDSSConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.model.OAuth2Client;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.sql.VerticaSQLDialect;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.com.nimbusds.oauth2.sdk.ParseException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class VerticaConnection
extends SimpleSQLDSSConnectionWithBasicCredential
implements ConnectionWithEncryptedFields,
ConnectionWithPerUserOAuth2Credentials,
AccessTokenInjectingConnection {
    public static final String connectionType = "Vertica";
    public Params params = new Params();
    private static VerticaSQLDialect dialect;
    private static DKULogger logger;

    @Override
    public Params getParams() {
        return this.params;
    }

    @Override
    public String getType() {
        return connectionType;
    }

    @Override
    public VerticaSQLDialect getDialect() {
        if (dialect == null) {
            dialect = new VerticaSQLDialect();
        }
        return dialect;
    }

    @Override
    String getDriver() {
        return "com.vertica.jdbc.Driver";
    }

    @Override
    String getJdbcUrl() {
        if (this.params.useURL) {
            if (StringUtils.isBlank((String)this.params.url)) {
                throw ErrorContext.iae((String)"Vertica connection JDBC URL is not set");
            }
            return this.params.url;
        }
        return "jdbc:vertica://" + this.params.host + ":" + this.params.port + "/" + this.params.db;
    }

    @Override
    String getDisplayableJdbcUrl() {
        return this.params.useURL && StringUtils.isNotBlank((String)this.params.displayedUrl) ? this.params.displayedUrl : this.getJdbcUrl();
    }

    @Override
    public boolean actuallyHasBasicCredential() {
        return this.params.authType == AuthType.PASSWORD;
    }

    @Override
    public boolean actuallyHasPerUserOAuth2Credential() {
        return this.credentialsMode == DSSConnection.CredentialsMode.PER_USER && this.params.authType == AuthType.OAUTH2;
    }

    @Override
    public boolean hasRefreshTokenRotation() {
        return this.params.refreshTokenRotation;
    }

    @Override
    public boolean mustResolveOnBackend() {
        return this.hasRefreshTokenRotation() || super.mustResolveOnBackend();
    }

    @Override
    public ICredentialsService.BasicCredential getGlobalCredential() {
        return new ICredentialsService.BasicCredential(this.params.user, this.params.password);
    }

    @Override
    public void encryptFields(PasswordEncryptionService cryptoService, GeneralSettingsDAO.SecuritySettings unused) {
        this.params.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.params.password);
    }

    @Override
    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.params.password = cryptoService.decryptIfEncrypted(this.params.password);
    }

    @Override
    public List<String> getKnownDriverJars() {
        return super.getKnownDriverJarsFromJarsDirectory();
    }

    @Override
    public InfoMessage.InfoMessages canHaveSparkIntegration() {
        return new InfoMessage.InfoMessages();
    }

    @Override
    public AccessTokenInjectingConnection.AccessTokenInjector buildAccessTokenInjector(Connection connection, Properties properties) throws SQLException {
        try {
            Class<?> connectionClass = connection.getClass();
            Field m_vconnField = connectionClass.getDeclaredField("m_vconn");
            m_vconnField.setAccessible(true);
            final Object vconnection = m_vconnField.get(connection);
            Class<?> vconnectionClass = vconnection.getClass();
            final Method setTokenMethod = vconnectionClass.getDeclaredMethod("setOAuthAccessToken", String.class);
            return new AccessTokenInjectingConnection.AccessTokenInjector(){

                @Override
                public void inject(String accessToken) throws SQLException {
                    try {
                        setTokenMethod.invoke(vconnection, accessToken);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new SQLException("Unable to swap access token", e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new SQLException("Cannot dig token injection point", e);
        }
    }

    @Override
    public boolean needsAccessTokenInjection() {
        return this.params.authType == AuthType.OAUTH2;
    }

    @Override
    public OAuth2Client buildOAuth2Client(ProxySettings proxySettings, AuthCtx authCtx) throws DKUSecurityException {
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        return new OAuth2Client.Builder().authorizationEndpoint(this.params.authorizationEndpoint).tokenEndpoint(this.params.tokenEndpoint).clientId(this.params.clientId).clientSecret(this.params.clientSecret).scope(this.params.scope).audience(this.params.audience).proxy(proxySettings).useAccessTokenCache(useCache).build();
    }

    @Override
    public SQLConnectionProvider.SQLConnectionData getConnectionData_NT(AuthCtx authCtx, String projectKey) throws DKUSecurityException, SQLException {
        SerializableVerticaCredentials creds = this.getFullyResolvedCredentials_sqlLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), SerializableVerticaCredentials.class);
        SQLConnectionProvider.GenericSQLConnectionData cd = this.makeInjectingSQLConnectionData(ConnectionUtils.SQLConnectionType.valueOf(this.type.toUpperCase()), this.getDialect(), this, this.getDriver(), this.getJdbcUrl(), this.getJarsDirectory(), SerializableVerticaCredentials.class);
        this.fillConnectionData(cd);
        if (creds.authType == AuthType.PASSWORD) {
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("user", creds.user, false));
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("password", creds.password, true));
        } else if (creds.authType == AuthType.OAUTH2) {
            String token = creds.accessToken;
            if (logger.isTraceEnabled()) {
                if (token == null) {
                    logger.trace((Object)"Access token passed to vertica is null");
                } else if (!token.contains(".")) {
                    logger.trace((Object)"Access token passed to vertica doesn't look like a JWT token (no .)");
                } else {
                    String[] parts = token.split("\\.");
                    if (parts.length < 2) {
                        logger.trace((Object)"Access token passed to vertica doesn't look like a JWT token (less than 2 parts)");
                    } else {
                        logger.trace((Object)("Access token passed to vertica is " + parts[0] + "." + parts[1] + "[.signature_removed]"));
                    }
                }
            }
            cd.withProperty(new AbstractSQLConnection.CustomDatabaseProperty("oauthaccesstoken", token, true));
        }
        return cd;
    }

    @Override
    public ICredentialsService.OAuth2Credential getResolvedOAuth2Credential(AuthCtx authCtx) {
        return new ICredentialsService.OAuth2Credential(this.getAccessToken(authCtx, this.getProxySettings()).getAccessToken());
    }

    public OAuth2Client.AccessTokenResult getAccessToken(AuthCtx authCtx, ProxySettings proxySettings) {
        PasswordEncryptionService cryptoService = (PasswordEncryptionService)SpringUtils.getBean(PasswordEncryptionService.class);
        this.decryptFields(cryptoService);
        boolean useCache = this.getDkuPropertiesAsParams().getBoolParam("dku.connection.oauth.enableCache", true);
        logger.info((Object)"Exchanging user's refresh token for an access token");
        try {
            OAuth2Client oAuth2Client = this.buildOAuth2Client(proxySettings, authCtx);
            if (this.credentialsMode == DSSConnection.CredentialsMode.PER_USER) {
                return this.getAccessTokenFromRefreshTokenAndUpdateIfNeeded(authCtx, oAuth2Client, false);
            }
            return oAuth2Client.acquireAccessTokenResultWithClientCredentialsGrant(useCache);
        }
        catch (DKUSecurityException e) {
            throw new CodedRuntimeException(e.getCode(), "Failed to get OAuth2 access token", (Throwable)e);
        }
        catch (ParseException | IOException | URISyntaxException e) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Failed to get OAuth2 access token", e);
        }
    }

    @Override
    protected <T> T getFullyResolvedCredentials_internal(ConnectionWithBasicCredential.CredentialResolutionContext ctx, Class<T> clazz) throws DKUSecurityException, IOException, SQLException {
        assert (clazz.isAssignableFrom(SerializableVerticaCredentials.class));
        SerializableVerticaCredentials creds = new SerializableVerticaCredentials();
        creds.authType = this.params.authType;
        if (creds.authType == AuthType.PASSWORD) {
            ICredentialsService.BasicCredential basicCreds = ConnectionCredentialUtils.getDecryptedBasicCredential_autoTXN(this, ctx.authCtx);
            creds.user = basicCreds.user;
            creds.password = basicCreds.password;
        } else if (creds.authType == AuthType.OAUTH2) {
            OAuth2Client.AccessTokenResult accessTokenResult = this.getAccessToken(ctx.authCtx, this.getProxySettings());
            creds.accessToken = accessTokenResult.getAccessToken();
            long l = creds.accessTokenExpiresOn = accessTokenResult.getExpiresOn() == null ? -1L : accessTokenResult.getExpiresOn().getTime();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Access token expires on " + creds.accessTokenExpiresOn));
            }
            for (AbstractSQLConnection.CustomDatabaseProperty prop : ((DSSConnection)this).getDkuProperties()) {
                if (!"force.token.duration.ms".equals(prop.name)) continue;
                try {
                    long d = Long.parseLong(prop.value);
                    logger.info((Object)("Override token duration to " + d));
                    creds.accessTokenExpiresOn = System.currentTimeMillis() + d;
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to apply property " + prop.name), (Throwable)e);
                }
            }
        }
        return clazz.cast(creds);
    }

    static {
        logger = DKULogger.getLogger((String)"dip.vertica");
    }

    public static class Params
    extends AbstractSQLConnection.AbstractSQLParamsWithStdFields {
        public AuthType authType = AuthType.PASSWORD;
        public int port = 5433;
        public String clientId;
        public String clientSecret;
        public String authorizationEndpoint;
        public String tokenEndpoint;
        public String scope;
        public boolean refreshTokenRotation;
        public String audience;
        public boolean usePkce = true;
    }

    public static enum AuthType {
        PASSWORD,
        OAUTH2;

    }

    static class SerializableVerticaCredentials
    implements ICredentialsService.BasicCredentialConvertible,
    OAuth2Client.AccessTokenCredentialConvertible {
        public AuthType authType;
        public String user;
        public String password;
        public String accessToken;
        public long accessTokenExpiresOn;

        SerializableVerticaCredentials() {
        }

        @Override
        public ICredentialsService.BasicCredential toBasicCredential() {
            return new ICredentialsService.BasicCredential(this.user, this.password);
        }

        @Override
        public OAuth2Client.SerializableAccessTokenResult toSerializableAccessTokenResult() {
            return new OAuth2Client.SerializableAccessTokenResult(this.accessToken, this.accessTokenExpiresOn);
        }
    }
}

