/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class VersionTag
implements Serializable {
    private static final long serialVersionUID = -1L;
    public long versionNumber;
    private VersionTagUser lastModifiedBy;
    private long lastModifiedOn;
    private Map<String, Object> extendedProperties;

    public static VersionTag increment(VersionTag existingTag, String modifiedBy) {
        long versionNumber = existingTag == null ? 0L : existingTag.versionNumber + 1L;
        long modifiedOn = System.currentTimeMillis();
        return new VersionTag(modifiedBy, modifiedOn, versionNumber);
    }

    public VersionTag() {
    }

    public VersionTag(String lastModifiedBy) {
        this(lastModifiedBy, System.currentTimeMillis(), 0L);
    }

    public VersionTag(String lastModifiedBy, long modifiedOn, long versionNumber) {
        VersionTagUser vtu = new VersionTagUser();
        vtu.login = (String)Preconditions.checkNotNull((Object)lastModifiedBy);
        this.lastModifiedBy = vtu;
        this.versionNumber = versionNumber;
        this.lastModifiedOn = modifiedOn;
    }

    public void putExtendedProperty(String key, Object value) {
        if (this.extendedProperties == null) {
            this.extendedProperties = new HashMap<String, Object>();
        }
        this.extendedProperties.put(key, value);
    }

    public Map<String, Object> getExtendedProperties() {
        if (this.extendedProperties == null) {
            return new HashMap<String, Object>();
        }
        return this.extendedProperties;
    }

    public String toString() {
        return "#" + this.versionNumber + "[" + this.lastModifiedBy.login + "]";
    }

    public String getLastAuthor() {
        if (null == this.lastModifiedBy) {
            return null;
        }
        return this.lastModifiedBy.login;
    }

    public long getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public static class VersionTagUser
    implements Serializable {
        private static final long serialVersionUID = -1L;
        String login;
    }

    @UIModel
    public static class ConflictCheckResult {
        public boolean canBeSaved;
        public PublicUser lastModifiedBy;
        public long delta;
        public Long lastModifiedOn;
        public String message;
    }
}

