/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights.runnable;

import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.insights.runnable.DSSRunnableInsightParams;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.server.SpringUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class DSSRunnableInsightHandler
extends InsightHandler {
    @Autowired
    private IPermissionsService permissionsService;
    private final DSSRunnableInsightParams params;

    DSSRunnableInsightHandler(Insight insight) {
        this.params = (DSSRunnableInsightParams)insight.params;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public List<InsightHandler.RequiredPermission> getRequiredPermissions() {
        return Lists.newArrayList();
    }

    @Override
    public void checkSavePermissions(AuthCtx authCtx, Insight previous) throws UnauthorizedException {
        if (!(StringUtils.isBlank((String)this.params.runAsUser) || previous != null && this.params.runAsUser.equals(((DSSRunnableInsightParams)previous.params).runAsUser) || authCtx.getIdentifier().equals(this.params.runAsUser) || this.permissionsService.isAdmin(authCtx))) {
            throw new SecurityException("Only an administrator may set the 'Run as user' to another user");
        }
    }

    @Override
    public void savePayload(String payload, InsightsDAO dao) {
        assert (StringUtils.isBlank((String)payload));
    }

    @Override
    public String getPayload() throws IOException {
        return null;
    }
}

