/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dashboards.insights.staticfile;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.dashboards.insights.InsightHandler;
import com.dataiku.dip.dashboards.insights.InsightMeta;
import com.dataiku.dip.dashboards.insights.InsightsDAO;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.InsightParams;
import com.dataiku.dip.dashboards.model.TileParams;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class StaticFileInsightMeta {
    public static final String TYPE = "static_file";
    public static final InsightMeta META = new InsightMeta(){

        @Override
        public String getType() {
            return StaticFileInsightMeta.TYPE;
        }

        @Override
        public Class<? extends InsightParams> paramsClass() {
            return StaticFileInsightParams.class;
        }

        @Override
        public Class<? extends TileParams> tileParamsClass() {
            return StaticFileInsightTileParams.class;
        }

        @Override
        public InsightHandler buildHandler(Insight insight) {
            return new StaticFileInsightHandler(insight);
        }
    };
    private static Logger logger = Logger.getLogger((String)"dku.insights.static");

    private StaticFileInsightMeta() {
    }

    public static class StaticFileInsightHandler
    extends InsightHandler {
        final StaticFileInsightParams params;
        final Insight insight;

        public StaticFileInsightHandler(Insight insight) {
            if (!StaticFileInsightMeta.TYPE.equals(insight.type)) {
                throw ErrorContext.iaef((String)"Insight is not static: %s", (Object)insight.getFullId(), (Object[])new Object[0]);
            }
            this.insight = insight;
            this.params = (StaticFileInsightParams)insight.params;
        }

        @Override
        public List<InsightHandler.RequiredPermission> getRequiredPermissions() {
            return new ArrayList<InsightHandler.RequiredPermission>();
        }

        @Override
        public void checkSavePermissions(AuthCtx authCtx, Insight previous) {
        }

        @Override
        public void savePayload(String payload, InsightsDAO dao) throws IOException {
            if (payload != null) {
                File contentFile = this.getContentFile();
                logger.info((Object)("Write static file payload to: " + contentFile.getAbsolutePath()));
                int contentStartIndex = 0;
                String encodingPrefix = "base64,";
                int base64start = payload.indexOf(encodingPrefix);
                if (base64start >= 0) {
                    contentStartIndex = payload.indexOf(encodingPrefix) + encodingPrefix.length();
                }
                byte[] data = Base64.decodeBase64((String)payload.substring(contentStartIndex));
                FileUtils.writeByteArrayToFile((File)contentFile, (byte[])data);
            }
        }

        @Override
        public String getPayload() throws IOException {
            File contentFile = this.getContentFile();
            logger.info((Object)("Read static file payload to: " + contentFile.getAbsolutePath()));
            byte[] data = FileUtils.readFileToByteArray((File)contentFile);
            return Base64.encodeBase64String((byte[])data);
        }

        public File getContentFile() {
            Object filename = StringUtils.isBlank((String)this.params.filename) ? "data." + this.getFileExtension() : this.params.filename;
            return ApplicationConfigurator.getFile((String[])new String[]{"insights-data", this.insight.projectKey, StaticFileInsightMeta.TYPE, this.insight.id, filename});
        }

        private String getFileExtension() {
            switch (this.params.contentType.toLowerCase()) {
                case "image/png": {
                    return "png";
                }
                case "image/jpg": {
                    return "jpg";
                }
                case "image/gif": {
                    return "gif";
                }
                case "application/pdf": {
                    return "pdf";
                }
                case "text/html": {
                    return "html";
                }
            }
            return "dat";
        }

        public String getGenericType() {
            if (this.params.contentType != null) {
                if ("text/html".equals(this.params.contentType)) {
                    return "html";
                }
                if (this.params.contentType.startsWith("image/")) {
                    return "image";
                }
                if (this.params.contentType.endsWith("pdf")) {
                    return "pdf";
                }
            }
            return null;
        }
    }

    public static class StaticFileInsightTileParams
    implements TileParams {
    }

    public static class StaticFileInsightParams
    implements InsightParams {
        public String contentType;
        public String filename;
        public String filetype;
    }
}

