/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.cde;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineDef;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.ProcessResourceUsageMonitor;
import com.dataiku.dip.resourceusage.WithMaybePid;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;

public class CDEResourceMonitor
implements AutoCloseable {
    private final ComputeResourceUsage cru = new ComputeResourceUsage();
    private final ProcessResourceUsageMonitor monitor;

    public CDEResourceMonitor(ContainerizedDSSEngineDef cdeDef, JobActivity activity) {
        this.cru.type = ComputeResourceUsage.ComputeResourceUsageType.CONTAINERIZED_PROCESS;
        this.cru.context = ComputeResourceUsageContext.forCDE((AuthCtx)cdeDef.authCtx, (String)cdeDef.projectKey, (String)cdeDef.jobId, (String)activity.id());
        this.monitor = new ProcessResourceUsageMonitor(this.cru, "java", new WithMaybePid(){
            private int pid;

            public int getPidIfAvailable() {
                if (this.pid == 0) {
                    this.pid = DKUtils.getOwnPid();
                }
                return this.pid;
            }
        });
        this.start();
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private void start() {
        this.cru.reportStartNoFail();
        this.monitor.start();
    }

    private void stop() throws InterruptedException {
        this.monitor.finish(true);
        this.cru.reportCompleteNoFail();
    }
}

