/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io;

import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractInitializedRunner;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.FuzzyJoinRecords;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.builtinengine.io.Writer;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.datalayer.ColumnFactory;
import java.util.List;

public class IOHandler {
    private FuzzyJoinRecords queryRecords;
    private FuzzyJoinRecords candidateRecords;
    private final FuzzyJoinRecipePayloadParams.JoinDesc joinDesc;
    private final Writer writer;

    public IOHandler(JobActivity activity, List<AbstractInitializedRunner.Input> inputs, List<AbstractInitializedRunner.Output> outputs, FuzzyJoinRecipePayloadParams payload) throws Exception {
        this.joinDesc = payload.getJoinDescriptor();
        this.writer = new Writer(inputs, outputs.get(0), payload, activity, payload.debugMode);
        int referenceIndex = ((JoinInputDescBase)payload.virtualInputs.get((int)this.joinDesc.table1)).index;
        int queryIndex = ((JoinInputDescBase)payload.virtualInputs.get((int)this.joinDesc.table2)).index;
        AbstractInitializedRunner.Input referenceInput = inputs.get(referenceIndex);
        AbstractInitializedRunner.Input queryInput = inputs.get(queryIndex);
        this.candidateRecords = new FuzzyJoinRecords(this.joinDesc.table1, this.writer, (ColumnFactory)referenceInput.cf, referenceInput.schema, this.joinDesc.on);
        this.queryRecords = new FuzzyJoinRecords(this.joinDesc.table2, this.writer, (ColumnFactory)queryInput.cf, queryInput.schema, this.joinDesc.on);
        this.selectQueryDataset();
    }

    public FuzzyJoinRecords getCandidateRecords() {
        return this.candidateRecords;
    }

    public FuzzyJoinRecords getQueryRecords() {
        return this.queryRecords;
    }

    public int countQueries() {
        return this.countRows(this.queryRecords.table);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public FuzzyJoinRecipePayloadParams.JoinDesc getJoinDesc() {
        return this.joinDesc;
    }

    private int countRows(int table) {
        return this.writer.countRows(table);
    }

    private void selectQueryDataset() {
        if (this.countRows(this.queryRecords.table) < this.countRows(this.candidateRecords.table)) {
            FuzzyJoinRecords temp = this.queryRecords;
            this.queryRecords = this.candidateRecords;
            this.candidateRecords = temp;
        }
    }
}

