/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.joinlike;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.joinlike.ColumnDesc;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.utils.JSON;
import com.google.api.client.util.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public abstract class JoinLikeRecipeSchemaComputer
extends RecipeSchemaComputer {
    public JoinLikeRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    public void updateSelectedColumns(JoinRecipeSchemaComputer.JoinRecipeUpdateOptions options, RecipeSchemaService.RecipeSchemaAutoupdateResult ret, List<Schema> inputSchemas, JoinLikeRecipePayloadParams<?, ?, ?> params) {
        for (int i = 0; i < params.virtualInputs.size(); ++i) {
            JoinInputDescBase inputDesc = (JoinInputDescBase)params.virtualInputs.get(i);
            if (inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.AUTO_NON_CONFLICTING || inputDesc.outputColumnsSelectionMode == JoinInputDescBase.OutputColumnsSelectionMode.ALL) continue;
            HashSet currentSelectedColumns = Sets.newHashSet();
            for (ColumnDesc column : params.selectedColumns) {
                if (column.table != i) continue;
                currentSelectedColumns.add(column.name);
            }
            Schema schema = inputSchemas.get(i);
            block2: for (SchemaColumn column : schema.getColumns()) {
                if (currentSelectedColumns.contains(column.getName()) || !options.newSelectedColumns.containsKey(column.getType())) continue;
                List<ColumnDesc> templates = options.newSelectedColumns.get(column.getType());
                for (ColumnDesc template : templates) {
                    Matcher matcher;
                    if (template.table >= 0 && template.table != i || !Pattern.matches(template.name, column.getName())) continue;
                    ColumnDesc val = (ColumnDesc)JSON.deepCopy((Object)template);
                    val.name = column.getName();
                    val.table = i;
                    if (StringUtils.isNotBlank((String)template.alias) && (matcher = Pattern.compile(template.name).matcher(val.name)).matches()) {
                        StringBuffer sb = new StringBuffer();
                        matcher.appendReplacement(sb, template.alias);
                        val.alias = sb.toString();
                    }
                    params.addSelectedColumn(val);
                    ret.recipeChanges.add(String.format("Selected %s as %s", val.name, StringUtils.defaultIfBlank((String)val.alias, (String)val.name)));
                    continue block2;
                }
            }
        }
    }
}

