/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.upsert;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.QueryGenerationUtils;
import com.dataiku.dip.dataflow.exec.upsert.UpsertRecipePayloadParams;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.PrestoSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.sql.queries.SelectQueryBuilder;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class UpsertQueryGenerator {
    protected final ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
    protected final UpsertRecipePayloadParams params;
    protected final Dataset sourceDataset;
    protected final DatasetHandler.DatasetParams sourceParams;
    protected final SQLUtils.SQLTable sourceTable;
    protected final Dataset targetDataset;
    protected final DatasetHandler.DatasetParams targetParams;
    protected final SQLUtils.SQLTable targetTable;
    protected PartitioningScheme sourcePartitionScheme;
    protected List<Partition> sourcePartitions;
    protected PartitioningScheme targetPartitionScheme;
    protected String randomness;
    static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.upsert");

    public UpsertQueryGenerator(UpsertRecipePayloadParams params, Dataset sourceDataset, DatasetHandler.DatasetParams sourceParams, SQLUtils.SQLTable sourceTable, Dataset targetDataset, DatasetHandler.DatasetParams targetParams, SQLUtils.SQLTable targetTable) {
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkNotNull((Object)sourceDataset);
        Preconditions.checkNotNull((Object)sourceDataset.getSchema(), (Object)"Input dataset has no schema");
        this.sourceDataset = sourceDataset;
        this.targetDataset = targetDataset;
        this.sourceParams = sourceParams;
        this.targetParams = targetParams;
        this.sourceTable = sourceTable;
        this.targetTable = targetTable;
        this.params = params;
        this.randomness = SecretKeyGenerator.generate((int)6);
    }

    public void setPartitioning(PartitioningScheme sourcePartitionScheme, List<Partition> sourcePartitions, PartitioningScheme targetPartitionScheme) {
        this.sourcePartitionScheme = sourcePartitionScheme;
        this.sourcePartitions = sourcePartitions;
        this.targetPartitionScheme = targetPartitionScheme;
    }

    public String generateSourceSelect(SQLDialect dialect) {
        String source = dialect.getQuotedTableFullName(this.sourceTable);
        if (!(!this.params.computedColumns.isEmpty() || this.params.preFilter.enabled || this.sourcePartitionScheme != null && this.sourcePartitionScheme.isPartitioned())) {
            return source;
        }
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.sourceTable, null);
        if (this.params.computedColumns.isEmpty()) {
            for (SchemaColumn sc : this.sourceDataset.getSchema().getColumns()) {
                sqb.select(this.ebf.col(sc.getName()), sc.getName());
            }
        } else {
            QueryGenerationUtils.selectColumnsAndComputedColumns(sqb, this.params.computedColumns, dialect, this.sourceDataset.getSchema(), false);
        }
        if (this.params.preFilter.enabled) {
            QueryGenerationUtils.preFilter(sqb, this.params.preFilter, dialect, this.sourceDataset, false);
        }
        if (this.sourcePartitionScheme != null && this.sourcePartitionScheme.isPartitioned()) {
            ExpressionBuilder partitionFilterExpression = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.sourceDataset, this.sourcePartitions, dialect);
            sqb.where(partitionFilterExpression);
        }
        if (this.targetPartitionScheme != null && this.targetPartitionScheme.isPartitioned()) {
            SelectQueryBuilder wrapped = new SelectQueryBuilder();
            wrapped.from(sqb, "sub");
            for (SchemaColumn sc : this.targetDataset.getSchema().getColumns()) {
                if (this.targetPartitionScheme.getDimensionNames().contains(sc.getName())) {
                    wrapped.select(this.ebf.dstPartitionId(sc, this.targetPartitionScheme.getDimension(sc.getName())), sc.getName());
                    continue;
                }
                wrapped.select(this.ebf.col(sc.getName()), sc.getName());
            }
            sqb = wrapped;
        }
        return String.format("(\n%s\n)", sqb.toSQL(dialect));
    }

    public String generateTargetSelect(SQLDialect dialect) {
        String target = dialect.getQuotedTableFullName(this.targetTable);
        if (this.targetPartitionScheme == null || !this.targetPartitionScheme.isPartitioned()) {
            return target;
        }
        SelectQueryBuilder sqb = new SelectQueryBuilder();
        sqb.from(this.targetTable, null);
        ExpressionBuilder partitionFilterExpression = ExpressionUtils.getDstPartitionFilterClause(this.targetPartitionScheme, this.targetDataset, dialect);
        sqb.where(partitionFilterExpression);
        return String.format("(\n%s\n)", sqb.toSQL(dialect));
    }

    private SQLDialect.UpsertSpec getUpsertSpec(SQLDialect dialect) {
        SQLDialect.UpsertSpec spec = new SQLDialect.UpsertSpec();
        spec.targetDataset = this.targetDataset;
        spec.target = this.targetTable;
        spec.scheme = this.targetPartitionScheme;
        spec.temp = this.getUpsertTempTableName(dialect);
        spec.index = this.getUpsertIndexName(dialect);
        spec.sourceSelect = this.generateSourceSelect(dialect);
        spec.targetSelect = this.generateTargetSelect(dialect);
        spec.keys = this.params.keys.stream().map(k -> k.column).collect(Collectors.toList());
        spec.columns = this.targetDataset.getSchema().getColumns().stream().map(sc -> sc.getName()).collect(Collectors.toList());
        if (this.sourcePartitionScheme != null && this.sourcePartitionScheme.isPartitioned()) {
            spec.sourcePartitionFilter = ExpressionUtils.getPartitionFilterClause(this.sourcePartitionScheme, this.sourceDataset, this.sourcePartitions, dialect);
        }
        if (this.targetPartitionScheme != null && this.targetPartitionScheme.isPartitioned()) {
            spec.targetPartitionFilter = ExpressionUtils.getDstPartitionFilterClause(this.targetPartitionScheme, this.targetDataset, dialect);
        }
        return spec;
    }

    public String generateUpdateSQL(SQLDialect dialect) {
        SQLDialect.UpdateSelectWriter writer = dialect.getUpdateSelectWriter();
        if (writer != null) {
            return writer.generate(this.getUpsertSpec(dialect));
        }
        throw new NotImplementedException("Dialect cannot perform UPDATE from SELECT");
    }

    public String generateInsertUnmatchedSQL(SQLDialect dialect) {
        ArrayList<String> joinExprs;
        String sourceSelect = this.generateSourceSelect(dialect);
        String targetSelect = this.generateTargetSelect(dialect);
        String sourceAlias = dialect.quoteIdentifier("src");
        String targetAlias = dialect.quoteIdentifier("dst");
        String constant = dialect.quoteIdentifier("dku_join_cst");
        String targetWithConstantAlias = dialect.quoteIdentifier("dstc");
        ArrayList<String> finalFields = new ArrayList<String>();
        ArrayList<String> targetKeys = new ArrayList<String>();
        for (UpsertRecipePayloadParams.UpsertKey key : this.params.keys) {
            targetKeys.add(String.format("%s.%s", targetAlias, dialect.quoteIdentifier(key.column)));
        }
        for (Object sc : this.targetDataset.getSchema().getColumns()) {
            finalFields.add(String.format("%s.%s", sourceAlias, dialect.quoteIdentifier(sc.getName())));
        }
        if (dialect instanceof OracleSQLDialect) {
            joinExprs = new ArrayList<String>();
            for (UpsertRecipePayloadParams.UpsertKey upsertKey : this.params.keys) {
                joinExprs.add(String.format("%s.%s = %s.%s", targetAlias, dialect.quoteIdentifier(upsertKey.column), sourceAlias, dialect.quoteIdentifier(upsertKey.column)));
            }
            if (this.targetPartitionScheme != null && this.targetPartitionScheme.isPartitioned()) {
                ExpressionBuilder partitionFilterExpression = ExpressionUtils.getDstPartitionFilterClause(this.targetPartitionScheme, this.targetDataset, dialect);
                ExpressionUtils.aliasColumns(partitionFilterExpression, "dst");
                joinExprs.add(String.format("(%s)", partitionFilterExpression.toSQL(dialect)));
            }
            ArrayList targetFields = new ArrayList();
            for (SchemaColumn sc : this.targetDataset.getSchema().getColumns()) {
                targetFields.add(String.format("%s", dialect.quoteIdentifier(sc.getName())));
            }
            return String.format("MERGE INTO %s %s\nUSING %s %s\nON ( %s )\nWHEN NOT MATCHED THEN INSERT\n  ( %s )\nVALUES\n  ( %s )", dialect.getQuotedTableFullName(this.targetTable), targetAlias, sourceSelect, sourceAlias, joinExprs.stream().collect(Collectors.joining(" AND ")), targetFields.stream().collect(Collectors.joining(", ")), finalFields.stream().collect(Collectors.joining(", ")));
        }
        joinExprs = new ArrayList();
        for (UpsertRecipePayloadParams.UpsertKey upsertKey : this.params.keys) {
            joinExprs.add(String.format("%s.%s = %s.%s", targetWithConstantAlias, dialect.quoteIdentifier(upsertKey.column), sourceAlias, dialect.quoteIdentifier(upsertKey.column)));
        }
        String nonMatchFilter = String.format("%s IS NULL", constant);
        String string = String.format("SELECT 1 AS %s, %s FROM %s %s", constant, targetKeys.stream().collect(Collectors.joining(", ")), targetSelect, targetAlias);
        String join = String.format("SELECT\n  %s\nFROM %s %s\n  LEFT JOIN (\n%s\n            ) %s \n    ON %s \nWHERE %s", finalFields.stream().collect(Collectors.joining(", ")), sourceSelect, sourceAlias, string, targetWithConstantAlias, joinExprs.stream().collect(Collectors.joining(" AND ")), nonMatchFilter);
        return String.format("INSERT INTO %s\n%s", dialect.getQuotedTableFullName(this.targetTable), join);
    }

    private SQLUtils.SQLTable makeDerivedName(SQLDialect dialect, String name, boolean partitionLevel) {
        ArrayList keys = new ArrayList();
        this.params.keys.stream().map(k -> k.column).collect(Collectors.toList());
        Collections.sort(keys);
        String keysHash = new Base32().encodeAsString(DigestUtils.md5((String)keys.stream().collect(Collectors.joining())));
        name = (String)name + keysHash.replace("=", "");
        if (partitionLevel) {
            name = (String)name + this.randomness;
        }
        if (dialect.getIdentifiersMaxLength() > 0) {
            VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
            VariablesContext vc = variablesService.getContext(this.targetDataset.getProjectKey());
            String expandedName = vc.expand((String)name);
            name = StringTransmogrifier.shortenKeepUnicity((String)expandedName, (int)dialect.getIdentifiersMaxLength());
        }
        return new SQLUtils.SQLTable(this.targetTable.getCatalog(), this.targetTable.getSchemaNullIfBlank(), (String)name);
    }

    public SQLUtils.SQLTable getUpsertIndexName(SQLDialect dialect) {
        if (StringUtils.isNotBlank((String)this.params.upsertIndexName)) {
            return new SQLUtils.SQLTable(this.targetTable.getCatalog(), this.targetTable.getSchemaNullIfBlank(), this.params.upsertIndexName);
        }
        return this.makeDerivedName(dialect, this.targetTable.getTable() + "_dkuupsidx", false);
    }

    public SQLUtils.SQLTable getUpsertTempTableName(SQLDialect dialect) {
        return this.makeDerivedName(dialect, this.targetTable.getTable() + "_dkuupstmp", true);
    }

    public String generateCreateIndex(SQLDialect dialect) {
        SQLDialect.UniqueConstraintWriter writer = dialect.getUniqueConstraintWriter();
        if (writer != null) {
            return writer.generateCreate(this.getUpsertSpec(dialect));
        }
        throw new NotImplementedException("Unable to create unicity constraints");
    }

    public String generateDropIndex(SQLDialect dialect) {
        SQLDialect.UniqueConstraintWriter writer = dialect.getUniqueConstraintWriter();
        if (writer != null) {
            return writer.generateDrop(this.getUpsertSpec(dialect));
        }
        throw new NotImplementedException("Unable to create unicity constraints");
    }

    public String generateCreateTempTable(SQLDialect dialect) {
        SQLDialect.MaterializedTemporaryTableWriter writer = dialect.getMaterializedTemporaryTableWriter();
        return writer.generateCreateTemp(this.getUpsertSpec(dialect));
    }

    public String generateDropTempTable(SQLDialect dialect) {
        SQLDialect.MaterializedTemporaryTableWriter writer = dialect.getMaterializedTemporaryTableWriter();
        return writer.generateDropTemp(this.getUpsertSpec(dialect));
    }

    public String generateUpsertSQL(SQLDialect dialect) {
        SQLDialect.UpsertWriter writer = dialect.getUpsertWriter();
        if (writer != null) {
            return writer.generate(this.getUpsertSpec(dialect));
        }
        throw new NotImplementedException("Dialect cannot perform UPSERT");
    }

    public String generatePrepareDataSelectSQL(SQLDialect dialect) {
        String sourceSelect = this.generateSourceSelect(dialect);
        String targetSelect = this.generateTargetSelect(dialect);
        String sourceAlias = dialect.quoteIdentifier("src");
        String targetAlias = dialect.quoteIdentifier("dst");
        String constant = dialect.quoteIdentifier("dku_join_cst");
        String sourceWithConstantAlias = dialect.quoteIdentifier("srcc");
        ArrayList<String> finalFields = new ArrayList<String>();
        ArrayList<String> targetFields = new ArrayList<String>();
        ArrayList<String> sourceFields = new ArrayList<String>();
        for (Object sc : this.targetDataset.getSchema().getColumns()) {
            sourceFields.add(String.format("%s.%s", sourceAlias, dialect.quoteIdentifier(sc.getName())));
        }
        for (Object sc : this.targetDataset.getSchema().getColumns()) {
            finalFields.add(String.format("CASE WHEN %s.%s IS NULL THEN %s.%s ELSE %s.%s END AS %s", sourceWithConstantAlias, constant, targetAlias, dialect.quoteIdentifier(sc.getName()), sourceWithConstantAlias, dialect.quoteIdentifier(sc.getName()), dialect.quoteIdentifier(sc.getName())));
            targetFields.add(String.format("%s.%s AS %s", targetAlias, dialect.quoteIdentifier(sc.getName()), dialect.quoteIdentifier(sc.getName())));
        }
        ArrayList<String> joinExprs = new ArrayList<String>();
        for (UpsertRecipePayloadParams.UpsertKey key : this.params.keys) {
            joinExprs.add(String.format("%s.%s = %s.%s", sourceWithConstantAlias, dialect.quoteIdentifier(key.column), targetAlias, dialect.quoteIdentifier(key.column)));
        }
        String source = String.format("SELECT\n  %s FROM %s %s", sourceFields.stream().collect(Collectors.joining("\n, ")), sourceSelect, sourceAlias);
        String sourceWithConstant = String.format("SELECT\n  1 AS %s\n, %s FROM %s %s", constant, sourceFields.stream().collect(Collectors.joining("\n, ")), sourceSelect, sourceAlias);
        String join = String.format("SELECT\n  %s\nFROM %s %s\n  FULL OUTER JOIN (\n%s\n            ) %s \n    ON %s", finalFields.stream().collect(Collectors.joining("\n, ")), targetSelect, targetAlias, sourceWithConstant, sourceWithConstantAlias, joinExprs.stream().collect(Collectors.joining(" AND ")));
        String keptFromDst = String.format("SELECT\n  %s\nFROM %s %s\n  LEFT JOIN (\n%s\n            ) %s \n    ON %s\n    WHERE %s.%s IS NULL", targetFields.stream().collect(Collectors.joining("\n, ")), targetSelect, targetAlias, sourceWithConstant, sourceWithConstantAlias, joinExprs.stream().collect(Collectors.joining(" AND ")), sourceWithConstantAlias, constant);
        if (dialect instanceof OracleSQLDialect) {
            return join;
        }
        return String.format("%s\nUNION ALL\n%s", source, keptFromDst);
    }

    public String generatePrepareDataSQL(SQLDialect dialect) {
        SQLUtils.SQLTable tempTable = this.getUpsertTempTableName(dialect);
        String join = this.generatePrepareDataSelectSQL(dialect);
        if (dialect instanceof HiveSQLDialect && !(dialect instanceof PrestoSQLDialect)) {
            return String.format("INSERT INTO TABLE %s\n%s", dialect.getQuotedTableFullName(tempTable), join);
        }
        return String.format("INSERT INTO %s\n%s", dialect.getQuotedTableFullName(tempTable), join);
    }

    public String generateTruncateDataSQL(SQLDialect dialect) {
        SQLDialect.MaterializedTemporaryTableWriter writer = dialect.getMaterializedTemporaryTableWriter();
        return writer.generateTruncateReal(this.getUpsertSpec(dialect), this.targetPartitionScheme);
    }

    public String generateCopyDataSQL(SQLDialect dialect) {
        SQLDialect.MaterializedTemporaryTableWriter writer = dialect.getMaterializedTemporaryTableWriter();
        return writer.generateCopy(this.getUpsertSpec(dialect));
    }
}

