/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graph.utils;

import com.dataiku.dip.dataflow.Job;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.utils.SubgraphPrinter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.utils.CollectionUtils;
import java.util.HashSet;
import java.util.Set;

public class JobPrinter {
    private static String indent(int indent) {
        Object s = "";
        for (int i = 0; i < indent; ++i) {
            s = (String)s + "  ";
        }
        return s;
    }

    private static void printRec(StringBuilder sb, JobActivity ja, int curIndent, Set<String> alreadyPrinted) {
        sb.append(JobPrinter.indent(curIndent) + "ACTIVITY " + ja.id() + (ja.pruned ? " *** PRUNED ***" : "") + JobPrinter.eol());
        if (ja.getSubgraph() != null) {
            sb.append(SubgraphPrinter.print(ja.getSubgraph(), curIndent, false));
            alreadyPrinted.add(ja.id());
        }
        if (ja.pruned) {
            sb.append(JobPrinter.indent(curIndent + 1) + "DEPS: Not printed (pruned)" + JobPrinter.eol());
        } else {
            if (ja.dependencies.size() != 0) {
                sb.append(JobPrinter.indent(curIndent + 1) + "DEPS" + JobPrinter.eol());
            }
            for (JobActivity activity : ja.dependencies) {
                if (alreadyPrinted.contains(activity.id())) {
                    sb.append(JobPrinter.indent(curIndent + 2) + "NON-PRINTED DEP (already printed): " + activity.id() + JobPrinter.eol());
                    continue;
                }
                JobPrinter.printRec(sb, activity, curIndent + 2, alreadyPrinted);
            }
        }
    }

    public static String print(Job job, int startIndent) {
        HashSet<String> alreadyPrinted = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        sb.append(JobPrinter.indent(startIndent) + "JOB" + JobPrinter.eol());
        JobPrinter.printRec(sb, job.topLevelActivity, startIndent + 1, alreadyPrinted);
        return sb.toString();
    }

    private static void appendAttrs(StringBuilder sb, String ... attrs) {
        if (attrs.length != 0) {
            boolean first = true;
            sb.append(" [");
            for (String attr : attrs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(attr);
            }
            sb.append("]");
        }
    }

    private static void appendNodeName(StringBuilder sb, String nodeName, String ... attrs) {
        sb.append("  " + nodeName);
        JobPrinter.appendAttrs(sb, attrs);
        sb.append(";" + JobPrinter.eol());
    }

    private static void link(StringBuilder sb, String source, String target, String ... attrs) {
        sb.append("  " + source + " -> " + target);
        JobPrinter.appendAttrs(sb, attrs);
        sb.append(";" + JobPrinter.eol());
    }

    private static void linkIfNeeded(Set<String> alreadyLinked, StringBuilder sb, String source, String target, String ... attrs) {
        String linkName = source + "-" + target;
        if (!alreadyLinked.contains(linkName)) {
            JobPrinter.link(sb, source, target, new String[0]);
            alreadyLinked.add(linkName);
        }
    }

    private static String quoted(String str) {
        return "\"" + str + "\"";
    }

    private static String cleanName(String str) {
        return str.replace("-", "_");
    }

    private static void printRecAsDOT(StringBuilder sb, JobActivity ja, Set<String> alreadyLinked, Set<String> alreadyPrintedDS) {
        if (ja.getSubgraph() != null) {
            for (FlowComputable flowComputable : ja.getSubgraph().getTargets()) {
                Partition p = ja.getSubgraph().getTargetPartition(flowComputable);
                String nodeName = JobPrinter.cleanName(flowComputable.getFullId()) + "_" + JobPrinter.cleanName(p.id());
                if (alreadyPrintedDS.contains(nodeName)) continue;
                JobPrinter.appendNodeName(sb, nodeName, "style=filled", "fillcolor=" + JobPrinter.quoted("#ccffcc"));
                alreadyPrintedDS.add(nodeName);
            }
        }
        for (JobActivity jobActivity : ja.dependencies) {
            JobPrinter.printRecAsDOT(sb, jobActivity, alreadyLinked, alreadyPrintedDS);
        }
        if (ja.getSubgraph() != null) {
            for (FlowComputable flowComputable : ja.getSubgraph().getSources()) {
                if (ja.getSubgraph().getSourcePartitions(flowComputable) == null) continue;
                for (Partition ps2 : ja.getSubgraph().getSourcePartitions(flowComputable)) {
                    String string = JobPrinter.cleanName(flowComputable.getFullId()) + "_" + JobPrinter.cleanName(ps2.id());
                    if (!alreadyPrintedDS.contains(string)) {
                        JobPrinter.appendNodeName(sb, string, "style=filled", "fillcolor=" + JobPrinter.quoted("#ccccff"));
                    }
                    alreadyPrintedDS.add(string);
                    sb.append(JobPrinter.eol());
                    for (FlowComputable flowComputable2 : ja.getSubgraph().getTargets()) {
                        Partition pt = ja.getSubgraph().getTargetPartition(flowComputable2);
                        String targetNodeName = JobPrinter.cleanName(flowComputable2.getFullId()) + "_" + JobPrinter.cleanName(pt.id());
                        JobPrinter.linkIfNeeded(alreadyLinked, sb, string, targetNodeName, new String[0]);
                    }
                }
            }
            if (ja.getSubgraph() instanceof RecipeRunnableSubgraph && ((RecipeRunnableSubgraph)ja.getSubgraph()).getRecipe().isGenerator()) {
                FlowComputable onlyTarget = ja.getSubgraph().getTargets().get(0);
                String string = ((Partition)CollectionUtils.getMapOnlyValue(ja.getSubgraph().getTargetPartitions())).id();
                String nodeName = "task_" + JobPrinter.cleanName(((RecipeRunnableSubgraph)ja.getSubgraph()).getRecipe().getName()) + JobPrinter.cleanName(onlyTarget.getFullId()) + "_" + JobPrinter.cleanName(string);
                if (!alreadyPrintedDS.contains(nodeName)) {
                    JobPrinter.appendNodeName(sb, nodeName, "style=filled", "shape=rectangle");
                }
                alreadyPrintedDS.add(nodeName);
                sb.append(JobPrinter.eol());
                for (FlowComputable flowComputable : ja.getSubgraph().getTargets()) {
                    Partition pt = ja.getSubgraph().getTargetPartition(flowComputable);
                    String string2 = JobPrinter.cleanName(flowComputable.getFullId()) + "_" + JobPrinter.cleanName(pt.id());
                    JobPrinter.linkIfNeeded(alreadyLinked, sb, nodeName, string2, new String[0]);
                }
            }
        }
    }

    private static String eol() {
        return System.getProperty("line.separator");
    }

    public static String printAsDOT(Job job) {
        HashSet<String> alreadyPrinted = new HashSet<String>();
        HashSet<String> alreadyLinked = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("digraph g {" + JobPrinter.eol() + "  rankdir = LR;" + JobPrinter.eol() + JobPrinter.eol());
        JobPrinter.printRecAsDOT(sb, job.topLevelActivity, alreadyPrinted, alreadyLinked);
        sb.append("}" + JobPrinter.eol());
        return sb.toString();
    }
}

