/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.graphtools;

import com.dataiku.dip.dataflow.graphtools.AbstractUserTimeView;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;

public class LastModificationView
extends AbstractUserTimeView {
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.tools.lastModified");

    public LastModificationView(AuthCtx authCtx, String projectKey, JsonObject toolInitialData) {
        super(authCtx, projectKey);
    }

    @Override
    protected void add(String nodeId, TaggableObjectsService.TaggableObject to) {
        try {
            if (to.versionTag == null) {
                return;
            }
            AbstractUserTimeView.ModificationDesc m = new AbstractUserTimeView.ModificationDesc();
            m.time = to.versionTag.getLastModifiedOn();
            m.userLogin = to.versionTag.getLastAuthor();
            if (m.userLogin != null) {
                m.userDisplayName = this.getUserDisplayName(m.userLogin);
            }
            this.state.valueByNode.put(nodeId, m);
        }
        catch (Exception e) {
            logger.info((Object)"Failed to get last modification data", (Throwable)e);
        }
    }
}

