/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.dip.dataflow.kernel.master.locking.BalancedPrioritizationStrategy;
import com.google.common.base.Preconditions;
import java.util.Set;

public class ActivityRunRequest
implements BalancedPrioritizationStrategy.PermitRequestWithGroup<String> {
    public final String projectKey;
    public final String jobId;
    public final String userIdentifier;
    public final Set<Recipe> recipes;
    public final Set<String> recipeTypes;
    public final Set<String> tags;
    public final Set<String> resourceKeys;
    public final Set<String> involvedConnections;

    public ActivityRunRequest(String projectKey, String jobId, String userIdentifier, Set<Recipe> recipeSet, Set<String> recipeTypes, Set<String> tags, Set<String> resourceKeys, Set<String> involvedConnections) {
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull(recipeSet);
        Preconditions.checkNotNull(recipeTypes);
        Preconditions.checkNotNull(tags);
        Preconditions.checkNotNull(resourceKeys);
        Preconditions.checkNotNull(involvedConnections);
        this.projectKey = projectKey;
        this.jobId = jobId;
        this.userIdentifier = userIdentifier;
        this.recipes = recipeSet;
        this.involvedConnections = involvedConnections;
        this.recipeTypes = recipeTypes;
        this.tags = tags;
        this.resourceKeys = resourceKeys;
    }

    public String getJobFullId() {
        return this.projectKey + "." + this.jobId;
    }

    @Override
    public String getPermitGroupKey() {
        return this.getJobFullId();
    }

    public static class Recipe {
        public final String projectKey;
        public final String name;
        public final int maxRunningActivities;

        public Recipe(String projectKey, String name, int maxRunningActivities) {
            Preconditions.checkNotNull((Object)projectKey);
            Preconditions.checkNotNull((Object)name);
            this.projectKey = projectKey;
            this.name = name;
            this.maxRunningActivities = maxRunningActivities;
        }

        public String getFullName() {
            return this.projectKey + "." + this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Recipe recipe = (Recipe)o;
            return this.projectKey.equals(recipe.projectKey) && this.name.equals(recipe.name);
        }

        public int hashCode() {
            return 31 * this.projectKey.hashCode() + this.name.hashCode();
        }
    }
}

